<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:variable name ="min_inst_id">
    <xsl:call-template name ="min">
      <xsl:with-param name ="list"
        select="/report/sql_monitor_list_report/sql/inst_id"/>
    </xsl:call-template>
  </xsl:variable>

  <xsl:variable name ="max_inst_id">
    <xsl:call-template name ="max">
      <xsl:with-param name ="list"
        select="/report/sql_monitor_list_report/sql/inst_id"/>
    </xsl:call-template>
  </xsl:variable>

  <xsl:template match="/">
  <html>
   <head>
     <title> SQL Monitor List </title>
     <style type="text/css">
         body, table, input, select, textarea
         {font:normal normal 8pt Verdana,Arial;
          text-decoration:none;
          color:#000000; empty-cells:show;
          cellspacing:5; cellpadding:5;
          border-collapse: collapse; 
         }
         .thead
           { font:bold 8pt Arial,Helvetica,Geneva,sans-serif;
             color:White;
             background:#0066CC;
             padding-left:3px;
             padding-right:3px;
             padding-bottom:2px;
             padding-top:2px;
           }
         .tcell { padding-left:3px;
              padding-right:3px;
              padding-bottom:2px;
              padding-top:2px;}
         .s9 {font-size:10pt;color:#006699}
         .row0 { background-color:#ffffff}
         .row1 { background-color:#ffffcc}
     </style>
   </head>
   <body>
     <br/>
     <table border="0" cellspacing="0" cellpadding="0" width="100%">
      <tr>
        <th align="center"/>
      </tr>
      <tr>
        <th align="center">
           SQL Monitoring List
        </th>
      </tr>
      <tr>
        <th align="center">
           =====================
        </th>
      </tr>
     </table>
     <br/>
     <br/>
     <table border="1" ora_headercharhorz="=" ora_headercharvert="|"
            ora_footercharhorz="=" ora_borderstyle="headeronly"
            cellspacing="0" cellpadding="0" width="100%">
       <tr class="thead">
        <th align="center">
           Status
         </th>
         <th width="120" align="center">
           Duration
         </th>
         <xsl:if test="$min_inst_id != $max_inst_id">
           <th align="center">
             Inst Id
           </th>
         </xsl:if>
         <th align="center">
           SQL Id
         </th>
         <th align="center">
           Exec Id
         </th>
         <th align="center">
           Start
         </th>
         <th align="center">
           User
         </th>
         <th align="center">
           Module/Action
         </th>
         <th align="center">
           Dop
         </th>
         <th width="120" align="center">
           DB Time
         </th>
         <th width="120" align="center">
           IOs
         </th>
         <th width="30%" align="center">
           SQL Text
         </th>
       </tr>
       <xsl:apply-templates
              select="/report/sql_monitor_list_report/sql"/>
     </table>
   </body>
 </html>
</xsl:template>


<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!--                         begin function definitions                     -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->

<!-- ++++++++++++++++++++++++++++ normalize +++++++++++++++++++++++++++++++ -->
<xsl:template name="normalize">
<xsl:param name="n"/>
<xsl:choose>
  <xsl:when test="boolean($n) = false() or $n = '' or string($n) = 'NaN'">
    <P class="nodisp"></P>
  </xsl:when>
  <xsl:when test="$n &lt; 100000">
    <xsl:value-of select="string($n)"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000">
    <xsl:value-of select="concat(string(round($n div 1000)), 'K')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000">
    <xsl:value-of select="concat(string(round($n div 1000000)), 'M')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000000">
    <xsl:value-of select="concat(string(round($n div 1000000000)), 'G')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000000000">
    <xsl:value-of select="concat(string(round($n div 1000000000000)), 'T')"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of
       select="concat(string(round($n div 1000000000000000)), 'P')"/>
  </xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- +++++++++++++++++++++++++ normalize_bytes ++++++++++++++++++++++++++++ -->
<xsl:template name="normalize_bytes">
<xsl:param name="n"/>
<xsl:choose>
  <xsl:when test="boolean($n) = false() or $n = '' or $n = 'NaN'">
    <P class="nodisp">.</P>
  </xsl:when>
  <xsl:when test="$n &lt; 100000">
    <xsl:value-of select="concat(string($n), 'Bytes')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000">
    <xsl:value-of select="concat(string(round($n div 1024)), 'KB')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000">
    <xsl:value-of select="concat(string(round($n div 1048576)), 'MB')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000000">
    <xsl:value-of select="concat(string(round($n div 1073741824)), 'GB')"/>
  </xsl:when>
  <xsl:when test="$n &lt; 1000000000000000">
    <xsl:value-of select="concat(string(round($n div 1099511627776)), 'TB')"/>
  </xsl:when>
  <xsl:otherwise>
    <xsl:value-of
              select="concat(string(round($n div 1125899906842624)), 'PB')"/>
  </xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- ++++++++++++++ translate monitor name template ++++++++++++++++++++++ -->
<xsl:template name="translate_monitor_name">
<xsl:param name="label"/>
<xsl:choose>
  <xsl:when test="$label = 'elapsed_time'">Elapsed</xsl:when>
  <xsl:when test="$label = 'cpu_time'">Cpu</xsl:when>
  <xsl:when test="$label = 'sql_cpu_time'">Sql Cpu Time</xsl:when>
  <xsl:when test="$label = 'user_io_wait_time'">IO Time</xsl:when>
  <xsl:when
    test="$label = 'application_wait_time'">Application Wait Time</xsl:when>
  <xsl:when
    test="$label = 'concurrency_wait_time'">Concurrency Wait Time</xsl:when>
  <xsl:when test="$label = 'cluster_wait_time'">Cluster Wait Time</xsl:when>
  <xsl:when test="$label = 'other_wait_time'">Other Wait Time</xsl:when>
  <xsl:when test="$label = 'user_fetch_count'">Fetch Calls</xsl:when>
  <xsl:when test="$label = 'buffer_gets'">Buffer Gets</xsl:when>
  <xsl:when test="$label = 'plsql_exec_time'">PL/SQL Time</xsl:when>
  <xsl:when test="$label = 'java_exec_time'">Java Time</xsl:when>
  <xsl:when test="$label = 'io_cell_filter_perc'">IO Cell<br/>Filter(%)
  </xsl:when>
  <xsl:when test="$label = 'read_reqs'">Read Requests</xsl:when>
  <xsl:when test="$label = 'read_bytes'">Read Bytes</xsl:when>
  <xsl:when test="$label = 'write_reqs'">Write Requests</xsl:when>
  <xsl:when test="$label = 'write_bytes'">Write Bytes</xsl:when>
  <xsl:otherwise><xsl:value-of select="$label"/></xsl:otherwise>
</xsl:choose>
</xsl:template>


<!-- ++++++++++++++++++++++++++++ max +++++++++++++++++++++++++++++++ -->
<xsl:template name ="max">
  <xsl:param name ="list" />
  <xsl:choose >
   <xsl:when test ="$list">
    <xsl:variable name ="first" select ="$list[1]"/>
    <xsl:variable name ="rest">
     <xsl:call-template name ="max">
      <xsl:with-param name ="list" select ="$list[position() != 1]" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
     <xsl:when test="$first &gt; $rest">
      <xsl:value-of select ="$first"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select ="$rest"/>      
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>0</xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- ++++++++++++++++++++++++++++ max_io_requests +++++++++++++++++++++ -->
<xsl:template name ="max_io_requests">
  <xsl:param name ="list"/>
  <xsl:choose>
   <xsl:when test ="$list[1]">
     <xsl:variable name ="first"
       select ="$list[1]/stat[@name = 'read_reqs'] +
                $list[1]/stat[@name = 'write_reqs']"/>
    <xsl:variable name ="rest">
     <xsl:call-template name ="max_io_requests">
       <xsl:with-param name ="list" select ="$list[position() != 1]" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
     <xsl:when test="$first &gt; $rest">
      <xsl:value-of select ="$first"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select ="$rest"/>      
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>0</xsl:otherwise>   
  </xsl:choose>
</xsl:template>

<!-- ++++++++++++++++++++++++++++ min +++++++++++++++++++++++++++++++ -->
<xsl:template name ="min">
  <xsl:param name ="list" />
  <xsl:choose >
   <xsl:when test ="$list">
    <xsl:variable name ="first" select ="$list[1]"/>
    <xsl:variable name ="rest">
     <xsl:call-template name ="min">
      <xsl:with-param name ="list" select ="$list[position() != 1]" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
     <xsl:when test="$first &lt; $rest">
      <xsl:value-of select ="$first"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select ="$rest"/>      
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
   <xsl:otherwise>9999999999999</xsl:otherwise>
  </xsl:choose>
</xsl:template>


<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!--                         begin template definitions                     -->
<!-- ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ -->
<!-- ++++++++++++++++++++++++++++ main template +++++++++++++++++++++++++++ -->
<xsl:template match="sql">

  <xsl:variable name="module" select="substring(module, 1, 15)"/>

  <xsl:variable name ="action" select="substring(action, 1, 15)"/>

  <xsl:variable name="module_action">
    <xsl:choose>
      <xsl:when test="$action and $module">
        <xsl:value-of select="concat($module, '/', $action)"/>
      </xsl:when>
      <xsl:when test="$action">
        <xsl:value-of select="concat('-/', $action)"/>
      </xsl:when>
      <xsl:when test="$module">
        <xsl:value-of select="concat($module, '/-')"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="''"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name ="elapsed">
    <xsl:if test="stats[@type = 'monitor']/stat[@name = 'elapsed_time']">
      <xsl:value-of
        select="stats[@type = 'monitor']/stat[@name = 'elapsed_time']
                 div 1000000"/>
    </xsl:if>
  </xsl:variable>

  <xsl:variable name ="duration"
       select="stats[@type = 'monitor']/stat[@name = 'duration']"/>

  <xsl:variable name ="queuing_duration">
    <xsl:if test="stats[@type = 'monitor']/stat[@name = 'queuing_time']">
      <xsl:value-of
        select="stats[@type = 'monitor']/stat[@name = 'queuing_time']
                div 1000000"/>
    </xsl:if>
  </xsl:variable>
  
  <tr width="100%">

     <xsl:attribute name="class">
       row<xsl:value-of select="position() mod 2"/>
     </xsl:attribute>

    <td class="tcell">
      <xsl:value-of select="status"/>
    </td>
    <td class="tcell" align="right">
      <xsl:choose>
        <xsl:when test="not($duration)">
        </xsl:when>
        <xsl:when test="$duration &lt; 1">
          <xsl:value-of
            select="concat(format-number($duration, '0.00'), 's')"/>
        </xsl:when>
        <xsl:when test="$duration &lt; 10">
          <xsl:value-of select="concat(format-number($duration, '0.0'), 's')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat(format-number($duration, '0'), 's')"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="string(number($queuing_duration)) = 'NaN'">
        </xsl:when>
        <xsl:when test="not($queuing_duration)">
        </xsl:when>
        <xsl:when test="round($queuing_duration) = 0">
        </xsl:when>
        <xsl:when test="$queuing_duration &lt; 10">
          <xsl:value-of select="concat(' (', 
                                       format-number($queuing_duration, '0.0'),
                                       's)')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat(' (', 
                                       format-number($queuing_duration, '0'),
                                       's)')"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <xsl:if test="$min_inst_id != $max_inst_id">
      <td class="tcell" align="center">
        <xsl:value-of select="inst_id"/>
      </td>
    </xsl:if>
    <td class="tcell" align="center">
      <xsl:value-of select="@sql_id"/>
    </td>
    <td class="tcell" align="center">
      <xsl:value-of select="@sql_exec_id"/>
    </td>
    <td class="tcell" align="center">
      <xsl:value-of select="@sql_exec_start"/>
    </td>
    <td class="tcell">
      <xsl:value-of select="user"/>
    </td>
    <td class="tcell">
      <xsl:value-of select="$module_action"/>
    </td>
    <td class="tcell" align="center">
      <xsl:variable name="downgrade">
        <xsl:if test="px_servers_requested and
                      px_servers_requested != px_servers_allocated">
          <xsl:value-of select="'-'"/>
        </xsl:if>      
      </xsl:variable>
      <xsl:variable name="downgrade_label">
        <xsl:if test="$downgrade = '-'">
          <xsl:value-of select="concat(' (-',
                                       round(((px_servers_requested -
                                        px_servers_allocated) * 100)
                                        div px_servers_requested), '%: ',
                                        px_servers_requested, '->',
                                        px_servers_allocated, ')')"/>
        </xsl:if>      
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="instances and instances > 1">
          <xsl:value-of select="concat(string(dop), ':', string(instances),
                                $downgrade_label)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat(string(dop), $downgrade_label)"/>
        </xsl:otherwise>
       </xsl:choose>
    </td>
    <td class="tcell" align="right">
      <xsl:choose>
        <xsl:when test="string(number($elapsed)) = 'NaN'">
        </xsl:when>
        <xsl:when test="$elapsed &lt; 1">
          <xsl:value-of
            select="concat(format-number($elapsed, '0.00'), 's')"/>
        </xsl:when>
        <xsl:when test="$elapsed &lt; 10">
          <xsl:value-of select="concat(format-number($elapsed, '0.0'), 's')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat(format-number($elapsed, '0'), 's')"/>
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td class="tcell" align="right">
      <xsl:call-template name="normalize">
        <xsl:with-param name="n"
              select="sum(stats[@type = 'monitor']/
                              stat[@name = 'read_reqs' or
                                   @name = 'write_reqs'])"/>
      </xsl:call-template>
    </td>
    <td class="tcell">
      <xsl:choose>
        <xsl:when test="string-length(sql_text) &gt; 200">
          <xsl:value-of select="concat(substring(sql_text, 1, 200), '...')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="sql_text"/>          
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

</xsl:stylesheet>
