Rem
Rem $Header: rdbms/admin/catxtbix.sql /main/16 2009/06/02 17:09:44 schakrab Exp $
Rem
Rem catxtbix.sql
Rem
Rem Copyright (c) 2004, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      catxtbix.sql - XMLTableIndex related schema objects
Rem
Rem    DESCRIPTION
Rem     This script creates the views, packages, index types, operators and 
Rem     indexes required for supporting the XMLTableIndex
Rem
Rem    NOTES
Rem      This script should be run as "XDB".
Rem
Rem    MODIFIED     (MM/DD/YY)
Rem    thbaby       05/21/09 - remove xtimetadata_pkg
Rem    sipatel      09/16/08 - #(7414934) - change schema from sys to xdb 
Rem    thbaby       07/30/08 - disable xmltableindex indextype
Rem    bhammers     10/30/07 - change ODCIIndexGetMetadata for imp/exp
Rem                            deactivate ODCIIndexUtilGetTableNames
Rem                            added xtimetadata_pkg package
Rem    hxzhang      03/18/08 - coltype to varchar2(100)
Rem    shvenugo     10/04/07 - partitioning
Rem    hxzhang      08/27/07 - add add/drop column 
Rem    hxzhang      05/16/07 - change xpath to varchar2(4000)
Rem    bhammers     04/19/07 - add flag for orig col type
Rem    hxzhang      06/26/06 - add group# 
Rem    hxzhang      06/06/06 - add flag column to xtabcols
Rem    rburns       05/05/06 - rename script 
Rem    hxzhang      12/14/05 - Created

declare
  exist number;
  sys_exist number;
begin
  select count(*) into exist from DBA_TABLES where table_name = 'XDB$XTAB'
  and owner = 'XDB';

  if exist = 0 then
    select count(*) into sys_exist from DBA_TABLES where table_name = 'XDB$XTAB'
    and owner = 'SYS';

    if sys_exist = 1 then
      begin
        execute immediate
          'drop library sys.xmltableindex_lib force';
      exception
        when others then null;
      end;

      begin
        execute immediate
          'drop table sys.xdb$xtab force';
      exception
        when others then null;
      end;

      begin
        execute immediate
          'drop table sys.xdb$xtabnmsp force';
      exception
        when others then null;
      end;

      begin
        execute immediate
          'drop table sys.xdb$xtabcols force';
      exception
        when others then null;
      end;
    end if;

    execute immediate
      'create table xdb.xdb$xtab (
         idxobj#    number not null,             -- object # of XMLTableIndex
         groupName  NVARCHAR2(30)  not null,     -- group name of XMLTableIndex
         xmltabobj# number not null,             -- object # of XML TABLE
         ptabobj#   number,                      -- object # of parent table
         xpath      VARCHAR2(4000) not null,    -- row source 
         xquery     clob,                       -- xquery row source 
         flags      number,
         parameters XMLType,
           constraint xdb$xtabpk primary key (idxobj#,groupName,xmltabobj#))';
    execute immediate
      'create  index xdb.xdb$idxxtab on xdb.xdb$xtab(xmltabobj#)';

    execute immediate
      'create table xdb.xdb$xtabnmsp (
         idxobj# number not null,           -- object # of XMLTableIndex
         groupName  NVARCHAR2(30) not null, -- group  name of XMLTableIndex
         xmltabobj# number not null,        -- object # of XMLTable
         prefix  NVARCHAR2(30),             -- namespace prefix
         namespace   NVARCHAR2(2000),       -- namespace or xpath
         flags   number not null)';         -- 0x01 NAMESPACE 
    execute immediate
      'create index xdb.xdb$idxtabnmsp on xdb.xdb$xtabnmsp(idxobj#,groupName)';
    execute immediate
      'create index xdb.xdb$idxtabnmsp_xmltabobj on xdb.xdb$xtabnmsp(xmltabobj#)';

    execute immediate
      'create table xdb.xdb$xtabcols (
         idxobj# number not null,           -- object # of XMLTableIndex
         groupName  NVARCHAR2(30) not null, -- group  name of XMLTableIndex
         xmltabobj# number not null,        -- object # of XMLTable
         colname  NVARCHAR2(2000) not null, -- column name
         coltype  NVARCHAR2(100)   not null, -- column type
         xpath    VARCHAR2(4000) not null,  -- xpath
         flags number not null)';    -- flags 
    execute immediate
      'create index xdb.xdb$idxtabcols on xdb.xdb$xtabcols(idxobj#,groupName)';
    execute immediate
      'create index xdb.xdb$idxtabcols_xmltabobj on xdb.xdb$xtabcols(xmltabobj#)';
  end if;

end;
/





