Rem
Rem $Header: cmpdwpth.sql 10-dec-2007.09:00:30 rburns Exp $
Rem
Rem cmpdwpth.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      cmpdwpth.sql - CoMPonent DoWngrade for PaTcH releases
Rem
Rem    DESCRIPTION
Rem      This script just runs downgrades for components that
Rem      require patch downgrade actions.   Most components
Rem      do not require any patch downgrade actions, so the
Rem      list is shorter than for major release downgrades.
Rem
Rem    NOTES
Rem      Invoked by catdwgrd.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rburns      12/10/07 - component patch downgrade
Rem    rburns      12/10/07 - Created
Rem

Rem=========================================================================
Rem BEGIN Component patch downgrades
Rem=========================================================================

Rem Setup component script filename variable
COLUMN dbdwg_name NEW_VALUE dbdwg_file NOPRINT;

Rem ======================================================================
Rem Downgrade Spatial
Rem ======================================================================

SELECT dbms_registry_sys.dbdwg_script('SDO') AS dbdwg_name FROM DUAL;
@&dbdwg_file 
SELECT dbms_registry_sys.time_stamp('SDO') AS timestamp FROM DUAL;

Rem=========================================================================
Rem JAVAVM actions for jvmrelod.sql
Rem=========================================================================

BEGIN
  EXECUTE IMMEDIATE '
    UPDATE java$jvm$status SET action=''DOWNGRADE'', inprogress = ''N'',
         punting=''FALSE''
    ';
  COMMIT;
EXCEPTION 
  WHEN OTHERS THEN NULL;
END;
/
Rem=========================================================================
Rem END Component patch downgrades
Rem=========================================================================




