/* to do
 1. add capture parameter _ASMJOB_MAX_INTERVAL, default 5 mintues, positive only, finite, dynamic
    done.
    tested.
 2. merge script: start original propagation before start original capture. check split script
    done.
 3. when add a subscriber, submit a new job if not already exist.
    done.
 4. confirm by test: disable split job after split and become not splittable.
    tested.
 5. add error handler for release_lock, ignore return code 4?
    lock_handle is not null, when capture aborted, release_lock get return code 4?
    done.
 6. show job next run time in dba_streams_split_merge
    done: also added script status
    tested.
 7. next run clear last error in view, split job row.
    yes. confirmed.
 8. if merge error will set error in split job row?
    no. confirmed.
 9. merge_streams_job_internal: succeed case and error case update view conditions are different.
    done.
10. dblink for sys
    done: use dbms_sys_sql.parse_as_user for auto split.
    tested.
11. add dba_streams_split_merge_hist
    done.
12. add action_type_monitor
    done.
13. change the merge_threshold/max_interval of an original capture should also change 
    all its cloned captures.
    done.
14. changing max interval should change existing split/merge job next run time.
    done.
15. write error to trace no matter tracing on or not.
    write summary of error to alter log, give trace file name 
    done.
16. write to alter log: start/end of split/merge, with all names, if write_alter_log.
    done.
17. both split/merge progress show in monitor row, and wrapper error
    done.
18. cloned capture and job should always on, but make sure no auto merge job for manual merge.
    only for cca.  for non-cca, use should start cloned capture.
    done.
19. don't drop split/merge script.  need to change script_exists()
    done. 
20. auto merge job disable itself if cloned capture is down.  make sure not during merge
    done.
21. add wrapper in dbms_streams_auto_int, print error stack in script for auto split.
    done. don't need wrapper for autosplit.
22. block number in comment of split/merge script
    done.
23. add split job status: nonsplittable, no error for this case.
    done.
24. confirm: clone_propagation does not call enable_auto_split?
    done. move enabling code from prvtbstr to prvtbprp.
25. new error for can not get lock. action: will automatically retry.
    how about capture not on/nonsplittable
    done.
26. check all release_object_lock, add comment, handle not null
    done.
27. asmjob_max_interval => sm_job_max_interval
    done.
28. show split row in both views if merge is not done.
    done.
29. add script comment, make sure all names are available, for both manual/auto
    done
30. downstreams capture, real_time_mining
    done
31. remove dbms_streams_sm.recover_operation?
    removed.  delete generating code in error handler.
32. make sure all hidden parameter copied when clone capture
    yes.  copied if set by user
33. ready_to_split_ccac should check capture server not active, but not inactive?
    done. change to not active
34. test for downstreams capture
35. preserve propagation status when split
36. extra path in performance advisor when merge local apply
37. missing prop name in v$propagation_sender after merge
38. check first scn of clone_capture
39. cca: always keep inactive_time in capture_server, even acknowledged.
40. Test: cca with hard error (instance shutdown, prop trans error)
    direct_apply=Auto
    instance shutdown
     capture server inactive immediately (after dml?), prop remains enabled, no failure,
     even after dml.
     time out to acknowledge split
     next time nothing to split
     manual split works, then start cloned capture: cloned propagation get failures!!!
41. break crash test into 2 tests
42. rollback error script immediate?
43. when drop capture, drop split/merge jobs, (clean view? how about unfinished split/merge?)
44. when start capture, if cloned, should check split view, if no merge row, insert
45. if not ready to split/merge, clear script_id if any?
46. if script exists, set status spliting/merging, or like 42, script only use once?
47. think about crash test case, consider script, job, view status in each step.
*/
/* questions
 1. fine tune of next run time.  how to change when set thresholds? 
    don't know how long already waiting, use status_update_time?
 3. what to do if split/merge script errors? should be handled in current run. 
    should roll back, what if can not roll back? what if keeping error and rollback?
 4. change original capture's max interval also change all cloned capture?
 5. monitor row show script id?
 6. detail of clean up function: (script, view, inconsistent situation).
*/
CREATE OR REPLACE PACKAGE BODY dbms_streams_auto_int wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
15d40 3ef8
Oz9F/xTWGXkmg7f9DQ3pdfIut5wwg80Q3scF1MJ9+CM61dQywBiRrHzAbl2Q8WaxY1pU6C73
Ifsjvg9poDYFNIBmMlqXn4dDxp0xptJH0qbWAsBvCtO6GxfNKSkp7Rdzr075vq7/6Gp4XfzN
19GDzcQI8fntNAUgUT0jrpI1bcj0tSd67M42tYhZSTW0T0ZdAaoiMINPtbRCtGxdzomgus23
b83R+f0283lv0X0PAwgWX8n5kVfsbrpbQvV3Q9alPKJh6B3s77NMzmpuQ03vszy3KQotJHr+
B7gQBp1JbfrKdi5JkVBPAm2+LDpkgDUE9aPPffmRe/TxIBtzmb3xs0a1jVm0jdVY+KBVRua/
ezP4tnsVFi9qWR+3UE+63aEbbW2Cqv/fI4tP0Bs02X293zoWDvDGC9MigekD9f9Jc1KPT6Vy
Fo8Rv7zM5uGqiijmLaz/xExFm7js4sH6zyM1QBdzkdOtXQqw+WhJl9uwhSfc43XgMJ/zooYp
OmhP6W24Ibnt7NDmJJ7Bczea94RhzJEeTNEg/r8FVxgkZJ/4TLASWRUoCN8bDJKqE+T5EkUl
mqquOWbCrhexbBO/ke00oezsj1FPYfonLn8QiPpI7WFJgGWn1x92AIj+cmzsTM5Ox53V+/rL
otGLiXqi3MpulvEdDoBrT1Lu3vSawxQaXva0J/iWlQbqc8zOkXvQrB8L+xKSme16HzgUUitw
IKy+HKi1gQ/AMu59FU/R5lMngwnKSVt1tRqdBAddnIzv+4Tf6tsbhqktv1eb06Z06B8D+c+O
UNZFdcsQ9tAslTavtLAHguBnqjEsBUkwdypkhyRpYWRBYPI+P+Q6wYCd9a4EjiViOmrjNxVT
Dl8adve3bv15voWl58j9fsoGNCSe5BYwtkb56V1ywetCwPCRhspu+BCSv6owNRJfEoy9RHIR
WjUF0H2reiXJx6Apmpi1ceu6vwOwxDtV6YUdxieBWRxu/Czpr+mqejPBzM6gJKhz+kuNCRkV
4vlt6ap2zOxqP5cyY6YpB/rYdjWIR8tbIXk/0BpzBZwTEwVDnw0F2IwT11xfrGWVIfmbEZGc
XoNKysO4W3PKpcE4IGWQ/3umLkWs9TIFSQ2hirBDJ7VIA/AWG3yS8kmomHPALJrbHnN/D66b
tLAh35Pj6qdgvCN7q/huL/F/Vfcjw9bBAD9P2vw7pw7DZBxEqOTBv3tsWpLOZHOvZhq7BpUC
JHbMfvrc+yL1Sb08afW7BE3qX7uIG6kKtQpgtUXbkoKQFx1TRyCYIbiS62ouZHF62dLQVbCx
SOL935gL0j3JpP5atVUiGRj4RH9Jld6v2ooG2deSJ8H3/hPt/3BQqiCGVVWBP5wI50PONs5Q
7343YJZX3xUNItwPcKVXIbI7c/wbGWjNLGepNzXDtBCI4/uL58KABr9g6tzjXaemAwvC8j4M
IZ5RKc+imgsjsBSqjXJVhBwkCwjVZf4r1GcSZtNuppEMP4nAKfqZOXC04XSYvKG+718yrmf/
EbpPhD6emkeJzeuAX3JQQHlbhilGUYBliS+XtAVVHP+wA5NmDz0jSyuYEQNM7Q87nLG967kb
BGjbBf5/MUgif7NnwHP6fZgFHj0i02IiOzMsWmXpZtx2t5GMn8ys4EKyJu5/ARxtGjmAPvuv
Eb/Mr+Qg30/L5KikRkteiQUw3wDVbB2Z4WfqOcgLHBubvH5WliioVYr5fP/KUZbXuF/8/WWk
atC18Y7W3BXnd3wlGpQ6t1nmWOOOrDuJUHRvTnB7SfUS+ykWmJfiewElthSNxInfwfB6+QXS
PdtyGXcG+FiqhK69nypO0UmYE+v6Fm7/REns842r/rknmL6N/l2qeCAxjRL969UJXIeLqpGZ
hJJP+DghABJgr9m+hJmYHHHS3X00bD/pAx/ncImwym1bMLOx8fqqMIl8TmRb+VmFUNKn8T7t
Ck7K6ty2Sz2RsoB9YZjIst3i8BU25xjIIhiIJg4Pf6/Gm3HJw1q+gnB97Lec02pWrAQk0WFX
Yd8+nfLl2EuUi/e/eXHml5E1NllBXlL4iKHgog7WdJljnJGz1rCJoglrDsbekfKkla7mHH09
z34VRnJ8q0sSJJB0kjgH37tj9dteGm3AJPpnzz0vK/W3HTV/fay0/bdrunlKJRSOircFzhhQ
qsD3wgJkyCRRHPaUeSI7hjsvJJRwyKvPkdQsYXe2D0dAcSGOMP6yYE+IayitDRDeNOawOTXT
zWYbePBzULGuafzllaAm0SmJS7o1tTWdvHW+InTf/2ISHPJWMCGhp9jLjC0yaT1u3aefNAQC
STsriI7AYA7QCs62vpjto7mG1dAM9SjdPZY6m3DD9LwGEPKcj8cdh/RIUZfRzx0WvndUbzmw
3oU4Pax8Y2X6Z8VhaE2HN3fBS0TDhXp3CmxPkNJj7i+Rxwp6XaEK4VvFQZLCdk2PPvpzf41s
dNoyOq6JZzCtfiYdXsXXeoVVxLga30AhlJT9yWC+UzznguxutuuPhPmgFJa4L9yn7arOCDxw
EZS5ywHkuZy/A0jC9rPwNdTN1ZkrzwCXLXCsc2YbtVzwcyfeK9yApwoc62Msk4jiCuO7wlHV
bqCoOUf/rPfhy3wP6aliNWG2W/v/Loa5y6lPyGoSUOL0yY062s1iWj9zuTh7MKhbfZcd3xVE
PO4dsvH8l5l7Tyf9QfTiQFqTJ1wW9olJ47HqAAp7dWExbJEtoIvfAZFeK3c399dTtHBSYLu3
dt+tTierPflmbpc3FbDHJDB7pCg1C6/gG5fq6cHlk2XTbyugAVaZwWdahwVHlawkcJR67Jct
BooJyQmw7wzRPyHUbtZXhr1+t2WufzIl2LBpWlP+kSjIIBeOwvD5aAJeOnJQ9Hcmd8t9QaXL
GGvUvBTt1iQpT/A30JAdha256YT9dCV4zqLCvR9zsfOASDn2lcbGJ2UKNXqfvyAgTY7VkTFd
utRW3qzpKgB4ENNQEie8FW0DT33UMdxryZMqmMpFebjEXkqI5QGUCaovfEw/45a1kFTZ57+0
CighMycnP5x15zxNA8ObIHvEbl5FtbR32Z5+t42w0rbYsveTbhrbkm/Q5d8oST+wG5YR6T4u
WYh6kL8cIgZBruSx7/nVT27Xe56a0k1aMrMolT6C7NT7jNbzec9gBZtEsV16vmfwuqH12vTJ
PlLBvPKECbjgcKTIlF7w7yXFRjr7i6Pj+cBAqFo30gWcvOx0W+YzL6fo8gF37jMLXGRa/JJZ
PBMA7tf+2cSxWVw/0MWbbr9bRQ3nSoRSJ8ww80wuJjAOmHsOFyJvxU/H8oPxN95qXiVY/Zed
DrkfWtoTEnMQI5vDx137vOFJafC96iIezECR7moCjGiIaDnt+u3D7WpsT8rjdYLN6WfJQZIy
wuAxX3TJuMQDhyVMVnOJ5E3OdtcjY93IDbUHNmd7ryRwmJOuAYw+Dn1DwfgBE64zaG9BKuzV
cmr4U3MUGUh4uo3nFhm/NLcv9VgLdzNI7Yc7mre/E2K49gl65Hw8wvuDzKdbmA5mQxHfM4Lo
eFKvi5hOm29u2NaHVBJZYJTZlpjaaRXJFjdSgddYSAwKzdvpSIU5zyXhyGVVkBrJcSp/Uoh4
hkA2TFsJ2LCFTRzMBXjuPlyy5ak5yX7wL7RYTgYWyGTpLNSPWpsgZWpYbOagN25Zvf1Gnr4n
G+fnudHlGLD9lenNxm8tjKoZLC5muRnXDX2rnJld5AtcmNy8x/2zMrAkdWo6jvVqqbmo/Ots
NC2bg75tRxIF7EyO5alcRfIGwZ3LjDrgJX9Tow4VUVdjcdGgO3dsN2HoAtVQDSGgMjlLOdfD
QiATG3MNvmA37YfqCqSGJ74+DH/DJvxlOIXg7qrUVBjsXySJCOwok9ku7We8vluFIVsvrtum
+lI2pF2p4PHpgt0JRtzOcAUm9pnpzyOqeXf+aLD9Fzy8GlKwOzRW0oYgUVnfPCD0DnRfqwfS
+TKDbakiALeceWQAVEcpIDjbIvsrSiuo6ekNqZ7712NZQopgXpGhNYaEs/rT2TVojcK2HKVp
FD08ZPGisRdvKlLqQvbzCySpUebyAA4+WLPwkXXmEw1PR3MfsB+M+mbSxiCD3U7318qtBDy5
M+zpUrztGXH5mDvf02jLINsy0NvmfnTFjLbn6Tr1vnEgPKF96dsd2DF0zWEqZRXfCRPTq3+j
BoTUTZx2YrCMQlyIUuCMQzu6kJ7Y2oyN3bIVvIu5verx+1SZuqIhENOBwcFtmfKI4d/SzDys
D7bo1MGA1A1EHHAdCQsY7p7AfDH3AG8G+ACMQ+VmKYhz8Z2OV34anNGbtMrETaDOdeWIVH0K
yKjARKDcxXQ0VM6ZJPNZopGMm/DUb5Nui1YkZ8iFRuc7DdEbIyewnLifa20V6IIAXGd4yiNY
QWCspU3C7OGOjst1UCC13pM70+MW/PvSsRlilqrK6Y7X3tU3KlhAroC3ThZYB9x0D9ULxJ98
g32+PmPlk3/yJ2woMA2xCElvi2ArHkw0Q8TapPCCUtaiLthVuIJ4QPJbo2+zhks2NWWmRhTi
7N2UJlGnRd1NbHYw8piLoGUq1pU6sBbhRUEM0PdTNQBsU8sQ37hPFToThdJPojQcCfPTreDb
7ebeSANB/7CGf4KVQ/3llLLgbLpUDH/WLWy0esB8xBwErdiSQ1ylmvNFzLxjeoAT23JAA8tV
G4K9PZmV7TQZ2IbVBOPZgMnLXD1xLf14p7R2tNns8vHPzNdGfBO41hRhc5HHxLwVBil4T59C
Ldlo8NN8x3kcR24MhpzaUdFAA9I9KEtxZhRjgcw1BuVZZTuBn1GPlsJjGrOG2gmmXt2AhkvX
rd1bedDDwW4+fKit3mgTTxMBqS4bmKPlQuhFzQDwD+ogYmACsiDy7ssLTuiic7DHkMWVMOz6
B4nSO6ImrfWJR9d/N76KpNQDwtzIXr0Pl5fiiVrGd8zVKBFUgPSZyaq2g6H9APgC984KVN6J
Hn7UARsYswP5Qk8AAA8AYLVWHIwV7nG33SebZxhyTdxAP1xPoWLKJfLNGFXmbZDR98y7lf7C
EV48eXV0I5WQwy/XzNtnU19HeZnCjoXHgfi7ecKDUrZHCcKUobEns1DRzqYQK04LLqg+6x2L
JdHIiyM2qNt1u6lrWAnoJ6h7/TLsehVkJzKb0l+f3ma2SUeWpGgomxB7zvIYAHscjjnbKZNZ
whaave3VX0czjEmJvgQcFZh4wWUEM0fZQ+zvOpiUlDczLOBRsBLTWSH+4GVY9m1Stq2rZPdQ
wsCoCZ+4tNZjl3uHLEhik9R1He0TXMJIQqtiwy/K0OybZ7GR5r4v6b/0UL0B5tgo5uD8FFrA
stMW88qpcUYrO3ybnawgMMudibtmPxG/ycc4qpNki6wvF/gFlxnb6ExRQrwYZMuzlKRRKLso
zZdM73t6aCyrQoR0loZgMOM57YxeLXJRP9nvSJUiJVva6NIEonWP4kyakw6IgEgud0jUQ1Nl
k/YhAupzVi9bhFsuq4sQompzB3k0+Eu+vPH+8z0HpRNigoDSq2djneJtmPHixGbAPIHQv1La
gNC+X5xCGQH5mHuNLGYUNyF2t6X+9aqWGxiq6v7+wMitNPjaDAD6XF74zSCRnfe4+OBKpVsS
97ETX4AKgRrs4pK5HJLPTYRCfZz+YiqJUK0YjutOdzFJXEon0iW8LdfJxbzNkhZM98sRcIK8
4rhu+JufMgi5cxJucagXuz7/KauY9Xy7aJH81iPBbwVS+VolcS3N6LxWxvtSmsJ2x6Lcc+ip
2sKPe8ONbVVytOjtlhgJhTzuCOgH8Cu40FE90TPI4qnGvKfjHcekm/Z+tJpm30eClR6ef+DI
Jm/u4HsKO1DWVS5yFPugbZLWPdC2Ixys2/cB4ZzTp2Nxc+WAyoTbg8sM5nHf8Gyooiml1Qxn
kFY+mfJqO6f+W1YQAQRLuXkB+uAznVXU7BnSfyCvY0VfN+UDb2R5cEKZ1l7sdcN3YWcIaNik
9UsL2ae3THq6IV2o6mpTnvfo1GlSSWvIo6rJQ+SC6Q9RzwlVfdlfTzq3xqP0eBMFvCNy1u4K
QrQ3LPpDStS8TDFUyOFLmbGqTVgl5DfdPgZydoRgy0NDHTsDzc5OAc+YD3k8HGuKvb5ocZVH
bt36A0ZuZ79ItGNR20jEz0/lQ4dpGyA/zIxx/k8iIsttcIJRyqCXqsp+FSh/+BCwY8fiyX7h
mRdp7xupIsZ28cScvJvKMzd1J0GmTliqf7lst0RJYnGyji/EQW5J3ESN+c8ZqmrcQRdSFOtJ
MeqQD0VdPRbPlySotYSIBPUn3liPVhIOOmNOswLHI4IcwQhBwFXks7yTP8kslQXQ2R6gkqGu
9OQJMbGiiip6j49awpPZP8hLi/Y7l6rpKytES6H5aJXOrRC31DRJsVXJMLeBKMj7rPHiWiaQ
6iZMnpA4e1mtflyCo/bfp6HpPHkm0XfgIpjh5ZvPUd+uxPux3NqsvAwdq7qSjbtStbY3o0d4
sM9FJaArcuPM7AftQX9Tk0g0Zq4XmmuX2wj1tAqB+CwRKHd7jWItgvyDO14+K9YrCMEQoO26
gOpY8MV5rohMYLl7i5QOHTAac/1zOvmLi/gK1ZvuatAkpJrYSr+Yn+penM0/BTevt38+sNsq
tjzMNKNrbZA1JOe9vMAlKOfEvPG79HFg/gWqc5vrs/NwPByMFNnNW6EG6jzLkDGnjQOBnl88
pUbtZoKgtHvVMCC50lvL0BvN60qF/yrtT/5HT0p8oGso20FYgK2b9XE8cdUe36Ph5MigX42U
JqXOod+ywUX8dxfRD8AUJMM8YmBvJq3gOcbA5/p3RF8Db0x59w3LTHl4aGseFuNQBEztGvSn
9qiG6nljK8hQBaym4LSgqVSv6IUFLFelNPos1x+XZzL9rB87laT5JgwkZ3raWm8RdPzsnt4N
C9FWuv9CWjXd77ts1cI03B1+hc3ADFjL8gXspRVcmXFab6p9gjW8aqSLPh587HqIzPk8rlN6
2DOhiMZlI3LblPOC9aixRwFGrG70I1pAuPr+KRB00ie4bFmVJQsiiJ6LKPors98YfnWfblGl
eplce987r/HlKS6udyZLVwPoDF6O6W6olRWjqnUMFCOwQfr0kZBP7oqZTE2PuB+XuUwSTx/y
uunWH/KqmMfRiTzSHgLFv2sh6qpD5pOQ8eWHTaccgcmMQW/F3mqymcsONKT9pLamjkDm7hbF
bw76xftpp6KxXmsAfqwInOanoECyMX7wj4+f74faFuFUfvvX6IHRRjdDl3xUFKNsOHsulq6Y
PzrlezL8Jc8U6Q38ZoxUkPNZN7UnYm7019a8+tyWawEC6AqfkrGv8Z3aC/Tb5+4gnPdeyXgd
kpnQffSNBfRUDpKGzYOHO55yi5bxEJNZYJZvieTKzPRwXOjiLLY/f2HvSUvFmjrr9B2zK6iE
ZGuNj2dD826lj6Ra/eOpmSeD1+tITaDEYiD33F6NErKN/q3VWyfkwC9IL5fhJacepyxNEV/g
8HrUcN2UzmLbR5O5DiVI+o9za1C4sEcyN0R1k+Vi2et7xYpFpZYlrZ/tmZytw0nK3hDdcINc
/Ksnlw9E1VUnYmYw6wQ8pm770lRBxMmReVgRrBpgLcNzFDuDBOEPcR+W+yGqOPyzcAqhJ7OL
JT+lHR6X+TQhjGg6tQC9ROyjFZCjFgSiVpHhF4p3qimIZ6K4QSotbi6tVcX+V2+86KNvZ80n
j6H7LYrfyS8DYljljWphgMukX6+fyvI9WvHvNeYVKKvXaXF+kTetHccYqJ6HrsmyR9spLPGx
XVuNTdLFwfM2S7gIzn7KJhJBJQzlmEtouXWqcUoxwzBbgGeJR8SnJcEWLbyoG1qzREbn0ztt
hKuTrU1eaAqt9iOkfplDyyNzyrHbmXnxo/05k/YbVBxByMnQ3KZw2fKZJ6qX6QWjmzZ38khm
/jT6shcClKjuBpqhzIw52FGDItBtl6TVOzGGFdwrFMFQuKg6wsyE/BHmKV0RhUEyWBI7apb7
+IyZ6defxl/h8ifmc8HRvLZPGoHZzBIKAcSLhm0XVoTHp6EQFTrZIGcJixG5KOSz2dj3UBt0
1mnhiZVBTNJeAOFTwSemFzyEbSzXIn5gNSCVYFyxl6jw24Dm5mzPcqIM267X3dXMuo8z34dI
vyOoHQ5DVWRI4Iezj3PGIEjEEwVD+GzH59BhCAE0kgQg9mMsj9wBwDxbsF1NExOsabIbVtBW
PPFnL18CU/sIBmQYbyyn2hph6VEY5RJdj9ssp1e4dzwnzETl+vSBIHm0aassaHwVyZtWYfU8
PKxU8ykkvwpzLZPwrtfNE6VLNEFA/cImjFjjF6nGCmR0zC2LS8lMmWeZO758MNUkEsRVEo/4
B0He5P7nR/U+f5pLJspZcApGJGe8eKbxYK/XLWCd00qIZB74JXbFCwOZnw4p7JPC39vb+rQa
KWjO8mR8uMiwOWsvzcNNAhguBNjhQLOkOX7Gxko7rGzVJNW8PXQxwp4G5Zs1ay5T+oF/LVO2
a2PJ0lMrp0nsST8bWow55gDYwSMNk8aUlXY5F8MZIvsZ/WGjfnMxfuQ5I6KmvqHPF86CF+Dg
6qiBDtijncCTKn3GJxTJ7h73hzuLqxPV6TU6ux6aUVm71mMFkS6PBb1vFTHCCi5Wd4B6s6Ok
GXQmfVyJXOxXGo2nUJEhjtS4NxBuq7pe9V8q4jX7qT5emL4L7D/CQkmoYuaTrpT5sQpM3s0t
FDEae02QqKRHYIZSjrxBiUYzc2ojv5hFvMlvnCRJUw+Z8fPwGxdfDDePy+Q6DKpIB/5zauwY
pU+VfJrrD5183Y3y1psBsyzjorsTvMqOPGp43vvuEXx9KBhq4GgL4HANV7r7gisiNf2zCalf
DUbvJSuG4xXMquzCn63phDondVHZJqZMrH5avngDgRFmXlgIfPxuUKduH2E4lGJzwT0gzJfE
cYfRljfpRNUs4a4ZCra5ijA68HumBkXVNso7OsqPBWdcCZlxU673npRNDZOHueoshsOnmpUF
0Ain9tJdNpoal0wIpDEKoV4KtgIPgZtRm55pN819GjYBYfn3wxIOeGoL0moLn93Iz7p1DtgB
TfQlBUPeH4UMsbJ/Z1xvFLS20g7f7IyMVP1zOXrdz2N1bCaEJeclu5MsQ8CfOougSEJ9WoCl
dUB6N9bk32IrazqSWwBUgqU1QL5iFFSQYdGUdsgzE1yKsPsdq12yWuAdWg2ewKJEHLBo0eB6
3MzyoY2MzYv9sQWKr/a/iFyPnSnptEDSUP8Z5xQckq+mP5oCdwEiEOn00dXnUnzCBlpIAmgo
Vh0YQZYSA2fNka64FMbsaR3GmIe8nHbywDonw9rcKf8L735nCgIalqt/XGs0rwgmYfC3b6db
PFDDa1xgrd9rvaROydwfTBcnjN0muZs3XOMzmT6+4inZ6qU9003zkTyGbzz9p3U4iL0PcTPL
1LEIbL/koztD9q3nJ5R+9SPBVvKFakiqpfUZQs7jF+WPnRwID5ll9a/7dgl+XHdnfH41VM+E
dEu3BqurY12GomOJf8LCN//MabwQYefv+gq/dM2nvF9I7HDdRfm3GIg5fuHTsD2qgqg+JvVR
8gw8RZcRErr2e07k8KhAk0RLAyl6dx/xSeI+zuwkYYvFXXejlq07oEBE7DryCVNa/4jJSMh/
wICTIza8gAMMUiyaily0gHaE36GvelGthqd8a5S7t26QZfRj0BvxRuvIBnzCYNj4roC1e5Il
Bir+ub6A8/11P0P5Wet7yNlwxxNsGb4n768L41+E2E1CeYgiNt+wqafuIml9ed3s5vuyw7d+
cTmpV/sNGHzPvfwEkRCrwO2+cYeZubyfP/fYfZDgitiLMx0Euj3opFkfx0V1CRxn8k9Rtt8o
SsrBF30AiqYWJumhAQZxsNaKOmucwrcpypFC55JpWf9jbxXFj3v2TIn4shdhJCT89Pw4soUb
RwL9HtS50TUANxhydYmdcttAyiimyY/wzXZ8j3hi8jkOyRaszOrtxWnBDjAgU5J5XbgfL5wo
Q244Y1JbO+jNWpMgp09jkBs7LBsDMKymFJmlwswayZXSxOHqjDlc1Pln4/RpQuHFwDW7EsRm
EN1U9ZbQN/VmlJasGVMsFPHVDxu6Go9ayVNvH0nKS+C4g0k+mXpOVzf6btCT7m2p/0peE5Ou
QqMaxMCSh1fx0zKOAN6Y7/PVVJ4CT+RNTkzEJWV955ZXETsdUG8fjuMQ8hNA+XW+Mp3uY9e3
scdgvdsW53OhtGHLyN16lfFdEmCRSTM/e8BNa8yf14IlmksKQzPGgHYuFuwyd1KWrMfQoKrk
OrOztWP++ahz0PfkjCUdepJDfcwIpqAeUCgVs0bvU1LsV158fVu8ysEXjMhKJWtXfx5yECKc
7uQMnuFm8IOWn1z4dNErNTgo+P+X63yLM52tiFwSsnLUjPrHNJxv4pwD4mjMG4QemNcWjesM
TMFrYfTBqqWcezhBTmGlVAFNmZ8T/g1eJeK7fJCmFZuaKLf7ViolPfoVuFdnxktzZ9SEzCyP
ZDAAHDbuekHSgIbdXg/2/wwWGMquDP4KKYFxiOffMeDcT8etHurUa3SGaW3ezuF0HfoXBAmR
fD8cC678sRf5HoIP0keE2CWQ+8vvbhflmyTO1ZYszn7tg7finUzle0FIue5yw3ZcB86n9Xco
vIy0+Acw6MR/1Rd55R3IOzVcqUNMYJo0lmuULz02FJCU4AkJog5tCewnnkZxgTVsQ68DQcIR
zihkzBwOAWt1BAtwTuDC966+H+1hDCKADGzQ3Kov0TCtXaBWi79G6qxURzqSmJ5n2IYBKY/x
Iw56t6Ys+iiIgAEeIyJP0clfZ5+glbp9Epx6+JcqEKjiPq7Xm9iwd7HmK3lkIBaSHht5PUXm
PvCYrIAjIxBDGPl9cfeQU3byvZs9VMzbDlcnLyd9KOwlHFe61bw7kdl3TD96RxPb9MZ1MXr6
1hng8fG6/6p1/GdtQxPelMCtywqfr1TZPn9zTTsgt0j4yUFD4RRvkn65f4D2P6n2ZJi1z+2l
gwIPvFV+/kL+TAcO+C6AuWn0bUoeqVyIKVLL6cLOk4/vqBxQWh8Qy2gx782S9kFjeBdCMCiw
+n78VWZwzpT+6O5gGeh36ERqwZj+F4f545wp3uISawP4nRtcunEIXv6d8cs6k1qmwvTrcYBZ
waR1KM0fg6IiIosgFbWEfmqLovwcWVG3FdbNr7+ySLNRTgqWorLAryUY/KgVwGs7NDJlucqI
YNA/N5pDOaRmUuf0SQCqOBhMm2JE+XBl0/G7iSgLb8PqIzEdYmXZI3X//t94EMat0kp9dt9b
qldb9dJyYp2woLv8HPnJ0aEfLDC+iGiUGTucx30NR3DsfEuDfkrtoDGbEj4y1wyBFcomMwlo
/wwaviE2FmwfKHI92vpl4cGo3uycWz/NJrkpFuLJvRBHZO2njamv9O6xfYmrYClerGTHRRPp
i/Bk7TRH6XsO0jZgQqKET9PZNHpOwVZ31dNs5R2kWl9gCl5E1joRbyUXMCIAEjkTySafPn3p
79Jl9i5OfUR57JyLe7vc6BLGvP+kZ1scmyo8D51No7XYg0VjlkaUJequo5W7duiklBenlVU+
nLanRddBZPuZxBjRYDV87G4TPeWXd7ACIRB/KOjHGw1b2LwhfXVE/PCswwxmDe9YJ7S3nZkO
7Eq1Wi2IUWMNxz4vciaw5r1CoLhY/LA8RgGu2/mIyAQEUFJn8DYRJh1djb0cegp6hcBAjp1v
B67BKYhTQMOdK7oMZyHzsCNCpJaxs9cnxLo7moChwk4U8wJYRB4nmL7t8GRU9zML82/LPBQN
mZP7v2MCYcabk+uNGGybZJVf1Zleeauj2RalhGYJb8qBvpHR1q/S4N8zhFWlG0xOlSHmRJ+X
CYRLmn2/H4LqjmHBK483NuAyQOlqwrSzFJNIniiSr5UWNEkazlMYJPeYuisV5Pw1mGB1UiJi
x19qMo+b1Su5K+sKF3ICPFfZKnJ5TFoPpXFU+JuJmhSMhTOSMWDcyhJzfoIQaUEvrH/lvtNE
32HpFMWRudcqjac5yNjyNdvpWm0+WTmWT105AO/aQ45yqqTygjpTtejnj2BlteH63UcpT+s1
ZyN7jMPe0iRFecMmNS+y023CEG1n1xx8DToCDRBFp09KSkpF5bhyVA+n6oIj8r1otNEFeuQI
D0xRn2MH1H0efOCbO4FQZ87RUCwRgYuK6xwy9N87x7nyp3YRZQ7jlEsSukYrcUSVzuCfdclz
IwG0R5wd+KEskNOohWHhqGhHDo3gJwEzi4IrRqjVQRXwNmFlo/5MvLyiCEQJwxA3coWXqRoD
7gGKxxlXau+m7QgBngy642exowX7sH8mCaYicEIhYLvI3gTriXqjH7oudIRVyri1+qC3ukDX
4a2OBAEA4dWHNrDVpgSa226nsjfhSiiykwF9tk0dDiP5xGUXK7vFUp6AJhPSQzixFguCW3xY
7U3bE93yjn4dKuy4pRXAxvasduztpaEnhQc6MetwNtZl1SlEmjYAEU0X1EL3jZCAORYPsKEF
Y7Ikobk5Wf40mI+M3PrQOxgxtHcztcjx5nuvJKMYsw9eWZOXlYhIGjlgSyEx6wMXjvHkXLtd
GZ+v0JvYg76uQNTvMJfZT4MTW3ISZL5JboAcHPuKK7RGYAqb0j5fzkW0zvX1lJAMaT6KPj7m
w6++Tb1Xyq5e37FgzEQUjCIg004ZVGVWX9Sbd4EOjKVx4L6dVHhnFBnUnNmYpIUTvg+5u5/Y
CROjT5NV4+rtpRDWaESFdI9HD48grRKWI3kFxyV5G43CWFHCjgk1Fes4xt3sDemZp9YPXXjn
gzTx4bUjeiO5tzMK+ePBfcGSeKpXcxeYunXPjCmwhxKKThlCQCNf3lUI0tgcZHJQ614FlU/+
XZuEzzogM3EAFHgKgVUi4lxkSccT3UQYxl0fO1BsyBtKXGOUOkoq+WtQ8CwuP3Xafhm3o6Ve
4K0nAGYDEzSICWe7tIHlWOkMbAWf7WIlhMG7HUyshosKNhHU9OyJQIeDImMqpb49h5e59He/
pOPf1bTP7WsRNJOYHytvsZH9D8bZTM89Cg+9Ne8gSqGbCsDkuwGBODvPGEnyddYjxRO/SvRF
/GC06DxvOP7WRAKPVfIJHjPI7OnUbK349Blcg2leMK6HStqTee+tw7EDbzN//F9qeNQWqpH8
xbrRn2ZyCW/0dIlZmu2b/L/uQ+ypXFxSJcYerPIz7vUZKzAgAly7z7E95lnYehKW1VuQn/Hr
EQ0ZKD5yJ1RioqNMsVZdk7KaOOFeVdS6gPiMjCuX+imhejura9Q+DjNusHumY9+l1mHqe2zN
D1/65MKrH9T0Acaz7w1lVajzvWlr4geIdcW/jMrFlwycL7PFvtceMoiUWH8PUaAMjUNsDP66
k9aC+wHTKRMu38T4Pdf8tb3Enw4re5+z1QhaTKi66M2UN2VkMDivY0kaJo82bQaZmQxXcUai
9OkabB8DRwcPo6GZLaILBUfazVwJRWaLU14F71u6Y7k78t/k26yhAmK6h95fhqB328cte2e7
ej0I0Q33n+t1mR5K9OunDH7+bSA9nUkyOidzUkLtRQm9gzLkf7w8WrfhuOlPOZG2/YEe4AmN
aQoYtlc0RQK8mnql9BSrnQsl4ju+1lwU7GoMZ2qT8Gl9ju6KyWSAqx7/DFTz731qiadlqzab
XPGldbOEdi7/umDbcPrTlmiRDgcEUfMxkzNeO3zaNMyIKbEV97tChuklk/+LmWFjxVHsF0JZ
QBeAiKQNRol3jZrUHtXoDcgUZjB/+cHPkhgKrg2ohZ9O3pxTIIHlcVdqVYovxB2SVFDGqd70
T0vmBJbUo9ewH1a91OkEvXLl68ZFY+1ik+4goSksjNF4+Fp8+mFRTAGAts7sdBUuUaHMZ8tT
P2cg6bROSZZvXhjy0iHkQqp+6KQOB3jJVEAAyHmS7/l+xJhMNT/XeQj9yvyIGAHDuuNCOJsX
cUfJ+TTvVLtIDYgq5VAsev4HTPhfyuRcisPxU2GXrVqGLFAGInt7CRM2C08ZWMNbrhN6evyj
+hmaBIz6r/eDc6AT5ieAX+Ij8GkaSHaEgR9Z/F3K5Sf1iPzT7FGBM8DhK21sQZ0+0LfdVx2x
wr8nkwRf1d0jvaIvxrQyCw8YtEu3K9zxnJY2ogaFOJOfK4gOKTRXVJRpKTDihi2HJMSNE0QW
cowUgPy3rMWLw8BP/wIrW4QQrXXIfpQUsk2rfSmXpLHDnvKVyl33XP57fRH/Q1DE2dmqgojD
jpBOUOrNJ7cmtfrAEJXlNF4r5EiY8LESj2TTqkqWu7QL69/cY+FPOwqiqbADrLRpaslgwO9S
VYWAbzEku5ZshebEA7pRJji4Gj0hOL1muPT3VuNShbLgYuehuPQLYuN1S0bCb6Lg64dFaw1Y
aSzSIiYjTjRelMVcMQC78fvXdwdDxnU08Asp1PolsVAKW43DhTFt9FCByoDMxpjovCoJlEB5
GXtTwRQQBIC346E5ZrRZnPROzyBuYPUQFmjtUll/wWfL5mwfjdNXcbYTHhbDlVxN7APImJhQ
OHQn+qTSwwdZe+P8ajMD0jgFXAkEPgTAnQVQ7ad91dzieB7+9AZZIwgBKDDxomSx4slOx3yS
Q4OZqyrS6t+BC+KfAp/IydjhX9cJ1+FBUCtlgYuBmwA3blwAW1/CzNsw9Y/eK3b9bRzRyx6N
JZmUNE/CV7TbBlx2bUeA1o4rHvGjnP9wcQUm8SU13sWCUCcunbjIA610i9gCsu8F6SXQ2W9i
zaUfhdGBamrvpwbYjNouEE9YdD2//fRvACICams/YTCW+Bpvu1RFuJEaD7K4TEtJd49edjPu
IVD08bCZiH0tAszAVKaDzNY53qSJyX/lFLLF0j73+Yzk+1UZO9DVttg8T0ogzFgATjSXfT4Y
vu2EnjXSWq6IlvdgAtVbuffVxe7E/vr4GmUM5DjpyFwQwZEl/550jcCVlKM85YbMh3j03vfA
6K2um8D0Gwkse3fvnjnUguH44Ec/XAaalcaKsbdqHT75z4iaZUTTYxS1a8qDcWMbmb7f9DdR
J3cuNAVimsZYMZxiA3punr+VnZFPShV4AKdG5U9XZFAFIjA/ZIJBs71CE57ODr48grZAV/jr
ZX8G/gRtw13rPKx7lzDGMcHOTifEwe6V2hUDvt16YmPpiHiqr/IZrET62GkBA2ZtV24s0Xgx
ZZ4aAXzxBmYxy2P6fQgA5SltKoHS4HTPKve07qysR+PXClEwLohNvdaGBKyX5kOJqSbcgbJG
ha0Mx2OVgqnyDwED1AGCoiHrKstbIjjLwWqQ2MrDShfVVNCd0inm7ntP4wv7OtwizfA5/bgz
Mp1F9PqLSrziTyuxscIbBP3Byb4PTNFkZKr2WSBUZjzE+hGaJFPmtZZR/8bDIhaeffSgZ/vL
pFsnvT8BedINVtIuOZTqmfpSgVV5V8VgXgw+1DDer3ib3WVZDMCo/EJwOj0d2o7VpNBBkUS6
G5PJxBSxj4yMVutwb86nRLoXvoiBCFg2AmSR3CC5DKr/On73zFP/oydatGYQQ9+8aM9fxF+w
X5+cBT3N+XWb6I6xI10jgdGLkW4YPZOOzEX/4TJfWqeKnTNbVZKDpvijOnh6dJCqS8e2mkeV
YyZ51vMKDAx7oXAOEfIkWQv5R7ZfQQmzsRSLrP03bBQ+QRh4qttf7tCughHAeGLI38Q3RxoE
U8OIhM+rO+IJ1/oRtAy/ihbgdUuJpFlXgTDUD/SB/HFAqUAaAwBW4e0BoGEc+aAlLJnfzJOt
Gn4LWui95i1dVHRp+nUXitc61EAM8cwX74NnbqV99XltUL8Ym8UEJ2EONnnjPFW2rX7T5BxU
UIPks/NV+1zoD9Oh4t8eU+qyKsJ4FWgUeIegVJmNkJzMIEm1wbUdkuFgzQ==

/
show error
