SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100
WHENEVER SQLERROR EXIT;
DECLARE
  host_port                  NUMBER;
BEGIN
  host_port := dbms_xdb.gethttpport();
END;
/
DECLARE
  epg_attrib                 VARCHAR2(100);
BEGIN
  epg_attrib := dbms_epg.get_global_attribute('log-level');
END;
/
SELECT TO_NUMBER('MUST_BE_AS_SYSDBA') FROM DUAL
WHERE USER != 'SYS';
WHENEVER SQLERROR CONTINUE;
CREATE OR REPLACE PACKAGE dbms_isched_remote_access wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
9
4f5 26c
bPVAOjXMeWk/aWiY2Up9rmxGhnswg/Ber0gFfHTNrQ9rC1t0ANKDt1Z/DSsT9T7l3p/zYSHd
nxY5VviqwxiQVMduGiIxI65dhhL1sNe3PzaBM04QH6q7351hIAi7M3NynXnkLTF+v9pD5OCz
f4hLNzU6aQ3cBnjlZtYo8M4FAgk6tjKZJzCHIROjTnOx+wzESqWOjJThcmhOUZNRPWXDlLHm
e/baDcAJuyQ9v+aFccsEt3piSnzHpJ6lbUiJPfZsGnoE5hNY6Jl/MEtbY8FY3Vl2f6BclmSq
/fM36q1cLjVFyu9U4HRyqPAvVVAQ2E078MucIYEgCEPuwjr+MXOJLPLY+tk0+B3+NoTmx19+
rFjdbgoc5JYtvJp1/vsTlJj1stigdUVonM94J4tdOvktXB4LL7FXk5oq7+yYY7jmoSLG11Wc
+9c/W5fi7Skm2g7t19HNjdp2MrCRFHzlGE378LXw94wpW9/dBqf/kYCbL8YJgrmUd9nUp2mw
7Q/zBVT2D67K4K23dxSV0+EhCL08x2l7HINN1QhBMZWpdND/sJ2wxIDXfgZJ5YctXRW4ApK2
WD4pP65ueCq0jj8M8TPbBKX57osdZqwqmw==

/
CREATE OR REPLACE PACKAGE BODY dbms_isched_remote_access wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
b
7729 2128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/
show errors
begin
  
  dbms_epg.create_dad('REMOTE_SCHEDULER_AGENT_DAD',
    '/remote_scheduler_agent/*');
  dbms_epg.set_dad_attribute('REMOTE_SCHEDULER_AGENT_DAD',
    'database-username', 'REMOTE_SCHEDULER_AGENT');
  dbms_epg.set_dad_attribute('REMOTE_SCHEDULER_AGENT_DAD',
    'request-validation-function', 'remote_scheduler_agent.restrict_access');
end;
/
alter user anonymous account unlock;
begin
  execute immediate 
    'create user remote_scheduler_agent identified by remote_scheduler_agent';
exception
  when others then
    if sqlcode = -1920 then NULL;
    else raise;
    end if;
end;
/
alter user remote_scheduler_agent account lock ;
alter user remote_scheduler_agent password expire ;
grant execute on dbms_isched_remote_access to remote_scheduler_agent;
CREATE OR REPLACE FUNCTION remote_scheduler_agent.restrict_access wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
8
1a1 134
t7sl5UY2U9HAnI7dxwyw7OVlDo0wgwLILiisfHRAAE7VI4TT3IetLhZFom1YjzL7bhjMX37b
nbsUJ3Q/gSUazfigIIZfFYlJNvAl6Cby707Cw6PapmoCWuZfZTfxtHY4laJXAeBdN90htjaG
FFio748MF1+23Csd3Qt9KVevUD15UthfaE+e3ngNW4xMLGhgedV5w+9OO+XwHr9GcgjKfuXW
RV3oaBDBXz/Wh73BPIO898PtvDcZcuQd9h5BW2QT3LBarjFzTCaFfH0YV7rgnf2CujTEPsIg
dHYT1q+UX2y45g==

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.submit_job_results wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
489 2bd
mlRhaqOarVmnZd7aStQ5YBE1StEwgxDxBUiDZy9AEtdeWWR0GGsbGMONTR9tv6yk7kwXKK24
A55LeU104n7PnAe75t3o7kvCz+w6F7WQOgmvhBqjyok99b5UEyQ6d45h2MIyMUg3uv7PEc62
hC06qXX7etPzYKJx+DJu9zbu5nH87tFDV9GU85dpUaWghxHJbjVR4P/clWrD/WL3QQUsAo8V
fJB0eIBXH+rO2NwevismK/hGtvmlNYzDG+iwgUYJtgPaP/9PHi7T1amGMFvgKQlAVxgx3yoJ
3paUf1550B9kA0esbu0xQo0x4UZMi/aZ/jqOog2sfA/514oj92Q0/3n2Ckj8Uy4PkdDLtt7g
iGBa8N1G1SEUdMyXGQdsA1huZybG8mH+XjMowSnEM2H2WuwPGP2USeKCFKHw7KDtDprtSdgF
tQgAqcoEfpZTg2jtYIFCQomftv9Flkg1jkyadPEwymxNoSFpt13x8fBDb9WCG34a+ueqgz27
fsy8QqRT5QHLdJUm9S7pCFrUzTnGIHPK58+l8trZ6sdkhk89dmYjGuX7gbWELSY8pn0sFYss
yEOxjr44P03LVFdBrYUn3wMBOgqXvCPavSIHdUh2uZ566YWpCucCHugSZHNx4s/+RYWKNOKS
oanp9x8dpY9zpF1qtKRiMSByfaeE/kYLvEid5B2RKSyj

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.submit_job_results2 wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
283 1be
aBZhb7Y3aa4JzGwDm1hEcyBnzrwwgxBp2UgVfC+KWGS0QeEJ2zcLrWz/pzbz2oF7EG5W5+Ly
lFqNxvDQZKiyGmz8HORQiopH3GZEasqN51wDMbsnc5N+9d7lG2QKMTA2YTREwGOENfzSbVfd
A0mTffpYEtScFbHTPkw+q9u+j3RrCrpuYwlBjuGu7i8Z/MeW1DgiYz92Jms6tuOFYc5T486+
KsP6Iffz6guAiR5WeGcxBzHfvj417BDM/VRv/cjX+1QttZcu7dXL/5EiewNkx9h9/S4dJBuk
85l/S/vb5mszBIRR3vah/vFY8GR/RYz/fmSvecfAqpXuM6fE0aMJIPS6A2cup1jlIyCbEsEH
rGR0tpT0//gM43ZGnszTtLcPiuQkOlLt2dczZYEo+9nCFizdN4bzfd4CCdSQeijcKBKvZ9FO
mCALu+i3

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.submit_filewatch_results wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
1fb 199
HcrTeYJ0/yTnDfDUfPx9AvradG4wgwLQ19xGZy9GAE6Ozb3ff3qpbnARkdP5bhyi3DYxMVa9
4+5JhzPukEw84/T9wVAHJuLiZGX3ZdLHN3xiIBDa6gdhXk+BaHYKzC4MeK5wiKb0/QtDnu6n
uEK8H16NDBxSk4Oz0JIOvw9oFprRmoNV+0lqaklBEV4Wgtq2evenWEoy6z4Oi00zDLBgL+Us
yUQ3G9YGXzl+fSR7KsRqmL7HdHm1Ih1nbDGcotxWop3TBLAJSWVAot9Dh0cBlKXnmerCadmJ
gPFfDacN3sLNa4T/mzmbrgQOY953IaSnuRk0MKWNOBtCRcKUqBvIly9EN0H6KoGaAzU7nf6L
jQac+8ZSBCyvRuu9fa3mqAYqVwikhChTPbS++OFUDNAx

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.filewatch_request_resend wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
23f 1c2
2R065p0Kovm07Sd273ZjjceHgYcwg43ILUjWfC9A2k6OxPdaXEBKNaTndpXTtNvBifXm81fy
FKvDdCcHes+yvXl7kX31PDrkEJ2Wt2bduO/zM8ajqrlFm2mgkoyx6AM9fV5EglvKbxpTT2am
hqX82cozQ+t2BDGYFpa42Vrz2EZaUMFBAxUf1AcXxbqR8VIqx+mY1faywxz1PbFFRCaaE9yE
kQ3IKIcFiO1hy4e/ua1vf2tIANkXBNqm0mBtuI0Jrxbjf1YU6OY47lv702Jmp3C5Csphc4E5
oTHyhWox0qQKBBZWRTcKBDqNP7aql8mSwnfUiviSUmgEX9UdczIhkFJkelnntfBNq3mPd/Uf
PCgYB98ZuNR5qVjgBtPRxD41tNib8QS5+JLrZFIV+YjbYXmDbFO4Ih07tollpMbYBcdApv4z
fQDPHbm8jNA=

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.unregister_agent wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
24b 1a9
g/etB8gZUbUrSlEuFcEBhqfrgvUwgwLIDCAVfC9GEv9ktEHhCY70HNn6V7p2Ji1eZOvGPhis
a1rzWkBozgjXHea9jfzWEM6fPIK3J5V/lyHm7cefAwB2O9lt8FWkSRymulEhvmmRDgC7Wcev
0l58yvrTNIR660UC84JX5gmhGZm5w6z3qRJdLqjoOZa4iAxkbBUaOOUL3hu8wOmTkw6bBeL8
l3twO8eF/8xxUmi5v0sZ2nXXFZOucyloHjNxeOFQHwKzZmt6G9F8lyobl3D/V4BRfLdFWGzW
e7vgruLtNhmPzoNauF41ULDLRUbXwXPSZI6q7OhFVs3uS+IKgLVWFa5KJvQ9ldIHZ72X53c2
12Jb1bXNPz5hjUyyEoDT9Ui7Qa8H6719zZQN3NE5kXcysTR8uZH5pR12Wexi

/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.register_agent wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
245 1b6
La4FizLO5XplELKl9UwTuuNiubgwgxDIACAVfC9A2sHqcbCpjuljC1hfEI9a26G7Wd6wFp5A
ZunKiLTOCLJGuyuBuByHOgj4cdxYoiqoNrtv2dc8OlFxUz1htqZ9XzvzPuYSIjahYn0qJ2b0
kbc4ZgKVD7NG5/BiwxNVYL5wQckanmJUD4wOmb14CKaA9L3LenlOV7DbtNx1OsLlpLiBzcmY
g0IvByNnxmG8aNGx1XVkANIjUmTXFUgkVwnieqb5BlSyCdHTp6tcNXXJb5mobGXG5ibmX8s7
INt7F7V926nau33/IUWcbY9s4YKI0K5OZexIYilgCCjvGVyNBX6LmJKtegCvrvS+LsIDs8OM
N0cnFEDJ7Az6tfpqwJOYMQKSpabtD/h45zidWz8s78wj+RlNhqMT/U2TVroanxdzsCyWjezF


/
CREATE OR REPLACE PROCEDURE remote_scheduler_agent.register_agent2 wrapped 
a000000
1
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
abcd
7
3ac 268
j/+mTBDl+kdHETD64k7v7HiGVEAwgxDxryATfI7Uv4tkMNr38nQ7cXs7g68qlkQ7LVjN4h69
a9uOIY4UhKBclywkHahSPE27j9aqm/68/joBrF5fLESss5Yysfa3H5YjBYCZKMruCX/C5nX8
SfMhqGaeVlEWw0VZPszOOQCeN1lDCNtxifM+T1PjTkaFXSTbAqxevuNSYAhl5mBOu87PvTEe
hBN442go+Uq314WYrMOjzwf+Pk458U1WR6KXdxXB6FR4q11FJRNMjLLIqBsvCyfofR6fmQH2
j5J7XxuLD1UjjJehKGci2Xy8uvp6jSGvVx9TBp7H5j7yiPFX/0nH3LxtOv3hu3U31tYD3dZO
X9Z/sXAYfHWGwEaLieFJjh4SrP/OH+iNmIGjv0y+9iKSB0nObeDoCSKu+InKHeLTjtOK+koQ
muqHbzKMeIA9ayVshSwoicbnmo9e0kOLi06+Blgbq+vsZGdheQ8xZKt4qxjUfeBOnpJkzXc3
zevqMltcBYGPu/5KJSbkJDIPNfsTRVYNiFw5O6XEPwIl7PViBtbbv83OS5ooXg4v1f6kbc0w
B6aTetHXuEmKg1oC4IPjfTNqJJvZu5g=

/
begin
  dbms_epg.deauthorize_dad('REMOTE_SCHEDULER_AGENT_DAD');
  dbms_epg.authorize_dad('REMOTE_SCHEDULER_AGENT_DAD',
    'REMOTE_SCHEDULER_AGENT');
end;
/
commit;
