Rem
Rem sbaddins.sql
Rem
Rem Copyright (c) 2006, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sbaddins.sql - Standby Database Statistics Collection Add Instance
Rem
Rem    DESCRIPTION
Rem	 SQL*PLUS command file which adds a standby database instance
Rem      for performance data collection
Rem
Rem    NOTES
Rem      Must be run from standby perfstat owner, STDBYPERF
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    shsong      03/04/07 - fix bug
Rem    wlohwass    12/04/06 - Created
Rem

--
--  List configured standby instances
@@sblisins

prompt
prompt
prompt THE INSTANCE YOU ARE GOING TO ADD MUST BE ACCESSIBLE AND OPEN READ ONLY
prompt
prompt Do you want to continue (y/n) ?
prompt You entered: &&key

begin
  if upper('&&key') <> 'Y' then
    raise_application_error(-20101, 'Install failed - Aborted by user');
  end if;
end;
/

prompt
prompt
prompt Enter the TNS ALIAS that connects to the standby database instance
prompt ------------------------------------------------------------------

prompt Make sure the alias connects to only one instance (without load balancing).
prompt You entered: &&tns_alias

prompt
prompt
prompt Enter the PERFSTAT user's password of the standby database
prompt ----------------------------------------------------------

prompt Performance data will be fetched from the standby database via 
prompt database link. We will connect to user PERFSTAT.
prompt You entered: &&perfstat_password

prompt
prompt ... Creating database link

create database link stdby_link_&&tns_alias 
connect to perfstat identified by &&perfstat_password
using '&&tns_alias';


column inst_name heading "Instance"  new_value inst_name format a12;

prompt
prompt ... Selecting instance name

select i.instance_name   inst_name
from v$instance@stdby_link_&&tns_alias i;

insert into stats$standby_config
values ( '&&inst_name'
      , 'STDBY_LINK_'||upper('&&tns_alias')
      , 'STATSPACK_'||upper('&&inst_name'));

commit;

prompt
prompt
prompt ... Creating table

-- The following tables are required by sbrepins.sql during report generation.
create table v$lock_type_&&inst_name as 
select * from v$lock_type@stdby_link_&&tns_alias;

create table v$database_&&inst_name as
select * from v$database@stdby_link_&&tns_alias;

create table v$instance_&&inst_name as
select * from v$instance@stdby_link_&&tns_alias;


prompt
prompt
prompt ... Creating package
prompt

--
-- Create statspack package
@@sbcpkg

undefine key tns_alias inst_name perfstat_password


