Rem
Rem $Header: rdbms/admin/xdbe111.sql /st_rdbms_11.2.0.1.0_gen/1 2010/01/13 05:17:43 sinaraya Exp $
Rem
Rem xdbe111.sql
Rem
Rem Copyright (c) 2007, 2010, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      xdbe111.sql - XDB downgrade to 11.1.0
Rem
Rem    DESCRIPTION
Rem      This script performs the downgrade actions to downgrade the 
Rem      current release to 11.1.0.  It is invoked by cmpdbdwg.sql and
Rem      xdbe102.sql 
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    spetride    12/02/09 - 9144511: disable sch validation for XS
Rem    aime        01/06/10 - XbranchMerge spetride_bug-9144511_main from main
Rem    badeoti     11/19/08 - add dbms_registry.dowgrading
Rem    rburns      11/05/07 - add schema and XS; handle XMLIDXSTATSMETHODS
Rem    rburns      08/22/07 - add 11g XDB up/down scripts
Rem    rburns      08/22/07 - Created
Rem

Rem ================================================================
Rem BEGIN XS downgrade to 11.1.0
Rem ================================================================
set serveroutput on
variable lvl number;
variable lvls varchar2(20);
declare
  H  VARCHAR2(64) :='';
  N  INTEGER      ;
BEGIN
  dbms_system.read_ev(31150, :lvl);
  N := :lvl;
  LOOP
     SELECT RAWTOHEX(CHR(N))||H
     INTO   H
     FROM   dual;
 
     N := TRUNC(N / 256);
     EXIT WHEN N=0;
  END LOOP;

  :lvls := ltrim(H,'0');
end;
/
select :lvls from dual;

Rem set level 4000 to disable schema validation
begin 
  if (:lvls is NULL) then
    execute immediate 'alter session set events ''31150 trace name context forever, level 0x' || '4000' || ''' ';
  else
    begin
      if (length(:lvls)>3) then 
        execute immediate 'alter session set events ''31150 trace name context forever, level 0x' || substr(:lvls, 0, length(:lvls)-4) || '4' || substr(:lvls, length(:lvls)-2) || ''' '; 
      else 
        execute immediate 'alter session set events ''31150 trace name context forever, level 0x' || '4' || lpad(:lvls, 3, '0') || ''' ';
      end if;
    end;
  end if; 
end;
/

DECLARE
 lev BINARY_INTEGER;
BEGIN
  dbms_system.read_ev(31150, lev);
  dbms_output.put_line(lev);
END;
/


@@xse111.sql

begin 
  if (:lvls is not NULL) then
     execute immediate 'alter session set events ''31150 trace name context forever, level 0x' || :lvls || ''' '; 
  else
     execute immediate 'alter session set events ''31150 trace name context off'' ';
  end if;
end;
/


DECLARE
 lev BINARY_INTEGER;
BEGIN
  dbms_system.read_ev(31150, lev);
  dbms_output.put_line(lev);
END;
/

set serveroutput off

Rem ================================================================
Rem END XS downgrade to 11.1.0
Rem ================================================================

Rem ================================================================
Rem BEGIN XDB downgrade to 11.1.0
Rem ================================================================

EXECUTE DBMS_REGISTRY.DOWNGRADING('XDB');

Rem Common Downgrade actions
@@xdbeall.sql

Rem Downgrade XDB User data
@@xdbeu111.sql

Rem Downgrade XDB Schemas
@@xdbes111.sql

Rem Downgrade XDB objects
@@xdbeo111.sql

Rem ================================================================
Rem END XDB downgrade to 11.1.0
Rem ================================================================

EXECUTE dbms_registry.downgraded('XDB','11.1.0');
