Rem
Rem $Header: rdbms/admin/xdbu111.sql /main/5 2009/02/17 11:51:05 bhammers Exp $
Rem
Rem xdbu111.sql
Rem
Rem Copyright (c) 2007, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      xdbu111.sql - XDB Upgrade from 11.1.0
Rem
Rem    DESCRIPTION
Rem      This script performs upgrade actions to upgrade from 11.1.0
Rem      to the current release
Rem
Rem    NOTES
Rem      It is invoked by xdbdbmig.sql and by xdbu102.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    bhammers    02/12/09 - add indexes to xdb.xdb$element
Rem    spetride    08/07/08 - upgrade for Aplication users and roles
Rem    achoi       11/13/08 - lrg3678340: move xdb_pi_trig to SYS
Rem    sidicula    09/25/08 - 
Rem    sichandr    09/23/08 - create XDB$REPOS tables
Rem    rburns      09/30/07 - add 11.1 schema upgrade
Rem    spetride    10/04/07 - create index XDB.XDB$RESOURCE_ACLOID_IDX 
Rem    rburns      08/22/07 - add 11g XDB up/down scripts
Rem    rburns      08/22/07 - Created
Rem

-- temporarily run "s" script here; move to xdbdbmig with re-org
@@xdbs111.sql

-- temporarily run first part of reload here (redundantly on earlier upgrades)
@@xdbptrl1.sql

Rem ==================================================================
Rem Upgrade XDB Data from 11.1.0
Rem ==================================================================

create index xdb.xdb$resource_acloid_idx on XDB.XDB$RESOURCE e (e.xmldata.ACLOID);

grant execute on xdb.xdb$nlocks_t to public with grant option;

-- create XDB$REPOS table
CREATE TABLE XDB.XDB$REPOS
(
   obj#         NUMBER NOT NULL,
   flags        NUMBER,
   rootinfo#    NUMBER,
   hindex#      NUMBER,
   hlink#       NUMBER,
   resource#    NUMBER,
   acl#         NUMBER,
   config#      NUMBER,
   dlink#       NUMBER,
   nlocks#      NUMBER,
   stats#       NUMBER,
   checkouts#   NUMBER,
   resconfig#   NUMBER
);

-- create XDB$MOUNTS table
CREATE TABLE XDB.XDB$MOUNTS
(
   dobj#        NUMBER,
   dpath        VARCHAR2(4000),
   sobj#        NUMBER,
   flags        NUMBER
);


begin
  execute immediate 'drop trigger xdb.xdb_pi_trig';
exception
  when others then null;
end;
/


-- upgrade for Application user and roles support
COLUMN :xdbapp_name NEW_VALUE xdbapp_file NOPRINT
VARIABLE xdbapp_name VARCHAR2(50)

declare
  stmt    varchar2(4000);
  cnt     number := 0;
begin
  :xdbapp_name := '@nothing.sql';
  stmt := 'select count(*) from dba_tables where (owner = ''' || 'XDB' ||
          ''') and (table_name = ''' || 'APP_USERS_AND_ROLES' || ''') '; 
  execute immediate stmt into cnt;
  if (cnt = 0) then
    :xdbapp_name := '@catxdbapp.sql';
  end if;

  exception
     when others then
      :xdbapp_name := '@nothing.sql'; 
end;
/
SELECT :xdbapp_name FROM DUAL;
@&xdbapp_file


-- add app users and groups virtual folders
declare
 ret boolean;
begin
  begin
    ret := 
      dbms_xdbutil_int.createSystemVirtualFolder('/sys/principals/users/application');
    if ret then
      dbms_xdb.setACL('/sys/principals/users/application', 
                      '/sys/acls/bootstrap_acl.xml');
    end if;
    
    exception
      when others then
        null;
  end;  

  begin
    ret := 
      dbms_xdbutil_int.createSystemVirtualFolder('/sys/principals/groups/application');
    if ret then
      dbms_xdb.setACL('/sys/principals/groups/application', 
                      '/sys/acls/bootstrap_acl.xml');
    end if;

    exception
      when others then
        null;
  end;
end;
/
commit;

-- add indexes to xdb.xdb$element
begin

/* parent_schema */
execute immediate 'create index xdb.xdb$element_ps on 
xdb.xdb$element e (sys_op_r2o(e.xmldata.property.parent_schema))';   

/* propref_ref */
execute immediate 'create  index xdb.xdb$element_pr on 
xdb.xdb$element e (sys_op_r2o(e.xmldata.property.propref_ref))'; 

/* type_ref */
execute immediate 'create  index xdb.xdb$element_tr on 
xdb.xdb$element e (sys_op_r2o(e.xmldata.property.type_ref))'; 

/* sequence_kid */
execute immediate 'create  index xdb.xdb$complex_type_sk on 
xdb.xdb$complex_type ct (sys_op_r2o(ct.xmldata.sequence_kid))'; 

/* choice_kid */
execute immediate 'create  index xdb.xdb$complex_type_ck on 
xdb.xdb$complex_type ct (sys_op_r2o(ct.xmldata.choice_kid))'; 

/* all_kid */
execute immediate 'create  index xdb.xdb$complex_type_ak on 
xdb.xdb$complex_type ct (sys_op_r2o(ct.xmldata.all_kid))';

/* head_elem_ref */
execute immediate 'create  index xdb.xdb$element_her on 
xdb.xdb$element ct (sys_op_r2o(ct.xmldata.head_elem_ref))';

/* global */
execute immediate 'create bitmap index xdb.xdb$element_global on 
xdb.xdb$element e (e.xmldata.property.global)';

exception
  when others then null;
end;
/
