#!/usr/local/bin/perl
# 
# $Header: install/tools/deinstall/bootstrap.pl /st_install_11.2.0.1.0/2 2010/02/04 18:47:33 ssampath Exp $
#
# bootstrap.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      bootstrap.pl - This script will first validate if the files required for deinstalling ORACLE_HOME is 
#                     present in ORACLE_HOME and bootstraps it to the location passed from shell/batch script.
#                     This script will be run only in cases when running the deinstall tool from installed ORACLE_HOME.
#
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ssampath    01/18/10 - Creation
# 
use Cwd;
use File::Basename;
use File::Path;
use File::Copy;
use File::Find;

$bootstrapDir = shift;
$ORACLE_HOME = shift;

$ID = exists($ENV{ID}) ? $ENV{ID} : '/usr/bin/id';
$LSL = exists($ENV{LSL}) ? $ENV{LSL} : '/bin/ls -l';
$isWindows = ($^O =~ /.*MSWin.*/) ? 1 : 0;
if ($isWindows)  {
 	$dirSep = '\\';
 	$pathSep = ';';
        $arch = $ENV{PROCESSOR_ARCHITECTURE};
	$bits = $ENV{PROCESSOR_ARCHITEW6432};
	$is32Bit = (($arch eq 'x86') && ($bit eq '')) ? 1 : 0;
} else {
 	$dirSep = '/';
 	$pathSep = ':';
}

# Check if this script is run as root on Linux.  If so, then error out.
# This is fix for bug 5024086.
if (! $isWindows) {
	my $id = `$ID`;
	$id =~ /.*?\((\w+)\).*/;
	$user = $1;
	#print "\n\$user = $user\n";
	if ($user eq 'root') {
		print "\nERROR: You must not be logged in as root to run the deinstall tool.\n";
		print "       Log in as Oracle user and rerun the deinstall tool.\n";
		exit 1;
	}
}

#Different error conditions

$ROOT_USER = 1;
$MISSING_OH_LOC = 2;
$OH_LOC_EMPTY = 3;
$NOT_VALID_DIR_OH = 4;

$tmp = $isWindows ? $ENV{temp} : $dirSep.'tmp';
#print "\$tmp = $tmp\n";

mkdir($bootstrapDir) or die "ERROR: Unable to make boot strap directory $bootstrapDir\n";
validateOwner();
filesListCheck();

# copy contents of ORACLE_HOME/deinstall/* and jdk to the bootstrap directory
my @sourceDirs = ($ORACLE_HOME.$dirSep.'deinstall',$ORACLE_HOME.$dirSep.'jdk');
my $dest = $bootstrapDir;
      
if ( $^O eq "MSWin32" ) {
   system("xcopy /y/s/i/e/q $sourceDirs[0] $dest");
   system("xcopy /y/s/i/e/q $sourceDirs[1] $dest\\jdk");
}
else {
   system("cp -rf $sourceDirs[0]/* $dest");
   system("cp -rf $sourceDirs[1] $dest");
} 

sub validateOwner() {
   # Check that user running this script is owner of Oracle Home.
   $homeInventory = $ORACLE_HOME.$dirSep.'inventory';
   if (! $isWindows) {
        my $id = `$ID`;
        $id =~ /.*?\((\w+)\).*/;
        $user = $1;
	#print "\n\$user = $user\n";
	if (-d $ORACLE_HOME) {
		if (-d $homeInventory) {
			my @lsCmdOutput = `$LSL $ORACLE_HOME`;
			my $inventoryOwner;
			foreach $lineOut (@lsCmdOutput) {
				chomp($lineOut);
				$lineOut =~ s/^\s+//;
				$lineOut =~ s/\s+$//;
				if ($lineOut =~ /.+?\s+[0-9]+\s+(.+?)\s+.*inventory/) {
					$inventoryOwner = $1;
					#print "owner = $inventoryOwner\n";
				}
			}
			if ($user ne $inventoryOwner) {
				print "You must be the owner of this Oracle Home to deinstall/deconfigure it.\n";
				exit 1;
			}
		} else {
			print "The home inventory does not exist on this Oracle Home: $ORACLE_HOME\n";
			print "Please create '$homeInventory' as original user and rerun this script.\n";
			exit 1;
		}
	} else {
		print "The Oracle Home '$ORACLE_HOME' does not exist.\n";
		print "Please re-create the Oracle Home as original user and rerun this script.\n";
		exit 1;
	}
   }
}

sub filesListCheck() {
	my $filePath;
	my $command;
	# Check to see if all the files we require for running Files List
	# is present in the home.  If it is not present, then there is
	# no point in continuing further.
	$filePath = $ORACLE_HOME.$dirSep."deinstall".$dirSep."jlib".$dirSep."deinstall_wrapper.jar";
	unless (-f $filePath) {
		print "\nThe deinstall file, deinstall_wrapper.jar does not exist in ORACLE_HOME, $ORACLE_HOME/deinstall/jlib directory.  Hence, you cannot use deinstallation and deconfiguration tool that is installed in the home.  Download stand-alone version of the tool from OTN to deconfigure and deinstall the home.\n";
		exit 1;
	}
	# Extract required files from .lst
	$command = $ORACLE_HOME.$dirSep."jdk".$dirSep."bin".$dirSep."jar tf";
	$filePath = $ORACLE_HOME.$dirSep."deinstall".$dirSep."jlib".$dirSep."deinstall_wrapper.jar";
	my @fileToExtract = grep { /.*\.lst/ } `$command $filePath`;
	my $fileToExtract = $fileToExtract[0];
	chomp($fileToExtract);
	#print "\n\$fileToExtract = $fileToExtract\n";
	chdir($bootstrapDir) or die "ERROR: Cannot change to directory $bootstrapDir\n";
	
	$command = $ORACLE_HOME.$dirSep."jdk".$dirSep."bin".$dirSep."jar xf";
	system("$command $filePath $fileToExtract");
	# required_files.lst is already extracted to bootstrapDir.
	
	my $fileName = $bootstrapDir.$dirSep."mapfiles".$dirSep."required_files.lst";

	#my $fileName = $ORACLE_HOME.$dirSep."deinstall".$dirSep."mapfiles".$dirSep."required_files.lst";
	open(FILE, "<$fileName") or die "ERROR: Unable to open required_files.lst\n";
	my @files = ();
	while (my $file = <FILE>) {
		chomp($file);
		push(@files, $file) unless ($file =~ /\w+\.dll/ && (! $isWindows)); # if non-windows, skip .dlls
	}
	close(FILE);
	foreach $file (@files) {
		$file =~ s/\//\\/g if ($isWindows);
		#print "\nProcessing file $file\n";
		my $compFile = 'oui'.$dirSep.'bin'.$dirSep.'ouica.properties';
		next if ($file eq $compFile); # drop extraneous oui/bin/ouica.properties
		next if ($file =~ /.+_tmp.*/);
                next if ($file eq 'bin'.$dirSep.'ODBTREEVIEW.OCX' && !$is32Bit);
                next if ($file eq 'bin'.$dirSep.'OO4OADDIN.DLL' && !$is32Bit);
                next if ($file eq 'bin'.$dirSep.'OO4OCODEWIZ.DLL' && !$is32Bit);
		my ($fileName, $fileDir, $fileExt) = fileparse($file, '\..*');
		# Correctly rename for EM template files which have been instantiated under different names
		if ($file =~ /\w+\.template$/) {
			my @fnArr = split(/\./, $fileExt);
			$fileName .= ".".$fnArr[1];
			$file = length($fileDir) > 0 ? $fileDir.$fileName : $fileName;
		}
		push(@filesToCopy, $file);
		if (! -f $ORACLE_HOME.$dirSep.$file) {
			print "ERROR: Cannot find the file $file in the ORACLE_HOME $ORACLE_HOME.  You must download the standalone version of the deinstall tool from OTN to deconfigure/deinstall this Oracle Home.\n";
			rmtree($bootstrapDir) if (-d $bootstrapDir);
			exit 1;
		} else {
                        createSubDirs($fileDir);
			my $from = $ORACLE_HOME.$dirSep.$file;
			my $to = $bootstrapDir.$dirSep.$fileDir;
			copy($from, $to);
			#print "\nCopied file $from to $to\n";
		}
	}
}

sub createSubDirs {
    my ($input) = @_;
    my $intrPath = "";

    #Loop through the sections
    foreach(split/\Q$dirSep\E/,$input) {
        #Add to path
        $intrPath .= $_ . $dirSep;

	#print "Create path $intrPath\n";
	mkdir($intrPath) or die "ERROR: Unable to create directory $intrPath\n" if(! -d $intrPath);
    }
}
