#!/usr/local/bin/perl 
# 
# $Header: install/tools/deinstall/deinstall.pl /st_install_11.2.0.1.0/9 2010/01/21 16:03:25 ssampath Exp $
#
# deinstall.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      deinstall.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ssampath    01/18/10 - Decouple bootstrapping logic to bootstrap.pl
#    mwidjaja    01/14/10 - Fix help message for params
#    ssampath    01/10/10 - Add -DBOOTSTRAP_DIR to java command
#    prsubram    01/08/10 - Removing the hardcoded string in the usage() method
#    prsubram    01/07/10 - Correcting the help msg for windows
#    prsubram    12/09/09 - XbranchMerge prsubram_bug-9106829 from main
#    prsubram    12/08/09 - Removing setting of OH as an env var
#    prsubram    10/19/09 - XbranchMerge prsubram_bug-9002203 from
#                           st_install_11.2.0.1.0
#    prsubram    10/15/09 - Adding OCM deconfig jar to classpath
#    ssampath    08/24/09 - XbranchMerge ssampath_cleanup_deinstall_scripts
#                           from main
#    ssampath    08/20/09 - Comment debug statements
#    dchriste    03/12/09 - New deinstall perl script to generically replace 
#                           both deinstall script and deinstall.bat 
#    dchriste    03/12/09 - Creation 
# 
use Cwd;
use File::Basename;
use File::Path;
use File::Copy;
use File::Find;

$homeVersion = shift;
$bootstrapDir = shift;

if($homeVersion)
{
   $ORACLE_HOME=shift;
}

$CHMOD = exists($ENV{CHMOD}) ? $ENV{CHMOD} : '/bin/chmod';
$ID = exists($ENV{ID}) ? $ENV{ID} : '/usr/bin/id';
$LSL = exists($ENV{LSL}) ? $ENV{LSL} : '/bin/ls -l';
$isWindows = ($^O =~ /.*MSWin.*/) ? 1 : 0;
if ($isWindows)  {
 	$dirSep = '\\';
 	$pathSep = ';';
	$ENV{PATH}=$bootstrapDir.$dirSep.'bin;'.'C:\WINDOWS\system32;C:\WINDOWS;C:\WINDOWS\System32\Wbem';
} else {
 	$dirSep = '/';
 	$pathSep = ':';
}
# Check if this script is run as root on Linux.  If so, then error out.
# This is fix for bug 5024086.
if (! $isWindows) {
	my $id = `$ID`;
	$id =~ /.*?\((\w+)\).*/;
	$user = $1;
	#print "\n\$user = $user\n";
	if ($user eq 'root') {
		print "\nERROR: You must not be logged in as root to run the deinstall tool.\n";
		print "       Log in as Oracle user and rerun the deinstall tool.\n";
		exit 1;
	}
}

$cmdLineArgs = parseArgs();

#foreach $key (keys %$cmdLineArgs) {
	#print " $key";
	#if (defined $cmdLineArgs->{$key}) {
		#print " ", $cmdLineArgs->{$key};
	#}
#}

#Different error conditions

$EMPTY_JRE_LOC = 1; 
$INCORRECT_JRE_LOC = 2;
$INCORRECT_JRE_VER = 3;
$MISSING_JRE_ARG = 4;
$ROOT_USER = 5;
$MISSING_OH_LOC = 6;
$OH_LOC_EMPTY = 7;
$NOT_VALID_DIR_OH = 8;
$toolArgs = '';

# Default -help option to false
$userHelp = 0; # DJC appears not to be used

$tmp = $isWindows ? $ENV{temp} : $dirSep.'tmp';
#print "\$tmp = $tmp\n";

if ($homeVersion) {
	if (exists($cmdLineArgs->{-home})) {
		print "\nERROR: -home must not be set for a deinstall running from within an ORACLE_HOME.\n";
		print "       Deinstall of the current home is assumed.\n";
		exit 1;
	} else {
		$cmdLineArgs->{-home} = $ORACLE_HOME;
	}

	if (exists($cmdLineArgs->{-help})) 
	{
	   usage();
           exit 1;
        }
	$perlHome = $bootstrapDir.$dirSep.'perl';
	$jreHome = $bootstrapDir.$dirSep."jdk".$dirSep."jre";
} else {
	if (! exists($cmdLineArgs->{-home})) {
		usage();
		print "\nTool is being run outside the Oracle Home, -home needs to be set.\n";
		exit $MISSING_OH_LOC;
	}
	$jreHome = $bootstrapDir.$dirSep.'jre';
	$perlHome = $bootstrapDir.$dirSep.'perl';
	processArgs();
}

foreach $key (keys %$cmdLineArgs) {
    $toolArgs .= $key . ' ';
    if ($cmdLineArgs->{$key}) {
        $toolArgs .= $cmdLineArgs->{$key} . ' ';
    }
} 

#print "\n\$toolArgs = $toolArgs\n";
#print "\n\$bootstrapDir = $bootstrapDir\n";
$ouiDir = $bootstrapDir.$dirSep."oui".$dirSep."jlib";
$jlibDir = $bootstrapDir.$dirSep."jlib";
$libDir = $bootstrapDir.$dirSep."lib".$dirSep."linux";
$binDir = $bootstrapDir.$dirSep."bin";
$templateDir = $bootstrapDir.$dirSep."templates";
$deinstallDir = $bootstrapDir;
$deinstallJlib = $deinstallDir.$dirSep."jlib";

unsetEnv();

# Check that user running this script is owner of Oracle Home.
$homeInventory = $ORACLE_HOME.$dirSep.'inventory';
if (! $isWindows) {
        my $id = `$ID`;
        $id =~ /.*?\((\w+)\).*/;
        $user = $1;
	#print "\n\$user = $user\n";
	if (-d $ORACLE_HOME) {
		if (-d $homeInventory) {
			my @lsCmdOutput = `$LSL $ORACLE_HOME`;
			my $inventoryOwner;
			foreach $lineOut (@lsCmdOutput) {
				chomp($lineOut);
				$lineOut =~ s/^\s+//;
				$lineOut =~ s/\s+$//;
				if ($lineOut =~ /.+?\s+[0-9]+\s+(.+?)\s+.*inventory/) {
					$inventoryOwner = $1;
					#print "owner = $inventoryOwner\n";
				}
			}
			if ($user ne $inventoryOwner) {
				print "You must be the owner of this Oracle Home to deinstall/deconfigure it.\n";
				exit 1;
			}
		} else {
			print "The home inventory does not exist on this Oracle Home: $ORACLE_HOME\n";
			print "Please create '$homeInventory' as original user and rerun this script.\n";
			exit 1;
		}
	} else {
		print "The Oracle Home '$ORACLE_HOME' does not exist.\n";
		print "Please re-create the Oracle Home as original user and rerun this script.\n";
		exit 1;
	}
}
$perlBin = $perlHome.$dirSep.'bin';
$perlLib = $perlHome.$dirSep.'lib';
#$ENV{ORACLE_HOME} = $ORACLE_HOME;
#print "\nORACLE_HOME environment variable set to $ORACLE_HOME\n";
$oracleBin = $ORACLE_HOME.$dirSep.'bin'.$dirSep.'oracle';
if (-f $oracleBin) {
	$noOracleBin = 'false';
} else {
	$noOracleBin = 'true';
}
#print "\n\$noOracleBin = $noOracleBin\n";

# Check only flag passed or not
$checkOnlyFlag = exists($cmdLineArgs->{-checkonly}) ? 'true' : 'false';
#print "\n\$checkOnlyFlag = $checkOnlyFlag\n";

setClassPath();
setLdLibraryPath();

# set SRVM tracing
$trace = exists($ENV{SRVM_TRACE}) ? '-DTRACING.ENABLED=true -DTRACING.LEVEL=2' : '';

# run the tool
#$toolCmd = $jreHome.$dirSep.'bin'.$dirSep.'java -DNOHOME='.$noOracleBin.' -Dpid='.$$.' -Doracle.installer.jre_loc='.$jreHome.' -DHOME_OPT='.$homeOpt.' -Doracle.installer.oui_loc='.$bootstrapDir.$dirSep.'oui '.$trace.' -classpath '.$classPath.' oracle.install.db.deinstall.wrapper.clusterDeconfig '.$toolArgs;
$toolCmd = $jreHome.$dirSep.'bin'.$dirSep.'java -DNOHOME='.$noOracleBin.' -Dpid='.$$.' -Doracle.installer.jre_loc='.$jreHome.' -DBOOTSTRAP_DIR='.$bootstrapDir.'  -DHOME_OPT='.(($homeVersion) ? 0 : 1).' -Doracle.installer.oui_loc='.$bootstrapDir.$dirSep.'oui '.$trace.' -classpath '.$classPath.' oracle.install.db.deinstall.wrapper.clusterDeconfig '.$toolArgs;
#print "\n\$toolCmd = $toolCmd\n";

system($toolCmd);

exit 0;

############################################################################################## End of main logic - Beginning subroutine section ##############################

sub usage() {
	my $ext = sh;
	if ($isWindows)  {
	$ext = "bat";
        } 
	my $cmdName = substr($0,0,10).$ext;
	if ($homeVersion) {
		print "\n$cmdName\n";
	} else {
		print "\n$cmdName -home <Complete path of Oracle home>\n";
	}
	print "               [ -silent ]\n";
	print "               [ -checkonly ]\n";
	print "               [ -local ]\n";
	print "               [ -paramfile <complete path of input parameter properties file> ]\n";
	print "               [ -params <name1=value[ name2=value name3=value ...]> ]\n";
	print "               [ -o <complete path of directory for saving files> ]\n";
	print "               [ -help | -h: Type -h or -help to get more information on each of the above options. ]\n";
}

sub parseArgs() {
	my $newHash = {};
	my $ILLEGAL_COMMAND_LINE_ARG = 9;
	my $gotKey = 0;
	my $key = undef;
	my $value = undef ;
	while ($arg = shift @ARGV) {
		if (index($arg, "-") == 0) {
			if ($gotKey) {
				$newHash->{$key} = $value;
			}
			$gotKey = 1;
			$key = $arg;
			$value = undef;
		} else {
			if (!$gotKey) {
				print "ERROR: Command line argument encountered without a flag.\n";
				exit $ILLEGAL_COMMAND_LINE_ARG;
			}
			$gotKey = 0;
			$value = $arg;
			$newHash->{$key} = $value;
			$key = undef;
			$value = undef;
		}
	}
	if ($gotKey) {
		$newHash->{$key} = $value;
	}
	return $newHash;
}

sub processArgs() {
	if (exists($cmdLineArgs->{-help})) {
		$userHelp = 1;
	}
	if (exists($cmdLineArgs->{-home})) {
		if ($cmdLineArgs->{-home}) {
			$ORACLE_HOME = $cmdLineArgs->{-home};
		} else {
			usage();
			print "\nSpecify the complete path of the Oracle home you want to remove.\n";
			exit $MISSING_OH_LOC;
		}
	}
	unless (-d $ORACLE_HOME) {
		if (-f $ORACLE_HOME || -l $ORACLE_HOME) {
			usage();
			print "\nThe path specified for Oracle_Home $ORACLE_HOME is not a valid directory. Make sure to specify a valid Oracle home path.\n";
			exit $NOT_VALID_DIR_OH;
		} else {
			usage();
			print "\nThe path specified for Oracle_Home $ORACLE_HOME does not exist. In order to proceed, create an empty Oracle home directory and rerun the tool.\n";
			exit $OH_LOC_EMPTY;
		}
	}
	#print "\n\$ORACLE_HOME = $ORACLE_HOME\n";
}

sub unsetEnv() {
	# In case of downloaded version, we unset ORACLE_HOME and ORACLE_BASE.
	if ($ENV{ORACLE_HOME}) {
		delete($ENV{ORACLE_HOME});
	}
	if ($ENV{ORACLE_BASE}) {
		delete($ENV{ORACLE_BASE});
	}
}

sub setLdLibraryPath() {
	#print "...before LD_LIBRARY_PATH = ", $ENV{LD_LIBRARY_PATH},"\n";
        $LD_LIBRARY_PATH = $libDir.$pathSep.$bootstrapDir.$dirSep.'lib'.$pathSep.$bootstrapDir.$dirSep.'oui'.$dirSep.'lib'.$dirSep;
        if ($^O =~ /.*SunOS.*/) {
                $LD_LIBRARY_PATH .= 'solaris';
        } elsif ($^O =~ /.*HP-UX.*/) {
                $LD_LIBRARY_PATH .= 'hpunix';
        } elsif ($^O =~ /.*AIX.*/) {
                $LD_LIBRARY_PATH .= 'aix';
        } else {
                $LD_LIBRARY_PATH .= 'linux';
        }
	$LD_LIBRARY_PATH .= $pathSep.$bootstrapDir.$dirSep.'bin';

	$LD_LIBRARY_PATH .= $pathSep.$ENV{LD_LIBRARY_PATH} if (exists($ENV{LD_LIBRARY_PATH}));
	$ENV{LD_LIBRARY_PATH} = $LD_LIBRARY_PATH;
	#print "...after LD_LIBRARY_PATH = ", $ENV{LD_LIBRARY_PATH},"\n";
}

sub setClassPath() {
	# component specific deconfig JARs
	$toolJar = 'deinstall_wrapper.jar';
	$installDeconfigJar = 'deinstall_core.jar';
	$xmlParserJar = 'xmlparserv2.jar';
	$crsDeconfigJar = $jlibDir.$dirSep.'crsdc.jar';
	$ouiDeconfigJar = $ouiDir.$dirSep.'OraInstaller.jar';
	$ouiCheckpointJar = $ouiDir.$dirSep.'OraCheckPoint.jar';
    	$ocmDeconfigJar = $jlibDir.$dirSep.'deconfigCCR.jar';

	# other JARs for components
	$ouiPrereqJar = $ouiDir.$dirSep.'OraPrereq.jar';
	$ouiPrereqChecksJar = $ouiDir.$dirSep.'OraPrereqChecks.jar';
	$shareJar = $ouiDir.$dirSep.'share.jar';
	$ewtJar = $jlibDir.$dirSep.'ewt3.jar';
	$helpJar = $jlibDir.$dirSep.'help4.jar';

	# Dependent JARs for components
	$srvmJar = $jlibDir.$dirSep.'srvm.jar';
	$srvmHasJar = $jlibDir.$dirSep.'srvmhas.jar';
	$srvmAsmJar = $jlibDir.$dirSep.'srvmasm.jar';
	$vipCaJar = $jlibDir.$dirSep.'vipca.jar';
	$cvuJar = $jlibDir.$dirSep.'cvu.jar';
	$netCaJar = $bootstrapDir.$dirSep.'assistants'.$dirSep.'netca'.$dirSep.'jlib'.$dirSep.'netca.jar';
	$netCamJar = $jlibDir.$dirSep.'netcam.jar';
	$netCfgJar = $jlibDir.$dirSep.'netcfg.jar';
	$ldapJar = $jlibDir.$dirSep.'ldapjclnt11.jar';
	$dbcaJar = $jlibDir.$dirSep.'dbca.jar';
	$dbuaJar = $jlibDir.$dirSep.'dbma.jar';
	$utilJar = $bootstrapDir.$dirSep.'assistants'.$dirSep.'jlib'.$dirSep.'assistantsCommon.jar';
	$emCoreJar = $jlibDir.$dirSep.'emCORE.jar';
	$emConfigJar = $jlibDir.$dirSep.'emConfigInstall.jar';
	$emCaJar = $jlibDir.$dirSep.'emca.jar';
	$httpClientJar = $ouiDir.$dirSep.'http_client.jar';
	
	# set the classpaths
	$toolClassPath = $deinstallJlib.$dirSep.$toolJar;
	$installClassPath = $deinstallJlib.$dirSep.$installDeconfigJar;

	$xmlParserClassPath = $ouiDir.$dirSep.$xmlParserJar; # DJC - Not in the original windows .bat file
	$crsClassPath = $crsDeconfigJar.$pathSep.$vipCaJar.$pathSep.$cvuJar;
	$commonDepClassPath = $srvmJar.$pathSep.$srvmHasJar;
	$ouiClassPath = $ouiDeconfigJar.$pathSep.$ouiCheckpointJar.$pathSep.$ouiPrereqJar.$pathSep.$shareJar.':'.$ewtJar.$pathSep.$helpJar.$pathSep.$xmlParserClassPath;
	$assistantsClassPath = $utilJar.$pathSep.$dbcaJar.$pathSep.$dbuaJar.$pathSep.$ouiPrereqChecksJar.$pathSep.$srvmAsmJar;
	$netCaClassPath = $netCaJar.$pathSep.$netCamJar.$pathSep.$netCfgJar.$pathSep.$ldapJar;
	$emCpClassPath = $srvmAsmJar.$pathSep.$xmlParserClassPath.$pathSep.$utilJar.$pathSep.$shareJar.$pathSep.$emConfigJar.$pathSep.$emCoreJar.$pathSep.$emCaJar.$pathSep.$httpClientJar;
    	$ocmClassPath = $ocmDeconfigJar;

	# main classpath
	$classPath = $toolClassPath.$pathSep.$crsClassPath.$pathSep.$commonDepClassPath.$pathSep.$installClassPath.$pathSep.$ouiClassPath.$pathSep.$assistantsClassPath.$pathSep.$netCaClassPath.$pathSep.$emCpClassPath.$pathSep.$ocmClassPath;
	#print "\n... classPath = $classPath\n";
}
