#!/bin/sh
#
# $Header: emll/install/clean_cron_proc.sh /st_emll_10.3.1.1/1 2009/04/03 01:42:29 kthiruma Exp $
#
# clean_cron_proc.sh
#
# Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      clean_cron_proc.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kthiruma    03/20/09 - Bug8347470
#    kthiruma    03/20/09 - Creation
#

# 
# Reset the locale to ENGLISH for command line operations.
LC_ALL=C
export LC_ALL

#Variable declations
_binDir=/bin
_usrBinDir=/usr/bin
_usrLocalBinDir=/usr/local/bin

#Assuming system temp directory is /temp
CCR_TEMP=/tmp

# Constant declarations for exit values.
SUCCESS=0
ERR_INVALID_USAGE=1

#Initialization 
if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

if [ -f ${_binDir}/uname ]
then
    UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
    UNAME=${_usrBinDir}/uname
fi

PLATFORM=`$UNAME | $CUT -f1`

if [ "$PLATFORM" = "Linux" ]
then

ECHO=echo
KILL=kill
GREP=${_binDir}/grep
RM=${_binDir}/rm
PS=${_binDir}/ps
AWK=${_binDir}/awk

else

ECHO=${_usrBinDir}/echo
KILL=${_usrBinDir}/kill
GREP=${_usrBinDir}/grep
RM=${_usrBinDir}/rm
PS=${_usrBinDir}/ps
AWK=${_usrBinDir}/awk

fi

#Variable Initialization
CRONTAB=${_usrBinDir}/crontab
RMF="$RM -f"
RMRF="$RM -rf"

if [ $PLATFORM = "OSF1" ]
then
    if [ -z "${BIN_SH}" ]
    then
        BIN_SH=xpg4
        export BIN_SH
        $0 "$@"
        exit $?
    fi
fi

# Bug 5931631 - If SunOS, run this script with /usr/xpg4/bin/sh
if [ $PLATFORM = "SunOS" ]
then
    if [ -z "${_xpg4ShAvbl_setupCCR}" ]
    then
        _xpg4ShAvbl_setupCCR=1
        export _xpg4ShAvbl_setupCCR
        /usr/xpg4/bin/sh $0 "$@"
        exit $?
    fi
fi

#To set awk and grep path to support regular expression
if [ "$PLATFORM" = "SunOS" ]
then
    GREP=/usr/xpg4/bin/grep
    AWK=/usr/xpg4/bin/awk
fi

#-----------------------------Sub routines -------------------------
#To remove crontab entry
remove_crontab_entry()
{
# Default the temporary directory to /tmp for where temporary files are written.
#    export CCR_TEMP
# Save the variable for future reference
_tmpCrontab=${CCR_TEMP}/crontab.$$

  $CRONTAB -l > /dev/null 2>&1
  # Proceed only if crontab command succeeded (eg. crontab is not disabled)
  if [ $? -eq 0 ]
  then
    $CRONTAB -l > ${_tmpCrontab}

    $GREP -v "JAVA_HOME=[^ ]* ${CCR_HOME}/bin/emCCR" ${_tmpCrontab} > ${_tmpCrontab}.1
    $CRONTAB ${_tmpCrontab}.1
    $RMF ${_tmpCrontab}
    $RMF ${_tmpCrontab}.1
  fi
_returnData=$?
}

#Kill the ccr(nmz) process
remove_ccr_process()
{
_tmpProc=${CCR_TEMP}/proc.$$
line=""

$PS -ef | $GREP "${CCR_HOME}/bin/nmz"| $GREP -v "$GREP ${CCR_HOME}/bin/nmz" | $GREP -v  `basename $0` | $AWK -F" " '{print $2}' > ${_tmpProc}

while read line
do

$KILL -9 $line  > /dev/null  2>&1

done < ${_tmpProc}

$RMF ${_tmpProc}

_returnData=$?
}

#usage help
usage()
{
$ECHO " ";
$ECHO "Usage: `basename $0` "
$ECHO "-o ORACLE_HOME"
$ECHO "-l Temporary Directory : Default /tmp directory"
$ECHO "-h <Usage Help>";
$ECHO " ";
}

#-------------------------Main Code----------------------------
if [ $# -lt 1 ] 
then
    usage
    exit $SUCCESS
fi

#Read commandLine arguements
while getopts :o:l:h _option
do
    if [ $? -eq 0 ]
    then
        case ${_option}
        in
            h)  usage
                exit $SUCCESS;;

            o)  ORACLE_HOME=${OPTARG};;

            l)  CCR_TEMP=${OPTARG};;

            :)
                $ECHO "Required value for option \"-${OPTARG}\" is missing."
                $ECHO ""
                usage
                exit  $ERR_INVALID_USAGE;;

            *)
                $ECHO "Invalid command qualifier specified \"-${OPTARG}\""
                $ECHO ""
                usage
                exit $ERR_INVALID_USAGE;;

            \?)
                $ECHO "Invalid command qualifier specified \"-${OPTARG}\""
                $ECHO ""
                usage
                exit $ERR_INVALID_USAGE;;

        esac
    fi
done

$ECHO "PLATFORM : $PLATFORM"

#Define CCR home
CCR_HOME=${ORACLE_HOME}/ccr

#Remove Crontab entry for the ccr home
remove_crontab_entry
$ECHO "CRONTAB : ${_returnData}"

#kill the ccr process
remove_ccr_process
$ECHO "NMZ : ${_returnData}"

#return with exit value
exit ${_returnData}

