# $Header: CompEMcentral.pm 23-may-2007.05:03:22 neearora Exp $
#
# Copyright (c) 2001, 2007, Oracle. All rights reserved.  
#
#    NAME
#      CompEMcentral.pm - module that implements all emctl options for central
#      install.
#
#    DESCRIPTION
#       Top level module that implements the emctl options for 'central' install
#
#    MODIFIED   (MM/DD/YY)
#       neearora 05/23/07 - Changed Release from 3 to 4
#       minfan   04/26/07 - ojdbc14 sunset
#       denath   03/19/07 - Backport denath_bug-5920273 from main
#       denath   03/07/07 - Bug fix 5920273. Added and Initialized EMDiag
#                           module.
#       denath   03/07/07 - Bug fix 5920273. Added and Initialized EMDiag
#                           module.
#       schoudha 12/20/06 - Bug-5726004-Change banner for emctl
#       zmi      08/15/06 - add connector package
#       shianand 07/21/06 - Backport shianand_bug-4516559 from main 
#       smodh    01/20/06 - Replace classes12.jar with ojdbc14.jar 
#       smodh    02/20/06 - XbranchMerge smodh_jdbc_emcore from main 
#       kduvvuri 01/16/06 - 
#       shianand 11/14/05 - fix bug 4514168
#       kmanicka 08/22/05 - add EmKeyCmds
#       neearora 08/17/05 - Bug 4241177. Implemented banner
#       shianand 07/09/05 - Refactoring Secure Commands 
#       rkpandey 08/24/04 - Type Registry Added 
#      kduvvuri  05/05/2004 - Created. 
#      kduvvuri 04/07/28/2004 - add getVersion.
#

package CompEMcentral;
use EMomsCmds;
use EmKeyCmds;
use AgentStatus;
use AgentMisc;
use AgentSubAgent;
use EMAgent;
use EMconnectorCmds;
use EmCommonCmdDriver;
use EmctlCommon;
use ASConsoleLifeCycle;
use ASConsoleStatus;
use IASConsole;
use RegisterTType;
use File::Copy cp;
use SecureOMSCmds;
use EMDiag;


sub new {
  my $classname = shift;
  my $self = { };
  bless ( $self, $classname);
  #cmdList is a list containing all the command implementors.
  $self->{cmds} = [ EMomsCmds->new(), ASConsoleLifeCycle->new(), 
                    ASConsoleStatus->new(),
                    AgentStatus->new(),AgentMisc->new(),
                    AgentSubAgent->new(),
                    RegisterTType->new(),
                    EmKeyCmds->new(),
                    SecureOMSCmds->new(),
                    EMDiag->new(),
                    EMconnectorCmds->new() ] ;
  return $self;
}

sub doIT {
   my $self = shift;
   #print "from sub routine doIT of agent.pm ,  @_\n";
   $refCmds = $self->{cmds};
   $cmdDriver = EmCommonCmdDriver->new();  
   $result = $cmdDriver->doIT($refCmds, \@_);
   return $result;
}

sub usage {
  #print "this is usage from CompEMcentral.pm\n";
  print "   Oracle Enterprise Manager 10g Grid Control commands:\n";
  my $self = shift;
  $refCmds = $self->{cmds};
  $cmdDriver = EmCommonCmdDriver->new();
  $result = $cmdDriver->usage($refCmds, \@_); 
}

sub getVersion {
  #print "this is Version from CompEMcentral.pm\n";
  my $self = shift;
  $refVars = [ EMomsCmds->new(),IASConsole->new(), EMAgent->new() ];
  $cmdDriver = EmCommonCmdDriver->new();
  $result = $cmdDriver->getVersion($refVars, \@_);
}

sub banner {
  my $relVer = "10.2.0.0.0";
  my $prodVer = "10g";
  my $coreVer;
  my $beginYear = "1996";
  my $endYear = "2006";

  my $inFile = "$ORACLE_HOME/j2ee/OC4J_EM/applications/em/em/WEB-INF/config/emVersion.xml";

  if(-e $inFile)
  {
    $CP = "$ORACLE_HOME/oc4j/jdbc/lib/ojdbc5dms.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/ojdbc14dms.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-net-ee.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-utility.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-collation.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-net.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-internal.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-servlet.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-lcsd.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-tools.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-mapping.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-translation.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n.jar$cpSep$ORACLE_HOME/oc4j/lib/dms.jar$cpSep$ORACLE_HOME/jdbc/lib/ojdbc14.jar$cpSep$ORACLE_HOME/jdbc/lib/nls_charset12.jar$cpSep$ORACLE_HOME/sysman/jlib/emagentSDK.jar$cpSep$ORACLE_HOME/sysman/jlib/emCORE.jar$cpSep$ORACLE_HOME/sysman/jlib/log4j-core.jar$cpSep$ORACLE_HOME/sysman/jlib/emCORE.jar$cpSep$ORACLE_HOME/lib/xmlparserv2.jar";

    $javaStr = "$JAVA_HOME/bin/java ".
               "-cp $CP ".
               "-DEMHOME=$EMHOME ".
               "-DORACLE_HOME=$ORACLE_HOME ".
               "oracle.sysman.emdrep.util.EMVersion $inFile";

    my @result = `$javaStr`;

    if (@result)
    {
      my $count = scalar(@result);
      my $i=0;
      while( $i < $count)
      {
        @comp = split /\s+/, $result[$i];
        if( lc($comp[0]) eq "releaseversion")
        {
          $relVer = $comp[1];
        }
        elsif( lc($comp[0]) eq "productversion")
        {
          $prodVer = $comp[1];
        }
        elsif( lc($comp[0]) eq "coreversion")
        {
          $coreVer = $comp[1];
        }
        elsif( lc($comp[0]) eq "copyrightbeginningyear")
        {
          $beginYear = $comp[1];
        }
        elsif( lc($comp[0]) eq "copyrightendingyear")
        {
          $endYear = $comp[1];
        }
        $i = $i + 1;
      }
    }
  }
  print "Oracle Enterprise Manager ".$prodVer." Release 4 Grid Control ".$banner_add." \n"; 
  print "Copyright (c) ".$beginYear.", ".$endYear ." Oracle Corporation.  All rights reserved.\n";
  print "$DB_URL\n" if ($INSTALL_TYPE_DB and defined($DB_URL));
  print "$IAS_URL \n" if ($INSTALL_TYPE_IAS and defined($IAS_URL));

  if($DEBUG_ENABLED)
  {
    print "NOHUP Files are $AGENT_NOHUPFILE | $DB_NOHUPFILE | $IAS_NOHUPFILE \n";
  }
}

1;
