#  $Header:
#
# Copyright (c) 2001, 2007, Oracle. All rights reserved.  
#
#    NAME
#      CompEMcire.pm - module that implements all emctl options for 
#        EMCORE development environment
#
#    DESCRIPTION
#       Top level module that implements the emctl options for EMCORE dev env
#
#    MODIFIED   (MM/DD/YY)
#       neearora 05/23/07 - Changed Release from 3 to 4
#       minfan   04/26/07 - ojdbc14 sunset
#       schoudha 12/19/06 - Bug-5726004-Change banner for emctl
#       zmi      08/15/06 - add connector package
#       smodh    02/20/06 - XbranchMerge smodh_jdbc_emcore from main 
#       kduvvuri 01/16/06 - change copy right year. 
#       smodh    01/20/06 - Replace classes12.jar with ojdbc14.jar 
#       kmanicka 08/22/05 - add EmKeyCmds
#       neearora 08/16/05 - Bug 4241177. Implemented banner
#       shianand 07/09/05 - Refactoring Secure Commands 
#       neearora 04/17/05 - Added emctl dump 
#       rkpandey 09/01/04 - register oms targettype added 
#       rpinnama 08/23/04 - rpinnama_bug-3840846
#       rpinnama 08/20/04 - 
#    rpinnama    08/20/2004 - Created. 
#

package CompEMcore;
use EMomsCmds;
use EmKeyCmds;
use AgentLifeCycle;
use AgentStatus;
use AgentMisc;
use AgentSubAgent;
use EMAgent;
use EMconnectorCmds;
use EmCommonCmdDriver;
use EmctlCommon;
use File::Copy cp;
use RegisterTType;
use EMDiag;
use SecureAgentCmds;
use SecureOMSCmds;


sub new {
  my $classname = shift;
  my $self = { };
  bless ( $self, $classname);

  #cmdList is a list containing all the command implementors.
  $self->{cmds} = [ EMomsCmds->new(), AgentLifeCycle->new(), AgentStatus->new(),
                    AgentMisc->new(), AgentSubAgent->new(), RegisterTType->new(),
                    SecureAgentCmds->new(), EmKeyCmds->new(), SecureOMSCmds->new(),  EMDiag->new(), EMconnectorCmds->new() ] ;
  return $self;
}

sub doIT {
   my $self = shift;
   #print "from sub routine doIT of agent.pm ,  @_\n";
   $refCmds = $self->{cmds};
   $cmdDriver = EmCommonCmdDriver->new();  
   $result = $cmdDriver->doIT($refCmds, \@_);
   return $result;
}

sub usage {
  #print "this is usage from CompEMcentral.pm\n";
  print "   Oracle Enterprise Manager 10g Grid Control commands:\n";
  my $self = shift;
  $refCmds = $self->{cmds};
  $cmdDriver = EmCommonCmdDriver->new();
  $result = $cmdDriver->usage($refCmds, \@_); 
}

sub getVersion {
  #print "this is Version from CompEMcentral.pm\n";
  my $self = shift;
  $refVars = [ EMomsCmds->new(), EMAgent->new() ];
  $cmdDriver = EmCommonCmdDriver->new();
  $result = $cmdDriver->getVersion($refVars, \@_);
}

sub banner {
  my $relVer = "10.2.0.0.0";
  my $prodVer = "10g";
  my $coreVer;
  my $beginYear = "1996";
  my $endYear = "2007";

  my $inFile = "$ORACLE_HOME/j2ee/OC4J_EM/applications/em/em/WEB-INF/config/emVersion.xml";

  if(-e $inFile)
  {
    $CP = "$ORACLE_HOME/oc4j/jdbc/lib/ojdbc5dms.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/ojdbc14dms.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-net-ee.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-utility.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-collation.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-net.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-internal.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-servlet.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-lcsd.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-tools.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-mapping.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n-translation.jar$cpSep$ORACLE_HOME/oc4j/jdbc/lib/orai18n.jar$cpSep$ORACLE_HOME/oc4j/lib/dms.jar$cpSep$ORACLE_HOME/jdbc/lib/ojdbc14.jar$cpSep$ORACLE_HOME/jdbc/lib/nls_charset12.jar$cpSep$ORACLE_HOME/sysman/jlib/emagentSDK.jar$cpSep$ORACLE_HOME/sysman/jlib/emCORE.jar$cpSep$ORACLE_HOME/sysman/jlib/log4j-core.jar$cpSep$ORACLE_HOME/sysman/jlib/emCORE.jar$cpSep$ORACLE_HOME/lib/xmlparserv2.jar";

    $javaStr = "$JAVA_HOME/bin/java ".
               "-cp $CP ".
               "-DEMHOME=$EMHOME ".
               "-DORACLE_HOME=$ORACLE_HOME ".
               "oracle.sysman.emdrep.util.EMVersion $inFile";

    my @result = `$javaStr`;

    if (@result)
    {
      my $count = scalar(@result);
      my $i=0;
      while( $i < $count)
      {
        @comp = split /\s+/, $result[$i];
        if( lc($comp[0]) eq "releaseversion")
        {
          $relVer = $comp[1];
        }
        elsif( lc($comp[0]) eq "productversion")
        {
          $prodVer = $comp[1];
        }
        elsif( lc($comp[0]) eq "coreversion")
        {
          $coreVer = $comp[1];
        }
        elsif( lc($comp[0]) eq "copyrightbeginningyear")
        {
          $beginYear = $comp[1];
        }
        elsif( lc($comp[0]) eq "copyrightendingyear")
        {
          $endYear = $comp[1];
        }
        $i = $i + 1;
      }
    }
  }
  print "Oracle Enterprise Manager ".$prodVer." Release 4 Grid Control ".$banner_add." \n";
  print "Copyright (c) ".$beginYear.", ".$endYear ." Oracle Corporation.  All rights reserved.\n";
  print "$DB_URL\n" if ($INSTALL_TYPE_DB and defined($DB_URL));
  print "$IAS_URL \n" if ($INSTALL_TYPE_IAS and defined($IAS_URL));

  if($DEBUG_ENABLED)
  {
    print "NOHUP Files are $AGENT_NOHUPFILE | $DB_NOHUPFILE | $IAS_NOHUPFILE \n";
  }
}

1;
