#  $Header:
#
# Copyright (c) 2001, 2006, Oracle. All rights reserved.  
#
#    NAME
#
#    DESCRIPTION
#
#    MODIFIED   (MM/DD/YY)
#       rbelav 12/11/06 - Bug 5582424.
#       zmi    08/16/06 - Created.

package EMconnectorCmds;
use EmCommonCmdDriver;
use EmctlCommon;

my $ORACLE_HOME       = $ENV{ORACLE_HOME};
my $JAVA_HOME         = $ENV{JAVA_HOME};
my $osType = get_osType();
my $syslib = "$ORACLE_HOME/lib"; 
my $sysjlib = "$ORACLE_HOME/jlib"; 
my $jlib = "$ORACLE_HOME/sysman/jlib";
my $weblib = "$ORACLE_HOME/j2ee/OC4J_EM/applications/em/em/WEB-INF/lib";
my $classpath = "";
if ($osType eq 'WIN') {
  $classpath = "$jlib/emCORE.jar;$weblib/toplink.jar;$syslib/xml.jar;$jlib/log4j-core.jar;$sysjlib/classes12.jar;$sysjlib/xmlparserv2.jar;$syslib/servlet.jar;$ORACLE_HOME/j2ee/home/oc4j.jar;$weblib/emconnector.jar";
}
else {
  $classpath = "$jlib/emCORE.jar:$weblib/toplink.jar:$syslib/xml.jar:$jlib/log4j-core.jar:$sysjlib/classes12.jar:$sysjlib/xmlparserv2.jar:$syslib/servlet.jar:$ORACLE_HOME/j2ee/home/oc4j.jar:$weblib/emconnector.jar";
}

sub get_osType
{
    if (( $^O eq "Windows_NT") ||
        ( $^O eq "MSWin32")) {
        return "WIN";
    }

    my $os = `uname -s`;
    my $ver = `uname -r`;
    chomp ($os);

    if ( $os eq "SunOS" ) {
        if ( chomp($ver) !~ /^4./ ) {
            return "SOL";
        }
    } elsif ( $os eq "HP-UX" ) {
        return "HP";
    } elsif ( $os eq "Linux" ) {
        return "LNX";
    } elsif ( $os eq "AIX" ) {
        return "AIX";
    } elsif ( $os eq "OSF1" ) {
        return "OSF1";
    } elsif ( $os eq "Darwin" ) {
        return "MAC OS X";
    } else {
        # Unsupported Operating System
        return -1;
    }
}

sub new {
  my $classname = shift;
  my $self = { };
  bless ( $self, $classname);
  return $self;
}

sub doIT {
   my $classname = shift;
   my $rargs = shift;
   my $result = $EMCTL_UNK_CMD;

   $argCount = @$rargs; 
   #print "doIT of EMconnectorCmds: self is $classname, args passed @$rargs\n";
   if ( $rargs->[1] eq "connector" )
   {
     #print "Processing <options> connector \n";

     if ( $rargs->[0] eq "register_connector" )
     {
	 #print "Registering connector\n";
	 $rargs->[$argCount] = $ORACLE_HOME;
	 $result = registerConnector($rargs);
     }
     elsif ( $rargs->[0] eq "register_ticket_template" )
     {
	 #print "Registering ticket template\n";
	 $result = registerTT($rargs);
     }
     elsif ( $rargs->[0] eq "extract_jar" )
     {
	 #print "Extracting jar\n";
	 $rargs->[$argCount] = $ORACLE_HOME;
	 $result = extractJar($rargs);
     }
   }

   return $result;
}

#
# registerConnector
#
sub registerConnector()
{
  #print("Registering connector type ...\n");
  my $javaStr = "";

  local (*args) = @_;
  shift(@args); # shift out register_connector
  shift(@args); # shift out connector

  my $count = scalar(@args);
  if($count != 7 and $count != 8)
  {
    return($EMCTL_BAD_USAGE);
  }

  my $file = $args[0];
  my $server = $args[1];
  my $port = $args[2];
  my $db = $args[3];
  my $username = $args[4];
  my $password;
  my $oracleHome;
  if ($count == 7) {
    $oracleHome = $args[5];

    print("\nPlease enter the repository account password: ");
    system("stty -echo");
    $password = <STDIN>;
    chomp $password;
    print("\n");
    system("stty echo");
  }

  if ($count == 8) {
    $password = $args[5];
    $oracleHome = $args[6];
  }

  $javaStr = "$JAVA_HOME/bin/java ".
      "-cp $classpath ".
      " oracle.sysman.connector.registry.api.ConnectorControl ".
      "register_connector $file $server $port $db $username $password $oracleHome";
  
  $status = system($javaStr);
  $status >> 8;
  return $status;
}

#
# registerTT
#
sub registerTT()
{
  #print("Registering ticket template ...\n");
  my $javaStr = "";

  local (*args) = @_;
  shift(@args); # shift out register_ticket_template
  shift(@args); # shift out connector

  my $count = scalar(@args);
  if($count != 9 && $count != 10)
  {
    return($EMCTL_BAD_USAGE);
  }

  my $file = $args[0];
  my $server = $args[1];
  my $port = $args[2];
  my $db = $args[3];
  my $username = $args[4];
  my $password;
  my $connectorTypeName;
  my $connectorName;
  my $templateName;
  my $description;
  if ($count == 9) {
    $connectorTypeName = $args[5];
    $connectorName = $args[6];
    $templateName = $args[7];
    $description = $args[8];
    
    print("\nPlease enter the repository account password: ");
    system("stty -echo");
    $password = <STDIN>;
    chomp $password;
    print("\n");
    system("stty echo");
  }

  if ($count == 10) {
    $password = $args[5];
    $connectorTypeName = $args[6];
    $connectorName = $args[7];
    $templateName = $args[8];
    $description = $args[9];
  }

  $javaStr = "$JAVA_HOME/bin/java ".
      "-cp $classpath ".
      " oracle.sysman.connector.registry.api.ConnectorControl ".
      "register_ticket_template $file $server $port $db $username $password ".
      "$connectorTypeName $connectorName $templateName $description";

  $status = system($javaStr);
  $status >> 8;
  return $status;
}
#
# extractJar
#
sub extractJar()
{
  my $javaStr = "";

  #print("Extracting jar ...\n");

  local (*args) = @_;
  shift(@args); # shift out extract_jar
  shift(@args); # shift out connector
  my $count = scalar(@args);
  if($count < 3)
  {
    return($EMCTL_BAD_USAGE);
  }
  my $file = $args[0];
  my $connectorTypeName = $args[1];
  my $oracleHome = $args[2];

  $javaStr = "$JAVA_HOME/bin/java ".
      "-cp $classpath ".
      " oracle.sysman.connector.registry.api.ConnectorControl ".
      "extract_jar $file $connectorTypeName $oracleHome";

  $status = system($javaStr);
  $status >> 8;
  return $status;
}

sub usage
{
    print "EM Connector Commands Usage : \n";
    print "       emctl register_connector connector <connectorType.xml> <server> <port> <database sid> <username> <password> <oracleHome>\n";
    print "       or\n";
    print "       emctl register_connector connector <connectorType.xml> <server> <port> <database sid> <username> <oracleHome>\n";
    print "       emctl register_ticket_template connector <ticketTemplate.xml> <server> <port> <database sid> <username> <password> <connectorTypeName> <connectorName> <templateName> <description>\n";
    print "       or\n";
    print "       emctl register_ticket_template connector <ticketTemplate.xml> <server> <port> <database sid> <username> <connectorTypeName> <connectorName> <templateName> <description>\n";
    print "       emctl extract_jar connector <jarfile> <connectorTypeName> <oracleHome>\n";
    print "\n";
}

sub DESTROY {
    my $self = shift;
}

1;
#    
