#
#  $Header: EmKeyCmds.pm 29-sep-2006.03:36:32 shianand Exp $
#
#
# Copyright (c) 2003, 2006, Oracle. All rights reserved.  
#
#    NAME
#      EmKeyCmds.pm - Secure OMS Perl Module
#
#    DESCRIPTION
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    shianand    09/25/06 - fix bug 5520464
#    shianand    09/08/06 - fix bug 5518632 (fix configuring of emkey for RAC DB)
#    shianand    09/08/06 - fix bug 5518632 (fix configuring of emkey for RAC DB)
#    shianand    07/08/06 - fix bug 5375475
#    shianand    04/12/06 - fix bug 5158248 
#    shianand    04/12/06 - fix bug 5158248
#    smodh       01/20/06 - Replace classes12.jar with ojdbc14.jar 
#    kmanicka    08/30/05 - kmanicka_emkey_fix2
#    kmanicka    21/08/05 - Created
#
#


package EmKeyCmds;

use English;
use strict;
use vars '*args';

use EmCommonCmdDriver;
use EmctlCommon;
use Getopt::Long;



my $ORACLE_HOME       = $ENV{ORACLE_HOME};
my $JAVA_HOME         = $ENV{JAVA_HOME};
my $isRacNode         = "false";
my $racStateDir       = "";

sub new
{
  my $classname = shift;
  my $self = { };
  bless ($self, $classname);
  return $self;
}

sub doIT
{
  my $classname = shift;
  my $rargs     = shift;
  my $result    = $EMCTL_UNK_CMD; #Unknown command.

  my $argCount  = @$rargs;
  if ($argCount >= 2  && $rargs->[0] eq "config" && $rargs->[1] eq "emkey")
  {
    $result = configEmKey($rargs);
    exit($result);
  }
  if ($argCount >= 2  && $rargs->[0] eq "status" && $rargs->[1] eq "emkey")
  {
        $result = statusEmKey($rargs);
    exit($result);
  }
  else
  {
        $result = $EMCTL_UNK_CMD;
  }
  return $result;
} 


sub usage
{
  print "Em Key Commands Usage : \n";
  print "emctl config emkey -emkeyfile <emkey.ora path> [-force] [-sysman_pwd <sysman password>]\n";
  print "emctl config emkey -emkey [-emkeyfile <emkey.ora path>] [-force] [-sysman_pwd <sysman password>]\n";
  print "emctl config emkey -repos [-emkeyfile <emkey.ora path>] [-force] [-sysman_pwd <sysman password>]\n";
  print "emctl config emkey -remove_from_repos [-sysman_pwd <sysman password>]\n";
  print "emctl config emkey -copy_to_repos [-sysman_pwd <sysman password>]\n";
  print "emctl status emkey [-sysman_pwd <sysman password>]\n";
  print "\n";
}

######################################################################
# configEmKey()
#   EM KEY configuration related commands 
######################################################################
sub configEmKey
{
  my $reposFlag = "";
  my $forceFlag = "";
  my $emkeyFlag = "";
  my $emkeyfile = "";
  my $sysman_pwd = "";
  my $removeFromReposFlag = "";
  my $copyToReposFlag = "";
  my $host = "";
  my $sid = "";

  GetOptions("repos"=>\$reposFlag,
             "force"=>\$forceFlag,
             "emkey"=>\$emkeyFlag,
             "remove_from_repos"=>\$removeFromReposFlag,
             "copy_to_repos"=>\$copyToReposFlag,
             "emkeyfile:s"=>\$emkeyfile,
             "sysman_pwd:s"=>\$sysman_pwd,
             "host:s"=>\$host,
             "sid:s"=>\$sid);

  my $rc = $EMCTL_UNK_CMD;

  if($host ne "" and $sid ne "")
  {
     $isRacNode    = "true";
     $racStateDir  = $ORACLE_HOME."/".$host."_".$sid;
  }

  my $JAVA_STRING = getEmKeyJavaString();
  my $OPTION_STRING = "";
  my $sysman_pwd_str = "";
  my $emkeyStr = ""; 
  my $emkeyfileStr = "-no_emkeyfile"; 
  my $forceStr = "-no_force";
  if($forceFlag)
  {
    $forceStr = "-force";    
  }
  
  if($emkeyfile)
  {
    $emkeyfileStr = $emkeyfile;
  }

  if($sysman_pwd)
  {
    $sysman_pwd_str = $sysman_pwd;
  }
  else
  {
    $sysman_pwd_str = &EmctlCommon::promptUserPasswd("Please enter repository password: ");
    if($sysman_pwd_str eq '')
    { 
        # User hit enter without typing anything
        die "Invalid password!\n";
    }
  }
 
  if ($reposFlag)
  {
    $OPTION_STRING = "-config -repos $emkeyfileStr $forceStr";
  }
  elsif ($emkeyFlag)
  {
    $emkeyStr = promptUserPasswd("Please enter the em key : ");
    if($emkeyStr eq '')
    { 
       # User hit enter without typing anything
       die "Invalid Em Key!\n";
    }

    $OPTION_STRING = "-config -emkey $emkeyfileStr $forceStr $emkeyStr";
  }
  elsif($emkeyfile)
  {
    $OPTION_STRING = "-config -emkeyfile $emkeyfileStr $forceStr";
  }
  elsif($removeFromReposFlag)
  {
    $OPTION_STRING = "-config -remove_from_repos ";
  }
  elsif($copyToReposFlag)
  {
    $OPTION_STRING = "-config -copy_to_repos ";
  }
  else
  {
    usage();
    return $EMCTL_UNK_CMD; 
  }

  my $RUN_STRING = "$JAVA_STRING $OPTION_STRING";

  #print "$RUN_STRING \n";

  open(SETPWD, "|$RUN_STRING");
  print SETPWD "$sysman_pwd_str\n";
  close(SETPWD);

  $rc = 0xffff & $?;
  $rc >>= 8;

  return $rc;
}

######################################################################
# statusEmKey()
#   Verify the EM KEY
######################################################################


sub statusEmKey
{
  my $sysman_pwd = '';
  my $host = "";
  my $sid = "";

  GetOptions("sysman_pwd:s"=>\$sysman_pwd,
             "host:s"=>\$host,
             "sid:s"=>\$sid);

  my $sysman_pwd_str = "";     
  
  if($sysman_pwd)
  {
    $sysman_pwd_str = $sysman_pwd;
  }
  else
  {
    $sysman_pwd_str = &EmctlCommon::promptUserPasswd("Please enter repository password: ");
    if($sysman_pwd_str eq '')
    { 
       # User hit enter without typing anything
       die "Invalid password!\n";
    }
  }
    
  if($host ne "" and $sid ne "")
  {
     $isRacNode    = "true";
     $racStateDir  = $ORACLE_HOME."/".$host."_".$sid;
  }  
  
  my $rc = verifyEmKey($sysman_pwd_str);

  return $rc;
}

sub verifyEmKey
{
    my $sysman_pwd = $_[0];
    my $print_output = $_[1];
    my $stateHome = $_[2]; # add for secure dbconsole emkey check for rac setup

    if ($stateHome ne "")
    {
      $isRacNode    = "true";
      $racStateDir  = $stateHome;
    }

    my $rc = $EMCTL_UNK_CMD;
    my $JAVA_STRING = getEmKeyJavaString();
    my $RUN_STRING = "$JAVA_STRING -verify ";

    if( $print_output eq "false")
    {
      $RUN_STRING = "$RUN_STRING > $devNull";
    }

    open(SETPWD, "|$RUN_STRING");
    print SETPWD "$sysman_pwd\n";
    close(SETPWD);

    $rc = 0xffff & $?;
    $rc >>= 8;
    
    return $rc;
}

sub getEmKeyJavaString
{
  my $emConsoleMode = &SecureUtil::getConsoleMode();
  my $CLASSPATH     = &SecureUtil::getConsoleClassPath($emConsoleMode);
 
  my $emHome = "";

  if ($isRacNode eq "true")
  {
    $emHome = $racStateDir;
  } 
  else
  {
    $emHome = &SecureUtil::getEMHome($emConsoleMode);
  }
  my $JAVA_STRING = "$JAVA_HOME/bin/java -classpath $CLASSPATH ".
                    "-DConfigDir=$emHome/sysman/config/ -DORACLE_HOME=$ORACLE_HOME ".
                    "-DEMSTATE=$emHome oracle.sysman.eml.sec.rep.EmKeyUtil ";
  return $JAVA_STRING;
}


1;
