<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="aboutApplication" scope="request"
             type="oracle.sysman.eml.app.about.AboutApplication"/>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="licenseMsg"
              class="oracle.sysman.eml.license.LicenseMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>

        <uix:header textBinding="header@servletRequest">
          <uix:tableLayout width="65%">
            <uix:rowLayout>
              <uix:spacer height="10"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat width="70%">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="productLabel@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat width="30%"> 
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="productVersionText@servletRequest"/>
              </uix:cellFormat>
              <%-- uix:cellFormat>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="productionLevel@servletRequest"/>
             </uix:cellFormat --%>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="10"/>
            </uix:rowLayout>
           </uix:tableLayout>
        
<%--
           <uix:rowLayout width="100%">
            <uix:cellFormat  width="100%">
              <uix:tableLayout width="65%">
                 <uix:contents 
                     childDataBinding="supportedCompList@aboutApplication@servletRequest">
                    <uix:rowLayout width="100%">
                       <uix:cellFormat>    
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="name"/>
                       </uix:cellFormat>
                       <uix:cellFormat>    
                          <uix:spacer width="30"/>
                       </uix:cellFormat>
                       <uix:cellFormat>
                        <uix:stackLayout>
                           <uix:contents childDataBinding="supportedVersions">
                               <uix:flowLayout>
                               <uix:rawText text="&nbsp; " renderedBinding="showSpace"/>
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="version"/>
                               </uix:flowLayout>    
                               </uix:contents>
                        </uix:stackLayout>
                       </uix:cellFormat>
                     </uix:rowLayout>
--%>
                     <uix:rowLayout>
                        <uix:spacer height="10"/>
                     </uix:rowLayout>
<%--
                    </uix:contents>


                 </uix:tableLayout>
               </uix:cellFormat>
             </uix:rowLayout>
--%>
             <uix:rowLayout width="65%">
                 <uix:cellFormat>
                   <uix:styledText styleClass="OraInstructionText"
                              textBinding="accessLabel@servletRequest"/>
                 </uix:cellFormat>
                 <uix:cellFormat>    
                    <uix:spacer width="10"/>
                 </uix:cellFormat>

                 <uix:cellFormat> 
                    <uix:styledText styleClass="OraInstructionText"
                                text="<%= aboutApplication.AccessibilityMode(renderingContext)%>"/>
                 </uix:cellFormat>
              </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="10"/>
            </uix:rowLayout>


            <uix:rowLayout renderedBinding="renderDbLicenceInfo@servletRequest"> 
              <uix:cellFormat>
              <uix:link textBinding="productVersion@servletRequest"
                        destination="admin/rep/licensePopup?event=showPopup"/>
              </uix:cellFormat>
            </uix:rowLayout>
          <uix:stackLayout>
            <uix:spacer height="20"/>

            <uix:formattedText styleClass="OraInstructionText"
                            textBinding="copyright@servletRequest"/>

            <uix:spacer height="20"/>
            <uix:flowLayout>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="otnText@servletRequest"
                                renderedBinding="rendered@servletRequest"/>
                <uix:styledText styleClass="OraInstructionText"
                                text=" ("
                                renderedBinding="rendered@servletRequest"/>
                <uix:link textBinding="otnUrlText@servletRequest"
                          destinationBinding="otnUrlText@servletRequest"
                          renderedBinding="rendered@servletRequest"/>
                <uix:styledText styleClass="OraInstructionText"
                                text=")."
                                renderedBinding="rendered@servletRequest"/>
            </uix:flowLayout>

            <uix:spacer height="20"
                        renderedBinding="rendered@servletRequest"/>

            <uix:styledText styleClass="OraInstructionText"
                            textBinding="warningText@servletRequest"/>


          </uix:stackLayout>
        </uix:header>

        <uix:contentFooter>
          <uix:pageButtonBar>
             <uix:button textBinding="OK@commonResourceBundle"
                 shortDescBinding="OK@commonResourceBundle"
                  onClick="javascript:if(history){if(history.length <= 1){ document.location.href='../console/home';}else{history.go(-1);} }"/>
           </uix:pageButtonBar>
        </uix:contentFooter>
  
     </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
