<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="adminResourceBundle" class="oracle.sysman.eml.admin.rep.AdminResourceBundle"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemNoscript.jspf" %>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
    <uix:form name="mainControllerForm" method="post">
        <uix:pageLayout>
          <%@ include file=" /oemGlobal.jspf"%>
          <uix:contents>
            <uix:header textBinding="header@servletRequest"/>
            <uix:stackLayout>
            <uix:switcher childNameBinding="ERROR@servletRequest">
                <uix:case name="error">
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:messageBox 
                        messageBinding="ERROR_MSG@servletRequest" 
                        messageType="error" 
                        textBinding="error"/>
                      <uix:spacer height="20"/>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:case>                
              </uix:switcher>
              <uix:rowLayout hAlign="right">
                <uix:pageButtonBar>
                  <uix:submitButton textBinding="CANCEL@commonResourceBundle" renderedBinding="NOTSUPER@servletRequest"  name="event" value="ct_cancel" />
                  <uix:submitButton textBinding="OK@commonResourceBundle" name="event" value="ct_ok" />
                </uix:pageButtonBar>
              </uix:rowLayout>
              <uix:spacer height="5"/>
              
              <uix:stackLayout>
                <uix:ref refID="INCLUDING_PAGE_NODE" />
            </uix:stackLayout>
            </uix:stackLayout>
          </uix:contents>
          <uix:tip textBinding="TARGET_HOME_TIP@adminResourceBundle"/>
	  <uix:contentFooter>
            <uix:pageButtonBar>
	       <uix:submitButton textBinding="CANCEL@commonResourceBundle" renderedBinding="NOTSUPER@servletRequest" name="event"    value="ct_cancel"/>
              <uix:submitButton textBinding="OK@commonResourceBundle" name="event" value="ct_ok" />
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>
        </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

