<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:form name="assignRules" method="POST" >
        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="10@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="adminUserPage@assignRules@servletRequest"/>
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@assignRules@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="adminUserPage@assignRules@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@assignRules@servletRequest">
            <uix:messageBox messageBinding="msg@assignRules@servletRequest"
                            messageTypeBinding="msgType@assignRules@servletRequest"
                            textBinding="valErrText@assignRules@servletRequest">
              <uix:contents childDataBinding="valErrData@assignRules@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@assignRules@servletRequest" >
            <uix:header textBinding="title@assignRules@servletRequest" >

            <uix:tableLayout width="100%" >
              <uix:rowLayout >
                <uix:cellFormat hAlign="left" >
                  <uix:styledText textBinding="ADMIN_ASSIGN_RULES_INTR@notifResourceBundle"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" >
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="cancelAssignRules"/>
                    <uix:submitButton textBinding="OK@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="doAssignRules"/>
                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5" />

              <uix:table name="assignRules"
                         width="100%"
                         showAll="yes"
                         formSubmitted="true"
                         alternateTextBinding="NO_PUBLIC_NOTIF_RULES@notifResourceBundle"
                         summaryBinding="PUBLIC_NOTIF_RULES_HDR@notifResourceBundle"
                         valueBinding="value@@assignRules@servletRequest"
                         minValueBinding="minValue@@assignRules@servletRequest"
                         blockSizeBinding="blockSize@@assignRules@servletRequest"
                         maxValueBinding="maxValue@@assignRules@servletRequest"
                         columnHeaderDataBinding="columnHeader@assignRules@servletRequest"
                         tableDataBinding="publicRules@assignRules@servletRequest" >

                <uix:tableFormat tableBanding="rowBanding"/>
                          
                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="selected@"
                                         shortDescBinding="SELECT@notifResourceBundle" >
                    <uix:submitButton textBinding="SUBSCRIBE@notifResourceBundle" 
                                      name="event"
                                      value="subscribeRules" />
                    <uix:spacer width="5" />
                    <uix:submitButton textBinding="UNSUBSCRIBE@notifResourceBundle" 
                                      name="event"
                                      value="unsubscribeRules" />
                  </uix:multipleSelection>
                </uix:tableSelection>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader sortableBinding="sortable"
                                      textBinding="text"/>
                </uix:columnHeaderStamp>

                  <uix:styledText textBinding="name@"
                                  shortDescBinding="RULE_NAME@notifResourceBundle" />
                  <uix:styledText textBinding="owner@"
                                  shortDescBinding="RULE_NAME@notifResourceBundle" />

                  <uix:styledText textBinding="desc@"
                                  shortDescBinding="RULE_DESCRIPTION@notifResourceBundle" />

                  <uix:styledText textBinding="status@"
                                  shortDescBinding="STATUS@notifResourceBundle" />

                  <uix:formValue name="value" valueBinding="value@" />

              </uix:table>

              <uix:spacer height="10" />

            </uix:header>

          </uix:stackLayout>

          <uix:contentFooter>
            <uix:stackLayout rendered="true"
                             renderedBinding="showContents@assignRules@servletRequest" >
              <uix:pageButtonBar>

                    <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="cancelAssignRules"/>
                    <uix:submitButton textBinding="OK@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="doAssignRules"/>
              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
