<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="searchBundle"
    class="oracle.sysman.eml.ecm.search.util.SearchResourceBundle" />
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>


  <uix:bundle name="mntrBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  
  
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:form name="refForm" method="GET">
        <uix:formValue name="<%= CSAConsts.COLLECTION_TAG_PARAM %>" 
                        valueBinding="collectionTag@servletRequest"/>
        <uix:formValue name="<%= CSAConsts.SEARCH_BEAN_ID_PARAM %>" 
                       valueBinding="searchBeanID@servletRequest"/>
        <uix:formValue name="<%= CSAConsts.PAGE_PARAM %>" 
                       valueBinding="page@servletRequest"/>
        <uix:formValue name="<%= CSAConsts.CHART_PARAM %>" 
                       valueBinding="chart@servletRequest"/>
        <uix:formValue name="<%= CSAConsts.SLICE_PARAM %>" 
                       valueBinding="slice@servletRequest"/>
        <uix:formValue name="<%= CSAConsts.OTHER_PARAM %>" 
                       valueBinding="slice@servletRequest"/>



          <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:button textBinding="RETURN_BUTTON@mntrBundle"
                                destinationBinding="returnDest@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>
              </uix:pageButtonBar>
            </uix:pageButtons>


          <oem:messageBox messageType="error"
            titleTextKey="titleText" mainTextKey="mainText"
            errorTableBinding="createErrors@servletRequest"/>

          <oem:messageBox messageType="warning"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="warnings@servletRequest"/>



          <uix:switcher childNameBinding="renderConf@servletRequest">
            <uix:case name="yes">
              <uix:messageBox messageType="confirmation"
                              messageBinding="confMsg@servletRequest" />
            </uix:case>
          </uix:switcher>

<%--          <uix:messageBox messageType="confirmation" 
                          messageBinding="confMsg@servletRequest"
                          renderedBinding="renderConf@servletRequest" />
--%>
          <uix:breadCrumbs>
            <uix:contents>
              <uix:link textBinding="breadText@servletRequest"
                        destinationBinding="breadDest@servletRequest"/>
              <uix:styledText textBinding="headerText@servletRequest"/>
            </uix:contents>
          </uix:breadCrumbs>


          <uix:header textBinding="headerText@servletRequest">
            <uix:contents>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="CREATE_ASSOC_INSTR_TEXT@csaBundle"/>
                              
              <uix:spacer height="10"/>
              <uix:stackLayout>
                <uix:contents>
                  <uix:rowLayout hAlign="right">
                    <uix:contents>
                      <oem:targetSelection textBinding="ADD@csaBundle"/>
 
                    </uix:contents>
                  </uix:rowLayout>
              
                  <uix:spacer height="20"/>
              
                  <uix:dataScope currentDataBinding="collectionTagAssocBean@servletRequest">
                    <uix:table name="targetListTable"
                               id="targetListTableID"
                               partialRenderMode="self"
                               alternateTextBinding="NO_DATA_FOUND@csaBundle"
                               formSubmitted="true"
                               width="100%"
                               minValue="1"
                               tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                               valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                               maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                               blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                               summaryBinding="TBLSUM_RESULTSTABLE@csaBundle">
                  
                      
                      <uix:tableFormat tableBanding="rowBanding"/>
                      <uix:tableSelection>
                        <uix:multipleSelection shortDescBinding="MULTISEL_RESULTSTABLE@csaBundle"
                                               disabledBinding="disableSelect@servletRequest" >
                          <uix:contents>
                            <uix:submitButton renderedBinding="hasPrivs@servletRequest" name="event" value="deleteConfirm" textBinding="BTN_DELETE@csaBundle"/>
                          </uix:contents>
                        </uix:multipleSelection>
                      </uix:tableSelection>
                           
                      <%-- Target Name column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_TARGET_NAME@csaBundle"
                                              sortableBinding="<%= CSAConsts.S_SORT_TARGET_NAME %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= CSAConsts.S_LBL_TARGET_NAME %>"
                                  destinationBinding="<%= CSAConsts.S_DEST_TARGET_NAME %>" />
                      </uix:column>
                        
                      <%-- Target Type Column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_TARGET_TYPE@csaBundle"
                                              sortableBinding="<%= CSAConsts.S_SORT_TARGET_TYPE %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_TARGET_TYPE %>" />
                      </uix:column>
                    </uix:table>
                  </uix:dataScope>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:header>
      </uix:pageLayout>
        </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
