<%--
  -- Page:       blackoutReasons.jsp
  -- Controller: oracle.sysman.eml.admin.rep.blackout.ReasonsPageHandler
  --
  -- Description: This jsp respresents the Manage Blackout Reasons
  --              functionality.
  --
--%>
<%-- Tag Libraries --%>
<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%-- Imports --%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <%-- Message Bundles --%>
  <uix:bundle name="sdkBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="blackoutsBundle" class="oracle.sysman.eml.admin.rep.blackout.BlackoutResourceBundle"/>
  <%-- Start Document --%>
  <uix:document>
    <%-- Include the partial page rendering file --%>
    <%@ include file="/enablePPR.jspf"%>
    <%-- Include the title file --%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf" %>
    <%-- Start the Body --%>
    <uix:body>
      <%-- Start the page-wide form --%>
      <uix:form name="blackoutReasonsForm" method="POST">
        <%-- Start the page layout --%>
        <uix:pageLayout>
          <%-- Include the global includes file --%>
          <%@ include file="/oemGlobal.jspf"%>
          <%-- Display confirmation/error messages if any. --%>
          <uix:messageBox messageBinding="confirmMessage@pageLevelData@servletRequest"
                          messageTypeBinding="messageType@pageLevelData@servletRequest"
                          renderedBinding="showConfirmMessage@pageLevelData@servletRequest">
            <uix:contents childDataBinding="errorList@errorData@servletRequest">
              <uix:link textBinding="label" longDescBinding="message"
                        destinationBinding="destination"/>
            </uix:contents>
          </uix:messageBox>
          <%-- Start the header section --%>
          <%-- This contains the main page data --%>
          <uix:header textBinding="BLACKOUT_REASONS_TITLE@blackoutsBundle">
            <uix:stackLayout>
              <uix:rowLayout hAlign="right" vAlign="top">
                <uix:pageButtonBar>
                  <uix:submitButton textBinding="CANCEL@sdkBundle"
                                    shortDescBinding="CANCEL@sdkBundle"
                                    name="event"
                                    value="cancel"/>
                  <uix:submitButton textBinding="OK@sdkBundle" 
                                    shortDescBinding="OK@sdkBundle"
                                    name="event"
                                    value="ok"/>
                </uix:pageButtonBar>
              </uix:rowLayout>
              <uix:spacer height="20"/>
              <%-- Display info/instruction about Blackout reasons at the top --%>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="BLACKOUT_REASONS_DESC@blackoutsBundle"/>
              <uix:spacer height="10"/>
              <!-- Begin Table for Arranging Checkbox -->
              <uix:tableLayout width="95%" cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:checkBox name="reasonRequired" id="reasonRequired"
                                  value="true"
                                  shortDescBinding="REASONS_REQUIRED@blackoutsBundle"
                                  checkedBinding="reasonRequired@pageLevelData@servletRequest"/>
                    <uix:spacer width="2"/>
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="REASONS_REQUIRED@blackoutsBundle"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <!-- End Table for Arranging Checkbox -->
              <uix:spacer height="10"/>
              <!-- Start Table for Displaying Blackout Reasons -->
              <uix:table id="R" partialRenderMode="self" name="R"
                         alternateTextBinding="NO_REASONS_DEFINED@blackoutsBundle"
                         summaryBinding="BLACKOUT_REASONS_TITLE@blackoutsBundle"
                         width="50%" formSubmitted="true"
                         showAll="yes"
                         valueBinding="value@reasonsDataList@servletRequest"
                         minValueBinding="minValue@reasonsDataList@servletRequest"
                         blockSizeBinding="blockSize@reasonsDataList@servletRequest"
                         maxValueBinding="maxValue@reasonsDataList@servletRequest"
                         columnHeaderDataBinding="column@reasonsDataList@servletRequest"
                         tableDataBinding="row@reasonsDataList@servletRequest">
                <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text"
                                      sortableBinding="sortable"
                                      valueBinding="value"/>
                </uix:columnHeaderStamp>
                <%-- Set the Table Format so that alternate rows are
                     displayed in different colours (rowBanding) --%>
                <uix:tableFormat tableBanding="rowBanding"/>
                <!-- Start Table Selection -->
                <uix:tableSelection>
                  <uix:singleSelection selectedIndexBinding="selectedIndex@reasonsDataList@servletRequest"
                                       shortDescBinding="SELECT@commonBundle">
                    <uix:submitButton textBinding="DELETE@sdkBundle"
                                      shortDescBinding="DELETE@sdkBundle"
                                      name="event" value="remove"/>
                  </uix:singleSelection>
                </uix:tableSelection>
                <uix:columnFooter>
                  <uix:addTableRow/>
                </uix:columnFooter>
                <!-- End Table Selection -->
                <!-- Begin Table Displayable Contents -->
                <uix:contents>
                  <uix:switcher childNameBinding="isReasonDuplicate">
                    <uix:case name="true">
                      <uix:messageTextInput name="reasonDisplayValue"
                                            id="reasonDisplayValue"
                                            textBinding="reasonDisplayValue"
                                            shortDescBinding="REASON@blackoutsBundle"
                                            readOnlyBinding="isExistingBlackoutReason"
                                            maximumLength="64" columns="40"
                                            messageType="error"
                                            anchorBinding="reasonDisplayValue"/>
                    </uix:case>
                    <uix:case name ="false">
                      <uix:textInput name="reasonDisplayValue"
                                     id="reasonDisplayValue"
                                     textBinding="reasonDisplayValue"
                                     shortDescBinding="REASON@blackoutsBundle"
                                     readOnlyBinding="isExistingBlackoutReason"
                                     maximumLength="64" columns="40"/>
                    </uix:case>
                  </uix:switcher>
                  <uix:formValue name="reasonFormValue"
                                 valueBinding="reasonFormValue"/>
                </uix:contents>
                <!-- End Table Displayable Contents -->
              </uix:table>
              <!-- End Table for Displaying Blackout Reasons -->
            </uix:stackLayout>
          </uix:header>
          <%-- End the header section --%>
          <%-- Start the content footer --%>
          <%-- This contains the global page footer buttons --%>
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkBundle" 
                                shortDescBinding="CANCEL@sdkBundle" 
                                name="event"
                                value="cancel"/>
              <uix:submitButton textBinding="OK@sdkBundle"
                                shortDescBinding="OK@sdkBundle"
                                name="event"
                                value="ok"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
          <%-- End the content footer --%>
        </uix:pageLayout>
        <%-- End the page layout --%>
      </uix:form>
      <%-- End the page-wide form --%>
    </uix:body>
    <%-- End the Body --%>
  </uix:document>
  <%-- End Document --%>
</uix:renderingContext>
