<%--
  -- Page:       blackoutsPageSegment.jsp
  -- Controller: oracle.sysman.eml.admin.rep.blackout.GroupsBlackoutsSegmentHandler
  --
  -- Description: This jsp is a page segment which is included on the groups
  --              Homepage to represent the Blackouts.
  --
--%>
<%@ include file="/sdk/oemTop.jspf"%>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%-- Start the Page Segment --%>
<oem:pageSegment>
  <uix:dataScope>
    <%-- Message Bundles --%>
    <uix:bundle name="adminBundle" class="oracle.sysman.eml.admin.rep.AdminResourceBundle"/>
    <uix:bundle name="sdkBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <%-- Start the Contents of the Page Segment --%>
    <uix:contents>
      <uix:stackLayout>
        <uix:header textBinding="BLACKOUT_TITLE@adminBundle">
          <uix:rowLayout hAlign="right" vAlign="top">
            <uix:button textBinding="CREATE@sdkBundle"
                        destinationBinding="createBlackout@blackoutsSegmentData@servletRequest"/>
          </uix:rowLayout>
          <uix:spacer height="30"/>
          <%-- Begin Table to display blackouts info for the group --%>
          <uix:table width="100%" showAll="yes"
                     columnHeaderDataBinding="column@blackoutsSegmentData@servletRequest"
                     tableDataBinding="row@blackoutsSegmentData@servletRequest"
                     columnFormatsBinding="columnFormats@blackoutsSegmentData@servletRequest"
                     summaryBinding="BLACKOUT_TITLE@adminBundle">
            <uix:columnHeaderStamp>
              <uix:sortableHeader textBinding="text"/>
            </uix:columnHeaderStamp>
            <%-- Set the Table Format so that alternate rows are
               displayed in different colours (rowBanding) --%>
            <uix:tableFormat tableBanding="rowBanding"/>
            <!-- Begin Table Displayable Contents -->
            <uix:contents>
              <!--Status-->
              <uix:styledText textBinding="rowLabel"/>
              <!--Group Info-->
              <uix:switcher childNameBinding="groupCount">
                <uix:case name="0">
                  <uix:styledText textBinding="groupCount"/>
                </uix:case>
                <uix:default>
                  <uix:styledText textBinding="groupCount"
                                  destinationBinding="groupURL"/>
                </uix:default>
              </uix:switcher>
              <!--Member Info-->
              <uix:switcher childNameBinding="memberCount">
                <uix:case name="0">
                  <uix:styledText textBinding="memberCount"/>
                </uix:case>
                <uix:default>
                  <uix:styledText textBinding="memberCount"
                                  destinationBinding="memberURL"/>
                </uix:default>
              </uix:switcher>
            </uix:contents>
            <!-- End Table Displayable Contents -->
          </uix:table>
          <%-- End Table to display blackouts info for the group --%>
        </uix:header>
      </uix:stackLayout>
    </uix:contents>
    <%-- End the Contents of the Page Segment --%>
  </uix:dataScope>
</oem:pageSegment>
<%-- End the Page Segment --%>