<%--
  -- Page:       blackoutReasons.jsp
  -- Controller: oracle.sysman.eml.admin.rep.blackout.ReasonsPageHandler
  --
  -- Description: This jsp respresents the Manage Blackout Reasons
  --              functionality.
  --
--%>
<%-- Tag Libraries --%>
<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%-- Imports --%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <%-- Message Bundles --%>
  <uix:bundle name="sdkBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="blackoutsBundle" class="oracle.sysman.eml.admin.rep.blackout.BlackoutResourceBundle"/>
  <%-- Start Document --%>
  <uix:document>
    <%-- Include the partial page rendering file --%>
    <%@ include file="/enablePPR.jspf"%>
    <%-- Include the title file --%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf" %>
    <%-- Start the Body --%>
    <uix:body>
      <%-- Start the page-wide form --%>
      <uix:form name="blackoutReasonsForm" method="POST">
        <%-- Start the page layout --%>
        <uix:pageLayout>
          <%-- Include the global includes file --%>
          <%@ include file="/oemGlobal.jspf"%>          
          <%-- Start the header section --%>
          <%-- This contains the main page data --%>
          <uix:header textBinding="RBK_CONFIG_TITLE@blackoutsBundle">
            <uix:stackLayout>
              <uix:rowLayout hAlign="right" vAlign="top">
                <uix:pageButtonBar>
                  <uix:submitButton textBinding="CANCEL@sdkBundle"
                                    shortDescBinding="CANCEL@sdkBundle"
                                    name="event"
                                    value="cancel"/>
                  <uix:submitButton textBinding="OK@sdkBundle" 
                                    shortDescBinding="OK@sdkBundle"
                                    name="event"
                                    value="ok"/>
                </uix:pageButtonBar>               
                
              </uix:rowLayout>
              <uix:styledText textBinding="RBK_CONFIG_PROMPT@blackoutsBundle" styleClass="OraInstructionText"/>
              <uix:spacer height="20"/>   
              <uix:checkBox id = "isRbkEnabled"
                            name = "isRbkEnabled"
                            checkedBinding="isRbkEnabled@servletRequest" 
                            textBinding="ENABLE_CHECKBOX_TEXT@blackoutsBundle" 
                            shortDescBinding="ENABLE_CHECKBOX_TEXT@blackoutsBundle" />
            </uix:stackLayout>
          </uix:header>
          <%-- End the header section --%>
          <%-- Start the content footer --%>
          <%-- This contains the global page footer buttons --%>
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkBundle" 
                                shortDescBinding="CANCEL@sdkBundle" 
                                name="event"
                                value="cancel"/>
              <uix:submitButton textBinding="OK@sdkBundle"
                                shortDescBinding="OK@sdkBundle"
                                name="event"
                                value="ok"/>
            </uix:pageButtonBar>
          </uix:contentFooter>
          <%-- End the content footer --%>
        </uix:pageLayout>
        <%-- End the page layout --%>
      </uix:form>
      <%-- End the page-wide form --%>
    </uix:body>
    <%-- End the Body --%>
  </uix:document>
  <%-- End Document --%>
</uix:renderingContext>
