<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import='oracle.sysman.emSDK.util.help.Help'%>
<%@ page import='oracle.sysman.emSDK.svlt.EMServletUtil'%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="emdConfigMsg"
              class="oracle.sysman.eml.admin.rep.emdConfig.EmdConfigMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

        <%
             String returnUrl =  EMServletUtil.getConsoleServletPath(renderingContext.getServletContext()) + "/" + (String)request.getParameter("returnUrl");
             String dest = Help.selectHelpTopicsValue(request, response, 
                           "oem_admin_task_add_host");
        %>
        <uix:header messageType="info" textBinding="INFORMATION@sdkUIMsg">
          <uix:stackLayout>
            <uix:styledText styleClass="OraDataText" 
                        textBinding="ADD_HOST_DESC@emdConfigMsg" />
            <uix:spacer height="10" />
            <uix:styledText styleClass="OraInstructionText" 
                            textBinding="ADD_HOST_DESC1@emdConfigMsg"/>
            <uix:spacer height="10" />
            <uix:flowLayout>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="ADD_HOST_DESC2@emdConfigMsg"/>
              <uix:spacer width="5"/>
              <uix:link textBinding="ADD_HOST_LINK@emdConfigMsg"
                        destination="<%=dest%>"/>
            </uix:flowLayout>
          </uix:stackLayout>

        </uix:header>

        <uix:contentFooter>
          <uix:pageButtonBar>
            <uix:button textBinding="OK@sdkUIMsg" destination="javascript: history.back()" />
          </uix:pageButtonBar>
        </uix:contentFooter>

      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
