<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.cabo.ui.data.DictionaryData"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkUIMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="licenseUIMsg" class="oracle.sysman.eml.license.LicenseMsg"/>
  <uix:document>
   <%@ include file="/enablePPR.jspf"%>    
    <uix:head titleBinding="header@licensePopupData@servletRequest"/>
     <uix:body>
      <uix:form name="licensePopup" method="get">
       <uix:pageLayout  titleBinding="header@licensePopupData@servletRequest">
        <%@ include file="/oemNoscript.jspf" %>
        <%@ include file="/oemGlobal.jspf"%>
         <uix:stackLayout>
           <uix:rowLayout>
           <uix:styledText styleClass="OraInstructionText" 
                 textBinding="instrText@licensePopupData@servletRequest"/>
             <uix:button textBinding="OK@sdkUIMsg"         
              onClick="javascript:history.go(-1)"
              shortDescBinding="OK@sdkUIBundle"
              />
             <uix:spacer height="20"/>
           </uix:rowLayout>
         </uix:stackLayout>

           <uix:spacer height="20"/>
 <uix:table name="licenseSetupTable" id="licenseSetupTable" 
      partialRenderMode="self" 
      alternateTextBinding="SEARCH_NAME_NOT_FOUND@mntrResourceBundle"
      width="100%" blockSize="25" 
      valueBinding="value@licensePopupData@servletRequest" 
      minValueBinding="minValue@licensePopupData@servletRequest"
      maxValueBinding="maxValue@licensePopupData@servletRequest" 
      formSubmitted="true" 
      tableDataBinding=
       "tableDataKey@tableData@licensePopupData@servletRequest" 
      columnFormatsBinding=
        "columnFormats@licensePopupData@servletRequest" 
      columnHeaderDataBinding=
       "columnHeaderData@licensePopupData@servletRequest"
      summaryBinding="LICENSING_INFO@licenseUIMsg">
    
       <uix:tableFormat tableBanding="rowBanding"/>
                    <uix:columnHeaderStamp>
                      <uix:sortableHeader textBinding="text"/>
                    </uix:columnHeaderStamp>
                   
	 
         <uix:contents>                
         <uix:styledText textBinding="shortName" styleClass="OraPromptText"/>
         </uix:contents>                
         
         
         <uix:column>
         <uix:contents>                
         <uix:styledText textBinding="packName" styleClass="OraPromptText"/>
         </uix:contents>  
         </uix:column>
         
         <uix:column>
         <uix:contents childDataBinding="targetTypeVec">                
	 <uix:styledText textBinding="targetType" styleClass="OraPromptText"/>
	 </uix:contents>        
	 </uix:column>

	 <uix:column>
         <uix:contents> 
         <uix:rawText textBinding="packDesc" 
           styleClass="OraPromptText"/>
	 </uix:contents>        
	 </uix:column>
	 
         </uix:table>
         
         
             <!-- related links -->
	             <uix:header textBinding="RELATED_LINKS@sdkUIMsg" 
                             renderedBinding="showRelatedLinks@servletRequest">
	                <uix:tableLayout width="100%">
	                   <uix:contents childDataBinding="relatedLinks@servletRequest">
			      <uix:rowLayout>
			         <uix:cellFormat width="33%">
				    <uix:link textBinding="text0"
				              destinationBinding="destination0"/>
				  </uix:cellFormat>
				  <uix:cellFormat width="33%">
				  <uix:styledText textBinding="text1"
					 destinationBinding="destination1"/>
				  </uix:cellFormat>
				  <uix:cellFormat width="33%">
				  <uix:styledText textBinding="text2"
					 destinationBinding="destination2"/> 
			          </uix:cellFormat>
			       </uix:rowLayout>
			    </uix:contents>
			 </uix:tableLayout>			 
                    </uix:header>

        <uix:contentFooter>
        <uix:pageButtonBar>
        <uix:button textBinding="OK@sdkUIMsg"         
              onClick="javascript:history.go(-1)"
              shortDescBinding="OK@sdkUIBundle"
              />
        </uix:pageButtonBar>
        </uix:contentFooter> 
      </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
