<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.metrics.template.AdminSideNavData"%>
<%@ page import="oracle.sysman.emSDK.TargetTypes"%>
<%@ page import="oracle.sysman.eml.license.LicenseSetupData"%>
<%@ page import="oracle.sysman.eml.admin.rep.AdminResourceBundle"%>
<%@ page import="oracle.sysman.resources.CommonResourceBundle"%>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="mntrResourceBundle"
                  class="oracle.sysman.resources.MntrResourceBundle"/>
<uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="licenseBundle" class="oracle.sysman.eml.license.LicenseMsg"/>
<uix:bundle name="ResourceBundle" class="oracle.sysman.eml.admin.rep.AdminResourceBundle"/>
<uix:bundle name="commonBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
<!-- The script to submit the form when the enter key (13) is hit -->
<uix:document>
  <%@ include file="/oemTitle.jspf"%>
  <uix:body>
    <uix:form name="licenseSetupForm" method="POST">
    <uix:script text= "
    function getKey(keyStroke)
    { 
        var isNav = (navigator.appName.indexOf('Netscape') != -1);
        if (isNav)
        {
           document.captureEvents(Event.KEYPRESS);
           document.onkeypress = getKey;
        }
        key = (isNav) ? keyStroke.which : event.keyCode;
        if(key == '13')
        {
            submitForm('licenseSetupForm',1,{'event':'ct_go'});
            return false;
        }
    }" />
      <uix:pageLayout>
        <%@ include file="/enablePPR.jspf"%>
        <%@ include file="/oemNoscript.jspf" %>
        <%@ include file="/oemGlobal.jspf"%>
        <%@ include file="../../health/header.jsp"%>
        <uix:start>
          <%@ include file="/metrics/template/adminSideNav.jspf"%>
        </uix:start>
        <uix:contents>
          <uix:switcher childNameBinding="errorMsg@errorMap@servletRequest">
              <uix:case name="error">
                    <uix:messageBox
                              messageBinding="errorMsgText@errorMap@servletRequest"
                              messageType="error"
                              textBinding="errorMsg@errorMap@servletRequest"/>
              </uix:case>
              <uix:case name="noError">
            <uix:messageBox
                      messageBinding="errorMsgText@errorMap@servletRequest"
                      messageTypeBinding="errorMsgType@errorMap@servletRequest" /> 
              </uix:case>
          </uix:switcher>
          <!-- Start of Page -->
          <uix:header textBinding="header@servletRequest"/>
          <uix:tableLayout hAlign="left" width="100%">
            <uix:rowLayout hAlign="left" vAlign="top" width="800">
                <uix:cellFormat width="580">
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="instrText@licenseSetupData@servletRequest"/>
                </uix:contents>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout hAlign="left">
              <uix:cellFormat hAlign="left">
                  <uix:spacer height="10"/>
              </uix:cellFormat>
            </uix:rowLayout>    
            <uix:rowLayout hAlign="left">
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout hAlign="left"> 
                  <uix:cellFormat hAlign="left" columnSpan="2">
                       <uix:header textBinding="VIEW@licenseBundle" size="1"/>  
                       <uix:styledText styleClass="OraInstructionText"
                                       textBinding="OPTION_TEXT@licenseBundle"/>
                        <uix:spacer height="5"/>
                        <uix:messageRadioButton
                               name="viewOption"
                               styleClass="OraPromptText"
                               id="viewOption1"
                               onClick="submitForm('licenseSetupForm',0,{event:'option', viewOptionVal:'option_parent'});return	false"
                               selectedValueBinding = "option@servletRequest"
                               textBinding = "OPTION_1@licenseBundle"
                               shortDescBinding = "OPTION_1@licenseBundle"
                               value = "option_parent"/>
                        <uix:messageRadioButton
                               name="viewOption"
                               styleClass="OraPromptText"
                               id="viewOption2"
                               onClick="submitForm('licenseSetupForm',0,{event:'option', viewOptionVal:'option_all',targetType:'all'});return false"
                               selectedValueBinding = "option@servletRequest"
                               textBinding = "OPTION_2@licenseBundle" 
                               shortDescBinding = "OPTION_2@licenseBundle"
                               value = "option_all"/>

                  </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout hAlign="left">
                <uix:cellFormat hAlign="left" columnSpan="2">
                     <uix:spacer height="10"/>
                     <uix:separator/>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout hAlign="left">
           <uix:cellFormat hAlign="left" width="580">
               <uix:spacer height="5"/>
                   <uix:tip>
                      <uix:contents>
                         <uix:styledText textBinding = "searchTipText@licenseSetupData@servletRequest" />
                      </uix:contents>
                   </uix:tip>
                   <uix:spacer height="10"/>
               </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout hAlign="left">
               <uix:cellFormat hAlign="left">
                       <uix:styledText  styleClass="OraInstructionText"  textBinding="SEARCH@ResourceBundle"/>
                       <uix:choice  name="targetType"
                                selectedValueBinding="targetType@licenseSetupData@servletRequest"
                                shortDescBinding="SEARCH@ResourceBundle">
                            <uix:contents  childDataBinding="targetTypeList@licenseSetupData@servletRequest">
                                <uix:option  textBinding="text"
                                             valueBinding="value"
                                             rendered="true"/>
                            </uix:contents>
                        </uix:choice>
                        <uix:textInput name="searchTarget"
                                   textBinding="searchTarget@licenseSetupData@servletRequest"
                                   shortDescBinding="SEARCH@ResourceBundle"
                                   onKeyPress="getKey()"/>
                        <uix:submitButton textBinding="GO_BUTTON@mntrResourceBundle" shortDescBinding="GO_BUTTON@mntrResourceBundle"
                                      name="event" value="ct_go"/>
               </uix:cellFormat>
              <uix:cellFormat hAlign="right" vAlign="top">
                       <uix:pageButtonBar>
                            <uix:submitButton
                                  textBinding="REVERT_BUTTON@mntrResourceBundle"
                                  shortDescBinding="REVERT_BUTTON@mntrResourceBundle"
                                  name="event" value="ct_revert"/>
                            <uix:submitButton  textBinding="APPLY@sdkUIBundle"
                                  name="event" value="ct_apply" shortDescBinding="APPLY@sdkUIBundle"/>
                       </uix:pageButtonBar>
               </uix:cellFormat> 
           
            </uix:rowLayout>
            <uix:rowLayout>
                   <uix:cellFormat columnSpan="3">
                      <uix:spacer height="10"/>
                   </uix:cellFormat>
             </uix:rowLayout>
             <uix:formValue name="event" value="ct_go"/> 
             <uix:formValue name="chosenTargetType"
                            valueBinding="targetType@licenseSetupData@servletRequest"/>
             <uix:formValue name="searchTargetName"
                            valueBinding="searchTarget@licenseSetupData@servletRequest"/>

             <uix:rowLayout>
                    <uix:cellFormat columnSpan="3">
                            <uix:table name="licenseSetupTable" id="licenseSetupTable"
                                   alternateTextBinding="SEARCH_NAME_NOT_FOUND@mntrResourceBundle"
                                   width="100%" 
                                   partialRenderMode="self"
                                   valueBinding="value@licenseSetupData@servletRequest"
                                   minValueBinding="minValue@licenseSetupData@servletRequest"
                                   maxValueBinding="maxValue@licenseSetupData@servletRequest"
                                   blockSizeBinding="blockSize@licenseSetupData@servletRequest"
                                   formSubmitted="true"
                                   tableDataBinding="tableDataKey@tableData@licenseSetupData@servletRequest"
                                   columnFormatsBinding="columnFormats@licenseSetupData@servletRequest"
                                   columnHeaderDataBinding="columnHeaderData@licenseSetupData@servletRequest"
                                   showAll="yes"  
                                   summaryBinding="LICENSE_TABLE_SUMMARY@licenseBundle">
                             <uix:tableFormat tableBanding="rowBanding"/>
                             <uix:columnHeaderStamp>
                                 <uix:sortableHeader textBinding="text"
                                                     sortableBinding="sortable"/>
                             </uix:columnHeaderStamp>
                             <uix:column>
                                  <uix:contents>
                                       <uix:styledText textBinding="Name"/>
                                   </uix:contents>
                             </uix:column>
                             <uix:column>
                                 <uix:contents>
                                      <uix:styledText textBinding="Type"/>
                                 </uix:contents>
                             </uix:column>
                             <uix:contents>
<%
      //Iterate to dynamically display the packs column,
      //since the number of packs can be different for different
      //target types.Also we have to check the pack that is already
      //applied for the given target.

       oracle.sysman.eml.license.LicenseSetupData licenseSetupData =
       ((oracle.sysman.eml.license.LicenseSetupData)request.getAttribute(
       "licenseSetupData"));

        String targetType = licenseSetupData.getTargetType();
        String viewOption = oracle.sysman.eml.license.LicenseSetupData.getViewOption(request);
        if(((targetType.equals(TargetTypes.ORACLE_DATABASE_TARGET_TYPE)
             ||   targetType.equals(TargetTypes.ORACLE_IAS_TARGET_TYPE))
             && ("option_parent".equals(viewOption)|| viewOption ==	null))
           || ("option_all".equals(viewOption) && licenseSetupData.getShowHost()))
        {
%>
                                 <uix:styledText textBinding="Host"/>
<%
        }
        java.util.ArrayList packList = licenseSetupData.getPackList();
        String pack = null;
        String disable = null;
        String na=null;
        String dest=null;
        for (int i=0;i< packList.size(); i++)
        {
          java.util.Map map = (java.util.HashMap)(packList.get(i));
          pack = (String)map.get("text");
          disable = pack+"_disable";
          na = pack+"_na";
          dest=pack+"_dest";

%> 
          <uix:switcher childNameBinding="<%=disable%>">
               <uix:case name="false">
           <uix:switcher childNameBinding="<%=na%>">
             <uix:case name="true">
                 <uix:tableLayout width="100%">
                   <uix:contents>
                     <uix:rowLayout>
                      <uix:cellFormat hAlign="right" width="50%">                       
                   <uix:checkBox name="<%=pack%>"
                              valueBinding="<%=pack%>"
                              selectedValue="on"
                          disabled="true"
                          shortDescBinding="<%=pack%>"/>
                       </uix:cellFormat>
				       <uix:cellFormat hAlign="center" width="50%">
                         <uix:image  source="/em/images/Init_ora_edit.gif" 
			       destinationBinding="<%=dest%>" shortDescBinding="SELECT@licenseBundle"/>
                       </uix:cellFormat>
                      </uix:rowLayout>
                     </uix:contents>
                   </uix:tableLayout>
             </uix:case>
			 <uix:default>
  			  <uix:tableLayout width="100%">
                  <uix:contents>
                    <uix:rowLayout>
                       <uix:cellFormat hAlign="right" width="49%">
             			  <uix:checkBox name="<%=pack%>"
                              valueBinding="<%=pack%>"
                              selectedValue="on"
                              disabledBinding="<%=disable%>"
                              shortDescBinding="SELECT@licenseBundle"/>
                        </uix:cellFormat>
			            <uix:cellFormat hAlign="center" width="51%">
                             <uix:image   source="/em/images/Transparent.gif"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                   </uix:contents>
                </uix:tableLayout>
			</uix:default>
		</uix:switcher>
              </uix:case>
              <uix:case name="true">
                   <uix:image   source="/em/images/sysdash_notappl.gif" 
                                shortDescBinding="NOT_APPLICABLE@licenseBundle" />
              </uix:case>
          </uix:switcher>
<%
       }
%>
					  </uix:contents>
					  <uix:contents>
						   <uix:switcher childNameBinding="confirmation">
								<uix:case name="true">
									 <uix:image	source="/em/images/okind_status.gif" 
									            shortDescBinding="CONFIRMED@licenseBundle" />
								</uix:case>
								<uix:case name="false">
									 <uix:checkBox name="agreeAccess"
												  value="off"
												  checked="false"
												  disabled="false"
												  shortDescBinding="SELECT@commonBundle"/>
							   </uix:case>
						   </uix:switcher>
						   <uix:formValue name="targetConfirmed"
										  valueBinding="confirmString"/>
					  </uix:contents>
				  </uix:table>
				  <uix:spacer height="10"/>
			 </uix:cellFormat>
			</uix:rowLayout>
   			<uix:rowLayout hAlign="left">
   				<uix:cellFormat width="580">
				   <uix:tip renderedBinding="showTipDisplay@licenseSetupData@servletRequest">
                         <uix:styledText textBinding="dbTip@licenseSetupData@servletRequest"/>
                   </uix:tip>
   					<uix:tip>
   						 <uix:styledText textBinding="bottomInstrText@licenseSetupData@servletRequest"/>
   					</uix:tip>
   			   </uix:cellFormat>
    		   <uix:cellFormat hAlign="right" vAlign="top">
    				   <uix:pageButtonBar>
    						<uix:submitButton
    							  textBinding="REVERT_BUTTON@mntrResourceBundle"
    							  shortDescBinding="REVERT_BUTTON@mntrResourceBundle"
    							  name="event" value="ct_revert"/>
    						<uix:submitButton  textBinding="APPLY@sdkUIBundle"
    							  name="event" value="ct_apply"	shortDescBinding="APPLY@sdkUIBundle"/>
    				   </uix:pageButtonBar>
    		   </uix:cellFormat>    			   
   			</uix:rowLayout>
            <uix:rowLayout hAlign="right" width="100%">
            <uix:cellFormat columnSpan="2">
            <uix:contents>
               <uix:header textBinding="RELATED_LINKS@sdkUIBundle">
                  <uix:tableLayout width="100%">
                    <uix:contents childDataBinding="relatedLinks@servletRequest">
                    <uix:rowLayout>
                        <uix:cellFormat width="50%">
                            <uix:styledText textBinding="text0"
                                      destinationBinding="destination0"/>
                             </uix:cellFormat>
                             <uix:cellFormat width="33%">
                                <uix:styledText textBinding="text1"
                                          destinationBinding="destination1"/>

                             </uix:cellFormat>
                             <uix:cellFormat width="33%">
                                 <uix:styledText textBinding="text2"
                                  destinationBinding="destination2"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:contents>
                  </uix:tableLayout>
               </uix:header>
               </uix:contents>
               </uix:cellFormat>
            </uix:rowLayout>    
            </uix:tableLayout>
        </uix:contents>
      </uix:pageLayout>
    </uix:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
