<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>
<%@ page import="oracle.sysman.eml.metrics.template.AdminSideNavData"%>             

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="searchBundle"
    class="oracle.sysman.eml.ecm.search.util.SearchResourceBundle" />
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>
  
  
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <uix:start>
          <%@ include file="/metrics/template/adminSideNav.jspf"%>
        </uix:start>
        <%@ include file="../../health/header.jsp" %>
        <oem:messageBox messageType="error"
            titleTextKey="titleText" mainTextKey="mainText"
            errorTableBinding="errors@servletRequest"/>

        <uix:form name="refForm" 
                  method="GET">

          <uix:header textBinding="FUNC_CLIENT_CONFIGS@csaBundle">
            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="GS_TOP_INSTR_TEXT_1@csaBundle"/>
                  <uix:spacer height="10"/>
                  <uix:subTabLayout>
                    <uix:subTabs>
                      <uix:subTabBar selectedIndex="0">
                        <uix:contents>
                          <uix:link textBinding="OUT_OF_BOX_HDR@csaBundle"
                                    destinationBinding="OOBDest@servletRequest"/>
                          <uix:link textBinding="CURRENT_ASSOC_HDR@csaBundle"
                                    destinationBinding="assocDest@servletRequest"/>
                        </uix:contents>
                      </uix:subTabBar>
                    </uix:subTabs>
                    <uix:contents>
    
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:spacer height="20"/>
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="OOB_TOP_INSTR_TEXT@csaBundle"/>
        
                          <uix:spacer height="10"/>
                          <uix:header textBinding="OOB_MANAGEMENT_HDR@csaBundle">
                            <uix:contents>
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="OOB_BUTTON_INSTR_TEXT@csaBundle"/>
                                  <uix:spacer height="10"/>
                                  <uix:rowLayout hAlign="left">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText"
                                                      textBinding="ACTIVATION_STATUS@csaBundle"/>
                                      <uix:spacer width="5"/>
                                      <uix:image sourceBinding="statusImage@servletRequest"/>
                                      <uix:spacer width="5"/>
                                      <uix:submitButton renderedBinding="hasPrivs@servletRequest"
                                                        textBinding="buttonText@servletRequest"
                                                        formName="refForm"
                                                        name="event"
                                                        valueBinding="buttonValue@servletRequest"/>
                                                        
                                    </uix:contents>
                                  </uix:rowLayout>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:header>
                          <uix:spacer height="10"/>
                          <uix:header textBinding="LBL_COLLECTION_URL@csaBundle">
                            <uix:contents>
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="OOB_COLLECTION_URL_INSTR_TEXT@csaBundle"/>
                                  <uix:spacer height="10"/>
                                  <uix:tableLayout hAlign="center">
                                    <uix:contents>
                                      <uix:cellFormat vAlign="top">
                                        <uix:contents>
                                          <uix:tableLayout>
                                            <uix:contents>
                                            
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:styledText textBinding="OOB_APP_URL@csaBundle"
                                                      styleClass="OraPromptText"/>
                                      <uix:spacer width="5"/>
                                      <uix:link textBinding="appLink@servletRequest"
                                                destinationBinding="appLink@servletRequest"/>
                                    </uix:contents>
                                  </uix:rowLayout>
                                  <uix:rowLayout>
                                  <uix:spacer height="30"/>
                                  </uix:rowLayout>
                                  <uix:rowLayout hAlign="left">
                                    <uix:contents>
                                      <uix:styledText textBinding="OCS_OOB_APP_URL@csaBundle"
                                                      styleClass="OraPromptText"/>
                                      <uix:spacer width="5"/>
                                      <uix:link textBinding="appLinkForOCS@servletRequest"
                                                destinationBinding="appLinkForOCS@servletRequest"/>
                                    </uix:contents>
                                  </uix:rowLayout>
                                  </uix:contents>
                                  </uix:tableLayout>
                                  </uix:contents>
                                  </uix:cellFormat>
                                  </uix:contents>
                                  </uix:tableLayout>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:header>
        
                      
                          <uix:header textBinding="COLLECTOR_TARGETS@csaBundle">
                            <uix:contents>
                              <uix:stackLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="OOB_COLLECTOR_INSTR_TEXT@csaBundle"/>
                                  <uix:spacer height="5"/>
                                  <uix:dataScope currentDataBinding="outOfBoxBean@servletRequest">
                                    <uix:table name="outOfBoxTable"
                                               id="outOfBoxTableID"
                                               partialRenderMode="self"
                                               alternateTextBinding="NO_DATA_FOUND@csaBundle"
                                               formSubmitted="true"
                                               width="100%"
                                               minValue="1"
                                               tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                               valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                               maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                               blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                               summaryBinding="TBLSUM_RESULTSTABLE@csaBundle">
                                           
                                      <%-- Collector Target column --%>
                                      <uix:column>
                                        <uix:columnHeader>
                                          <uix:sortableHeader textBinding="LBL_CSACOLLECTOR@csaBundle"
                                                              sortableBinding="<%= CSAConsts.S_SORT_CSACOLLECTOR %>" />
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat"/>
                                        <uix:link textBinding="<%= CSAConsts.S_LBL_CSACOLLECTOR %>"
                                                  destinationBinding="<%= CSAConsts.S_DEST_CSACOLLECTOR %>" />
                                      </uix:column>
                                        
                                      <%-- OMS Column --%>
                                      <uix:column>
                                        <uix:columnHeader>
                                          <uix:sortableHeader textBinding="LBL_OMS@csaBundle"
                                                              sortableBinding="<%= CSAConsts.S_SORT_OMS %>" />
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat"/>
                                        <uix:link textBinding="<%= CSAConsts.S_LBL_OMS %>"
                                                  destinationBinding="<%= CSAConsts.S_DEST_OMS %>" />
                                      </uix:column>
                    
                                      <%-- OMS Status Column --%>
                                      <uix:column>
                                        <uix:columnHeader>
                                          <uix:sortableHeader textBinding="LBL_OMS_STATUS@csaBundle"
                                                              sortableBinding="<%= CSAConsts.S_SORT_OMS_STATUS %>" />
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                                        <uix:image sourceBinding="<%= CSAConsts.S_LBL_OMS_STATUS %>" 
                                                   destinationBinding="<%= CSAConsts.S_DEST_OMS %>" />
                                      </uix:column>
                    
                                      <%-- Agent Column --%>
                                      <uix:column>
                                        <uix:columnHeader>
                                          <uix:sortableHeader textBinding="LBL_AGENT@csaBundle"
                                                              sortableBinding="<%= CSAConsts.S_SORT_AGENT %>" />
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat"/>
                                        <uix:link textBinding="<%= CSAConsts.S_LBL_AGENT %>"
                                                  destinationBinding="<%= CSAConsts.S_DEST_AGENT %>" />
                                      </uix:column>
                    
                                      <%-- Agent Status Column --%>
                                      <uix:column>
                                        <uix:columnHeader>
                                          <uix:sortableHeader textBinding="LBL_AGENT_STATUS@csaBundle"
                                                              sortableBinding="<%= CSAConsts.S_SORT_AGENT_STATUS %>" />
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                                        <uix:image sourceBinding="<%= CSAConsts.S_LBL_AGENT_STATUS %>" 
                                                   destinationBinding="<%= CSAConsts.S_DEST_AGENT %>" />
                                      </uix:column>
                    
                                    </uix:table>
                                  </uix:dataScope>
                                </uix:contents>
                              </uix:stackLayout>
                            </uix:contents>
                          </uix:header>
                          <uix:spacer height="20"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:subTabLayout>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:header>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
