<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>
             

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="searchBundle"
    class="oracle.sysman.eml.ecm.search.util.SearchResourceBundle" />
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>
  
  
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <uix:start>
          <%@ include file="/metrics/template/adminSideNav.jspf"%>
        </uix:start>

        <oem:messageBox messageType="error"
            titleTextKey="titleText" mainTextKey="mainText"
            errorTableBinding="errors@servletRequest"/>

        <oem:messageBox messageType="info"
            titleTextKey="titleText" mainTextKey="mainText"
            errorTableBinding="noRowsMsg@servletRequest"/>

        <uix:form name="refForm" 
                  method="GET">

          <uix:header textBinding="FUNC_CLIENT_CONFIGS@csaBundle">
            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="SETUP_TOP_INSTR_TEXT@csaBundle"/>
                  <uix:spacer height="10"/>
                  <uix:subTabLayout>
                    <uix:subTabs>
                      <uix:subTabBar selectedIndex="1">
                        <uix:contents>
                          <uix:link textBinding="OUT_OF_BOX_HDR@csaBundle"
                                    destinationBinding="OOBDest@servletRequest"/>
                          <uix:link textBinding="CURRENT_ASSOC_HDR@csaBundle"
                                    destinationBinding="assocDest@servletRequest"/>
                        </uix:contents>
                      </uix:subTabBar>
                    </uix:subTabs>
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:spacer height="10"/>
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="SETUP_COLLECTION_TAG_INSTR_TEXT@csaBundle"/>
                          <uix:spacer height="5"/>
                          <uix:bulletedList>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="GS_COLLECTION_TAG_BULLET_1@csaBundle"/>
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="GS_COLLECTION_TAG_BULLET_2@csaBundle"/>
                            </uix:contents>
                          </uix:bulletedList>
                          <uix:spacer height="30"/>     
                          <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                          <uix:spacer height="20"/>
               
                          
                          <uix:dataScope currentDataBinding="assocTableBean@servletRequest">
                            <uix:table name="currAssocTable"
                                       id="currAssocTableID"
                                       partialRenderMode="self"
                                       alternateTextBinding="NO_DATA_FOUND@csaBundle"
                                       formSubmitted="true"
                                       width="100%"
                                       minValue="1"
                                       tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                       valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                       maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                       blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                       summaryBinding="TBLSUM_RESULTSTABLE@csaBundle">
                              
                              <uix:tableFormat tableBanding="rowBanding"/>
                              
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="CSA_APPID@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_APPID %>" />
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText textBinding="<%= CSAConsts.S_LBL_APPID %>" />
                              </uix:column>
                      
                              <uix:column> 
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="TARGETS@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_TARGET_LIST %>" />
                                  </uix:columnHeader> 
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:styledText textBinding="<%= CSAConsts.S_LBL_TARGET_LIST %>" />
                              </uix:column>
            
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="LBL_NUMCLIENTS@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_NUM_CLIENTS %>" />
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat"/>
                                <uix:link textBinding="<%= CSAConsts.S_LBL_NUM_CLIENTS %>" 
                                          destinationBinding="<%= CSAConsts.S_DEST_APPID %>" />
                              </uix:column>
                              
                              <uix:column>
                                <uix:columnHeader>
                                  <uix:sortableHeader textBinding="VIEW_EDIT_ASSOCS@csaBundle"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                                <uix:image source="/em/images/updateicon_enabled.gif" 
                                          destinationBinding="<%= CSAConsts.S_DEST_EDIT_ASSOCS %>" />
                              </uix:column>
                              
                            </uix:table>
                          </uix:dataScope>
                          <uix:spacer height="10"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:subTabLayout>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:header>
        </uix:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

                      
                                
                                              
