<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.tgt.sel.TargetSelectionUtil"%>


<script language="javascript">
function setLovUrl(url)
{
  document.forms[0].lovUrl.value = url;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="bamBundle"
              class="oracle.sysman.resources.eml.bam.BamMsg"/>

<uix:bundle name="templBundle"
             class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
  <uix:bundle name="notifBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:bundle name="mntrBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>

    <uix:metaContainer> 
      <uix:head titleBinding="metricTitle@servletRequest" /> 
    </uix:metaContainer> 
    <uix:body>

      <uix:form name="addMetrics" method="POST" destination="/console/bam/dataOutboundSessionAddMetrics">
 
        <uix:pageLayout>

          <uix:formValue name="lovUrl"/>

        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../health/header.jsp" %> 
	<uix:contents>
	<uix:train value="2" maxVisited="3">
	<uix:contents>
	<uix:link textBinding="SESSION_SETUP@bamBundle"/>
	<uix:link textBinding="SELECT_TARGETS@bamBundle" />
	<uix:link textBinding="SCHEDULE@mntrBundle"/>
	<uix:link textBinding="REVIEW@notifBundle"/>
	
	</uix:contents>
	</uix:train>
	<uix:separator>
	</uix:separator>
        </uix:contents>
 
          <uix:spacer height="5"/>

              <uix:stackLayout> <!-- rendered="true"
                           renderedBinding="showContents@addMetrics@servletRequest" -->
            <uix:header textBinding="title@servletRequest" >

            <uix:tableLayout width="100%" >
              <uix:rowLayout >
                <uix:cellFormat hAlign="left" >
                  <uix:styledText textBinding="ADD_METRICS_DESC@bamBundle" 
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" >
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@commonBundle" 
		    unvalidated="true" name="event" value="cancelMetrics"
		    shortDescBinding="CANCEL@commonBundle"/>
		    
                    <uix:submitButton textBinding="OK@commonBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="doAddMetrics"
				      shortDescBinding="OK@commonBundle" />

                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
	    <uix:spacer height="10"/>
            
	    <uix:messageBox messageType="warning"
                          renderedBinding="errorOccurred@servletRequest"
                          rendered="false">
            <uix:contents>
              <uix:text textBinding="errorMsg@servletRequest"/>
            </uix:contents>
          </uix:messageBox>

            <uix:labeledFieldLayout width="40%" columns="3">
 
			    <uix:messageStyledText
                                           styleClass="OraPromptText"
                                           textBinding="TARGET@mntrBundle" />
                                     
					   <uix:messageStyledText
                                                   styleClass="OraDataText" textBinding="selectedTarget@servletRequest"
                                                   shortDescBinding="SELECT_TARGET_LOV_FIELD_LABEL@templBundle"/>

			    <uix:image source="/em/sdk/images/searchicon_enabled.gif" hAlign="left"
			    onClick="<%=TargetSelectionUtil.getOnClick()%>" shortDescBinding="SELECT_TARGET@bamBundle" />


            </uix:labeledFieldLayout>
            <uix:rowLayout>
             <uix:formValue name="searchPage"/>                     
            </uix:rowLayout>

             <uix:stackLayout>

	  <uix:header textBinding="METRICS_ALERTS@bamBundle" rendered="false"
                            renderedBinding="cacheLost@addMetrics@servletRequest">
		<uix:table 
			rendered="false"
                            renderedBinding="cacheLost@addMetrics@servletRequest"
			    name="addMetrics"
                         width="100%"
                         showAll="yes"
                         alternateTextBinding="NO_METRIC@bamBundle"
                         summaryBinding="METRICS@notifBundle"
                         columnHeaderDataBinding="columnHeader@addMetrics@servletRequest" >
                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader sortableBinding="sortable"
                                      textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:contents >
                  <uix:styledText textBinding="label@"
                                  shortDescBinding="METRIC@notifBundle" />
		   <uix:styledText textBinding="label@"/>
		   <uix:styledText textBinding="label@"/>
		   <uix:styledText textBinding="label@"/>

                 </uix:contents>

                </uix:table>
	  </uix:header>
          </uix:stackLayout>


	 <uix:stackLayout rendered="true"
                           renderedBinding="showContents@addMetrics@servletRequest" >
     
        
	<uix:header textBinding="METRICS_ALERTS@bamBundle">
<uix:rowLayout rendered="false" width="100%"
                           renderedBinding="showBatch@servletRequest">
			   <uix:contents>
			   <uix:cellFormat width="61%"/>
			   <uix:cellFormat hAlign="right">
  
        <uix:contentContainer background="light" width="100%">
          <uix:contents>
            <uix:stackLayout>
              <uix:contents>
                <uix:rowLayout width="100%">
                <uix:contents>
                  <uix:cellFormat  width="35%" hAlign="center">
                  <uix:contents>
                    <uix:styledText styleClass="OraInstructionText"
                          textBinding="BATCH_SELECT@bamBundle"/>
                  </uix:contents>
                  </uix:cellFormat>
                  <uix:cellFormat  width="35%" hAlign="center">
                  <uix:contents>
                    <uix:styledText styleClass="OraDataText"
                                textBinding="SEND_METRIC@bamBundle"/>
                  </uix:contents>
                  </uix:cellFormat>
                  </uix:contents>
                  <uix:contents>                 
                    <uix:cellFormat width="1%" />
                    <uix:cellFormat hAlign="center">
                      <uix:contents>
                    <uix:styledText styleClass="OraDataText"
                                textBinding="SEND_ALERT@bamBundle"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>


 		<uix:spacer height="10" />
	      <uix:contents>
                <uix:rowLayout width="100%">
                <uix:contents>
                  <uix:cellFormat  width="35%" hAlign="center"/>
                  <uix:cellFormat  width="30%" hAlign="center">
                  <uix:contents>
                        
		  <uix:submitButton name="event" event="selectAllMetric"
                                      value="selectAllMetric"
                                      textBinding="SELECT_ALL@bamBundle"
				      shortDescBinding="SELECT_ALL@bamBundle"/>
                  </uix:contents>
                  </uix:cellFormat>
                  </uix:contents>
                  <uix:contents>                 
                  <uix:cellFormat  width="5%"/>
                    <uix:cellFormat hAlign="center">
                      <uix:contents>
                        <uix:submitButton name="event" event="selectAllAlert"
                                      value="selectAllAlert"
                                      textBinding="SELECT_ALL@bamBundle"
				      shortDescBinding="SELECT_ALL@bamBundle"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>

                </uix:rowLayout>
              </uix:contents>

		
	      <uix:spacer height="10" />
	      <uix:contents>
                <uix:rowLayout width="100%">
                <uix:contents>
                  <uix:cellFormat  width="35%" hAlign="center"/>
                  <uix:cellFormat  width="30%" hAlign="center">
                  <uix:contents>
                        
		  <uix:submitButton name="event" event="selectNoneMetric"
                                      value="selectNoneMetric"
                                      textBinding="SELECT_NONE@bamBundle"
				      shortDescBinding="SELECT_NONE@bamBundle"/>
                  </uix:contents>
                  </uix:cellFormat>
                  </uix:contents>
                  <uix:contents>                 
                  <uix:cellFormat  width="5%"/>
                    <uix:cellFormat hAlign="center">
                      <uix:contents>
                        <uix:submitButton name="event" event="selectNoneAlert"
                                      value="selectNoneAlert"
                                      textBinding="SELECT_NONE@bamBundle"
				      shortDescBinding="SELECT_NONE@bamBundle"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
  

            </uix:stackLayout>
          </uix:contents>
        </uix:contentContainer>
	</uix:cellFormat>
	</uix:contents>
	</uix:rowLayout>

 		<uix:spacer height="20" />
              <uix:table name="addMetrics"
                         width="100%"
                         showAll="yes"
                         formSubmitted="true"
                         alternateTextBinding="NO_METRIC@bamBundle"
                         summaryBinding="METRICS@notifBundle"
			 minValue="1"
			 maxValueBinding="maxValue@addMetrics@servletRequest"
                         valueBinding="value@addMetrics@servletRequest"
                         columnHeaderDataBinding="columnHeader@addMetrics@servletRequest"
                         tableDataBinding="availMetrics@addMetrics@servletRequest" >
                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader sortableBinding="sortable"
                                      textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:contents >
                  <uix:styledText textBinding="label@"
                                  shortDescBinding="METRIC@notifBundle" />

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:formValue name="metricID" 
                                 valueBinding="metricID@"  />
                  <uix:styledText rendered="true"
                                  renderedBinding="noKeyColumn@"
                                  textBinding="textNA@" />
                  <uix:stackLayout rendered="false"
                                   renderedBinding="hasKeyColumn@" >
                    <uix:radioButton name="keyValuesChoice"
                                     textBinding="keyColLabel@"
                                     shortDescBinding="keyColLabel@"
                                     value="all"
                                     selectedBinding="allSelected@" />
                      <uix:flowLayout>
                        <uix:radioButton name="keyValuesChoice"
                                         textBinding="SELECT@notifBundle"
                                         shortDescBinding="SELECT@notifBundle"
                                         selectedBinding="selectSelected@"
                                         value="select" />
                        <uix:lovField name="keyValuesField" 
                                      onClickBinding="onClickScript@"
                                      textBinding="keyValuesField@"
                                      columns="40"
                                      shortDescBinding="CLICK_TO_SELECT_OBJ@notifBundle" 
                                      searchDescBinding="CLICK_TO_SELECT_OBJ@notifBundle"/>
                      </uix:flowLayout>
                    </uix:stackLayout>
                  </uix:column>
		  <uix:column >
                  <uix:columnFormat columnDataFormat="iconButtonFormat" />
                  <uix:stackLayout>
                    <uix:checkBox name="sMetric"
                                     checkedBinding="sendMetric@"
                                     shortDescBinding="sendMetric@"
                                     value="true"
                                      />
                    </uix:stackLayout>
                  </uix:column>
		  <uix:column >
                  <uix:columnFormat columnDataFormat="iconButtonFormat" />
                  <uix:stackLayout>
                    <uix:checkBox name="sAlert"
                                     checkedBinding="sendAlert@"
                                     shortDescBinding="sendAlert@"
                                     value="true"
                                      />
                    </uix:stackLayout>
                  </uix:column>
                   

                  <uix:formValue name="metric" valueBinding="value@" />
                  <uix:formValue name="label" valueBinding="label@" />

                 </uix:contents>

                </uix:table>

    
                </uix:header>

              </uix:stackLayout>
</uix:header>
	    </uix:stackLayout>


              <uix:contentFooter>
                <uix:stackLayout> <!-- rendered="true"
                                 renderedBinding="showContents@addMetrics@servletRequest" -->
                <uix:pageButtonBar>

                <uix:submitButton textBinding="CANCEL@commonBundle" 
			    unvalidated="true" name="event" value="cancelMetrics"
			    shortDescBinding="CANCEL@commonBundle"/>
                <uix:submitButton textBinding="OK@commonBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="doAddMetrics"
				  shortDescBinding="OK@commonBundle"/>

              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>
      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
