<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 

<uix:renderingContext id="renderingContext" >
<oem:setURLEncoder id="renderingContext"/> 
   <uix:bundle name="bamBundle"
              class="oracle.sysman.resources.eml.bam.BamMsg"/>
  <uix:bundle name="notifBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:bundle name="mntrBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>

  <uix:document> 
   <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>

     <uix:metaContainer> 
      <uix:head titleBinding="schTitle@servletRequest" /> 
    </uix:metaContainer> 

    <uix:body>
    <uix:form name="scheduleForm" method="POST">
     <uix:pageLayout>

     <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../health/header.jsp" %> 
	<uix:train selectedIndex="2">
	<uix:contents>
	<uix:link textBinding="SESSION_SETUP@bamBundle"/>
	<uix:switcher childNameBinding="sessionType@servletRequest">
	<uix:case name="inbound">
	<uix:link textBinding="SELECT_BUSINESS@bamBundle" />
	</uix:case>
	<uix:default>
	<uix:link textBinding="SELECT_TARGETS@bamBundle" />
	</uix:default>
	</uix:switcher>
	<uix:link textBinding="SCHEDULE@mntrBundle"/>
	<uix:link textBinding="REVIEW@notifBundle"/>
	</uix:contents>
	</uix:train>
	<uix:separator>
	</uix:separator>
 
	<uix:messageBox messageType="error"
                          renderedBinding="errorOccurred@errors@servletRequest"
                          rendered="false">
            <uix:contents childDataBinding="errorList@errors@servletRequest">
              <uix:link textBinding="label"
                        longDescBinding="message"
                        destinationBinding="destination" />
            </uix:contents>
          </uix:messageBox>


	  <uix:header textBinding="title@servletRequest" />
	<uix:rowLayout>
	<uix:cellFormat width="80%">
	<uix:switcher childNameBinding="sessionType@servletRequest">
	<uix:case name="inbound">
	<uix:styledText styleClass="OraInstructionText" textBinding="ISESSION_SCHEDULE_DESC@bamBundle" />
	</uix:case>
	<uix:default>
	<uix:styledText styleClass="OraInstructionText" textBinding="SESSION_SCHEDULE_DESC@bamBundle" />
	</uix:default>
	</uix:switcher>


	</uix:cellFormat>
	<uix:cellFormat>
    <%-- Page level form submit buttons --%>
        <uix:pageButtonBar>
          <uix:contents>

	  <uix:switcher childNameBinding="sessionType@servletRequest">
	<uix:case name="inbound">
	  <uix:button styleClass="OraButtonText" textBinding="CANCEL_BUTTON@mntrBundle" destination="dataInboundSession" />
	</uix:case>
	<uix:default>
	  <uix:button styleClass="OraButtonText" textBinding="CANCEL_BUTTON@mntrBundle" destination="dataOutboundSession" />
	</uix:default>
	</uix:switcher>

 
	  <uix:navigationBar
          name="adminNav"
          blockSize="-1"
          formSubmitted="true"
	  formName="scheduleForm"
	  unvalidated="true"
          maxValue="4"
          minValue="1"
          value="3"/>
          <uix:submitButton styleClass="OraButtonText" 
                textBinding="REVIEW@notifBundle" 
                name="event" 
                value="finish"
		unvalidated="true"
		formName="scheduleForm"/> 
     
        </uix:contents>
        </uix:pageButtonBar>
	</uix:cellFormat>
      </uix:rowLayout>
	  

        
    <%-- Form definition --%>


	  <%-- <uix:switcher childNameBinding="sessionType@servletRequest">
	<uix:case name="inbound">
	  <uix:header textBinding="CREATE_ISCHEDULE@bamBundle" />
	</uix:case>
	<uix:default>
	  <uix:header textBinding="CREATE_SCHEDULE@bamBundle" />
	</uix:default>
	</uix:switcher>--%>
	  <uix:stackLayout>

	<uix:spacer height="20" />
	<uix:stackLayout>
	<uix:spacer width="2" />
	<uix:radioButton name="schedule" value="later" textBinding="SCHEDULE_LATER@bamBundle" onClick="submitForm('scheduleForm',1,{event:'scheduleEvent'},false);return true;" selectedBinding="selectedLater@servletRequest"/>
	<uix:spacer height="10" />
	<uix:radioButton name="schedule" value="now" textBinding="SCHEDULE_NOW@bamBundle" onClick="submitForm('scheduleForm',1,{event:'scheduleEvent'},false);return true;" selectedBinding="selectedNow@servletRequest"/>
	</uix:stackLayout>
    
	<%-- <uix:rowLayout width="80%">
	<uix:spacer width="2" />
	<uix:styledText styleClass="OraInstructionText" text="Schedule Now" />
	</uix:rowLayout>--%>
                <%-- <uix:contentContainer width="80%" background="transparent"> --%>
                    <%-- include the schedule pagesegment. --%>
		    <uix:rowLayout renderedBinding="scheduleDisable@servletRequest" rendered="true">
                    <uix:ref refID="SCHEDULE_SEGMENT"/>
		    </uix:rowLayout>
          </uix:stackLayout>

<%-- Page level form submit buttons --%>
              <uix:contentFooter>
	      <uix:stackLayout>
        <uix:pageButtonBar>
	  <uix:switcher childNameBinding="sessionType@servletRequest">
	<uix:case name="inbound">
	  <uix:button styleClass="OraButtonText" textBinding="CANCEL_BUTTON@mntrBundle" destination="dataInboundSession" />
	</uix:case>
	<uix:default>
	  <uix:button styleClass="OraButtonText" textBinding="CANCEL_BUTTON@mntrBundle" destination="dataOutboundSession" />
	</uix:default>
	</uix:switcher>

 
	  <uix:navigationBar
          name="adminNav"
          blockSize="-1"
          formSubmitted="true"
	  formName="scheduleForm"
	  unvalidated="true"
          maxValue="4"
          minValue="1"
          value="3"/>
          <uix:submitButton styleClass="OraButtonText" 
                textBinding="REVIEW@notifBundle" 
                name="event" 
                value="finish"
		unvalidated="true"
		formName="scheduleForm"/> 
     
        </uix:pageButtonBar>
        </uix:stackLayout>
              </uix:contentFooter>
	
    
     </uix:pageLayout>
    </uix:form>
    
    <uix:spacer height="20" />
    
    </uix:body>
  </uix:document> 
</uix:renderingContext>
