<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="notifBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body >

      <uix:switcher childNameBinding="nodeValue@selectKeyValues@servletRequest">
        <uix:case name="okNode">

          <uix:form name="selectKeyValues" method="POST">
            <uix:pageLayout>

              <uix:contentFooter>
                <uix:pageButtonBar>
                   <uix:submitButton textBinding="CANCEL_BUTTON@commonBundle"
                                     name="event"
                                     value="cancelSelect" />
                   <uix:submitButton textBinding="SELECT@commonBundle"
                                     name="event"
                                     value="selectValues" />
                </uix:pageButtonBar>
              </uix:contentFooter>

              <uix:stackLayout>
                <uix:messageBox rendered="false"
                                renderedBinding="maxRowExceeded@selectKeyValues@servletRequest"
                                messageBinding="maxRowExceededMsg@selectKeyValues@servletRequest"
                                messageType="info" />

                <uix:header textBinding="pageHeader@selectKeyValues@servletRequest" >
                  <uix:spacer height="5"/>

                  <uix:stackLayout>

                      <uix:stackLayout>

                       <uix:tableLayout width="100%" >
                        <uix:rowLayout hAlign="right" >
                         <uix:cellFormat >
                          <uix:submitButton textBinding="CANCEL_BUTTON@commonBundle"
                                            name="event"
                                            value="cancelSelect" />
                          <uix:spacer width="10" />
                          <uix:submitButton textBinding="SELECT@commonBundle"
                                            name="event"
                                            value="selectValues" />
                         </uix:cellFormat >
                        </uix:rowLayout>
                       </uix:tableLayout>

                       <uix:header textBinding="SEARCH@commonBundle">
                         <uix:spacer height="5" />

                         <uix:tableLayout >
                          <uix:rowLayout >
                           <uix:labeledFieldLayout fieldWidth="95%" labelWidth="5%" >
                            <uix:contents childDataBinding="keyCols@searchFields@selectKeyValues@servletRequest" >

                             <uix:messageTextInput nameBinding="fieldName@"
                                                   shortDescBinding="fieldLabel@"
                                                   promptBinding="fieldLabel@"
                                                   columns="40"
                                                   textBinding="searchValue@"/>

                            </uix:contents>
                           </uix:labeledFieldLayout>
                          </uix:rowLayout >

                          <uix:rowLayout >
                           <uix:spacer height="5" />
                          </uix:rowLayout >

                          <uix:rowLayout hAlign="right" >
                            <uix:submitButton textBinding="GO@notifBundle"
                                              name="event" value="search"/>
                            <uix:formValue name="searchPage"/>

                          </uix:rowLayout>
                         </uix:tableLayout >

                       </uix:header>

                        <uix:header textBinding="RESULTS@commonBundle">

                        <uix:include nodeBinding="resultTable@selectKeyValues@servletRequest" />

                        <uix:spacer height="5" />

                      </uix:header>

                    </uix:stackLayout>

                  </uix:stackLayout>

                </uix:header>
              </uix:stackLayout>

            </uix:pageLayout>
          </uix:form>

        </uix:case>

        <uix:case name="errNode">
          <uix:messageBox messageBinding="errorMessage@selectKeyValues@servletRequest"
                          messageType="error"
                          shortDescBinding="ERR_OCCUR@mntrBundle"
                          textBinding="ERR_OCCUR@mntrBundle">
          </uix:messageBox>
        </uix:case>
      </uix:switcher>

    </uix:body>
  </uix:document>
</uix:renderingContext>

