<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
 * Copyright (c) 2004, 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *       singleTgtCmdBean.jsp 
 *
 *      NOTES
 *       The bean key supporting the view is 'singleTgtCmdBean'
 *       The controller is eml.cmd.tgt.SingleTargetCommandController
 *
 * MODIFIED
 *    kmckeen    12/04/06 - Backport kmckeen_bug-5665625 from main
 *    kmckeen    11/30/06 - Bug 5665625 - disable switch to multi-target mode
 *                          in db control
 *    kmckeen    05/07/05 - Bug 4332016 - Make host name be a link 
 *    kmckeen    05/07/05 - Ada fixes and UI review work
 *    kmckeen    01/13/05 - Remove Save and Change host buttons
 *    xshen      01/06/05 - add javascript to handle enter keystroke.
 *    xshen      01/05/05 - fixing abort: use get since netscape block 
 *                          subsequent post before 1st one completes 
 *    xshen      12/28/04 - xshen_refactor_nsh-1223
 *    xshen      12/28/04 - Created from original code. 
 *
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<jsp:useBean id="singleTgtCmdBean"
             scope="request"
             type="oracle.sysman.eml.cmd.tgt.SingleTargetCommandBean"/>
<script>
 function preLoad()
 {
   document.forms[0].newCommand.focus();
   document.forms[0].newCommand.select();

   var isNav = (navigator.appName.indexOf("Netscape") != -1);
   if(isNav)
   {
     document.captureEvents(Event.KEYPRESS);
     document.forms[0].newCommand.onkeypress = getNetscapeKey;
   } 
   
   //Scroller bottom aligned for command output area
   <%
     if(!singleTgtCmdBean.getIsFileOpen()) {
   %>
     document.forms[0].cmdOutput.scrollTop = document.forms[0].cmdOutput.scrollHeight;
   <%
     }
   %>
 }
 function getNetscapeKey(keyStroke)
 {
   key = keyStroke.which;
   if(key == "13")
   {
     submitForm('singleTgtCmdForm', 0, {'event':'execute'});
   }
 }            
 function doExecute(isFocus)
 {
   if(isFocus == "1")  
   { 
     if ((window.event.which == 13) ||  
         (window.event.keyCode == 13))
     {
       submitForm('singleTgtCmdForm', 0, {'event':'execute'});
     }
   }
 }
 function myCallBack(lovWindow, event)
 {
   return true;
 }
 function launchRfs()
 {
   var rfsPageUrl = document.forms[0].rfsPageUrl.value;
   if(rfsPageUrl != "")
   {
     openWindow(window, rfsPageUrl, 'lovWindow', {width:750, height:550}, true, 'dialog', myCallBack);
   }
 }
</script>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
 <uix:bundle name="singleTargetBundle" 
             class="oracle.sysman.eml.rsc.target.SingleTargetMsg"/>

 <uix:document>
  <%@ include file="/enablePPR.jspf" %>
 
  <uix:head titleBinding="pageTitle@singleTgtCmdBean@servletRequest"/>
  <uix:body onLoad="preLoad();">
   <uix:form name="singleTgtCmdForm" method="POST">
    <uix:contents>
     <uix:formValue name="command"    valueBinding="cmdShell@singleTgtCmdBean@servletRequest"/>
     <uix:formValue name="rfsPageUrl" valueBinding="rfsPageUrl@singleTgtCmdBean@servletRequest"/>
     <uix:formValue name="cmdChoice"  value="NEW"/>
    </uix:contents>
    <uix:pageLayout>
     <%@ include file="/oemGlobal.jspf" %>

     <uix:messageBox renderedBinding="rendered@msgBoxData@singleTgtCmdBean@servletRequest"
                     textBinding="text@msgBoxData@singleTgtCmdBean@servletRequest"
                     messageTypeBinding="messageType@msgBoxData@singleTgtCmdBean@servletRequest"
                     messageBinding="message@msgBoxData@singleTgtCmdBean@servletRequest">
      <uix:contents childDataBinding="linkList@msgBoxData@singleTgtCmdBean@servletRequest">
       <uix:link textBinding="text"
                 destinationBinding="destination"
                 longDescBinding="longDesc"/>
      </uix:contents>
     </uix:messageBox>

     <uix:switcher childNameBinding="showSingleTargetCommandPage@singleTgtCmdBean@servletRequest">
      <uix:case name="true">
       <uix:header 
            textBinding="EXECUTE_HOST_COMMAND@singleTargetBundle">
        <uix:contents>
        <uix:tableLayout width="100%">
         <uix:rowLayout width="100%">
         <uix:tableLayout hAlign="right">
         <uix:contents>
          <uix:rowLayout>
           <uix:cellFormat hAlign="right" wrappingDisabled="true">
             <uix:messagePrompt promptBinding="HOST@singleTargetBundle"/>
           </uix:cellFormat>
           <uix:spacer width="6"/>
           <uix:cellFormat hAlign="left" wrappingDisabled="true">
             <uix:link 
                  textBinding="hostName@singleTgtCmdBean@servletRequest"
                  destinationBinding="hostNameDest@singleTgtCmdBean@servletRequest"/>
           </uix:cellFormat>
          </uix:rowLayout>

          <%--
            Add a little vertical space. Otherwise, the underline below the
            host name touches the top of the credentials Change button.
          --%>
          <uix:rowLayout>
            <uix:spacer height="2"/>
          </uix:rowLayout>

          <uix:rowLayout>
           <uix:cellFormat hAlign="right" wrappingDisabled="true">
             <uix:messagePrompt 
                  promptBinding="CREDENTIALS@singleTargetBundle"/>
           </uix:cellFormat>
           <uix:spacer width="6"/>
           <uix:cellFormat hAlign="left" wrappingDisabled="true">
             <uix:styledText styleClass="OraInstructionTextStrong"
                  textBinding="loggedInAs@singleTgtCmdBean@servletRequest"/>
             <uix:spacer width="6"/>
             <uix:submitButton textBinding="CHANGE@singleTargetBundle"
                               unvalidated="true"
                               name="event"
                               value="switchUser"/>
           </uix:cellFormat>
          </uix:rowLayout>
         </uix:contents>  
        </uix:tableLayout>
        </uix:rowLayout>
       </uix:tableLayout>

        <%-- Command control with Execute and Abort buttons. --%>
        <uix:borderLayout>
          <uix:left>
            <uix:labeledFieldLayout labelWidth="15%" fieldWidth="0%">
              <uix:messageTextInput
                  id="newCommand"
                  name="newCommand"
                  columns="70"
                  onKeyPress="doExecute('1');"
                  promptBinding="COMMAND@singleTargetBundle"
                  textBinding="newCommand@singleTgtCmdBean@servletRequest"
                  tipBinding="ENTER_FULL_COMMAND@singleTargetBundle"/>
            </uix:labeledFieldLayout>
          </uix:left>
          <uix:spacer width="5"/>
          <uix:submitButton 
              textBinding="EXECUTE@singleTargetBundle"
              unvalidated="true"
              name="event"
              value="execute"/>
          <uix:spacer width="5"/>
          <uix:button 
              textBinding="ABORT@singleTargetBundle"
              destinationBinding="abortButtonDest@singleTgtCmdBean@servletRequest"/>
        </uix:borderLayout>

        <%--
          UI review feedback - add some extra vertical space between command
          control and output control.
        --%>
        <uix:spacer height="10"/>

        <%-- Output control, with Clear button. --%>
        <uix:borderLayout>
          <uix:left>
            <uix:labeledFieldLayout labelWidth="6%" fieldWidth="0%">
              <uix:messageTextInput 
                  id="cmdOutput"
                  name="cmdOutput"
                  columns="100"
                  rows="12"
                  styleClass="OraInlineText"
                  promptBinding="OUTPUT@singleTargetBundle"
                  textBinding="cmdOutput@singleTgtCmdBean@servletRequest"/>
              <uix:messagePrompt/>
              <uix:submitButton 
                  textBinding="CLEAR@singleTargetBundle"
                  unvalidated="true"
                  name="event"
                  value="clearCmdOutput"/>
            </uix:labeledFieldLayout>
          </uix:left>
        </uix:borderLayout>

        <uix:rowLayout>
          <uix:spacer height="4"/>
        </uix:rowLayout>

        <%-- Switch To Advanced Mode --%>
        <uix:tableLayout width="100%">
         <uix:rowLayout width="100%">
           <uix:link textBinding="SWITCH_TO_ADVANCED@singleTargetBundle"
             destinationBinding="switchToAdvDest@singleTgtCmdBean@servletRequest"
             renderedBinding="isEnterpriseMode@singleTgtCmdBean@servletRequest"/>
         </uix:rowLayout>
        </uix:tableLayout>

       </uix:contents>
       </uix:header>
      </uix:case>
     </uix:switcher>
    </uix:pageLayout>
   </uix:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>
