<%--
 * Copyright (c) 2003, 2006, Oracle. All rights reserved.  
 *
 * NAME
 *   cloneSummary.jsp
 *
 * NOTES
 *   result page of clone wizard.
 *
 * MODIFIED
 *    amani      08/11/06 - For bug fix 5446842
 *    hmodawel   03/02/06 - fixing jsp compilation
 *    kchiasso   08/21/03 - kchiasso_clonefromfile 
 *    kchiasso   08/16/2003 - Creation
--%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:dataScope>
  <uix:bundle name="CloneHomeResourceBundle"
              class="oracle.sysman.eml.ecm.cloneHome.util.CloneHomeResourceBundle"/>
  <uix:contents>
    <uix:switcher childNameBinding="status@cloneSummaryBean@servletRequest">
    <uix:case name="success">

      <uix:stackLayout>

      <uix:header
         textBinding="SUM_TBLHDR@CloneHomeResourceBundle">
      <uix:tableLayout>
      <uix:rowLayout width="40%">
        <uix:cellFormat hAlign="left" vAlign="top" >
          <uix:labeledFieldLayout labelWidth="0" fieldWidth="0">
            <uix:contents childDataBinding="sourceHostInfo@cloneSummaryBean@servletRequest">
              <uix:styledText styleClass="OraDataPrompt" 
                        textBinding="label"/>
              <uix:styledText styleClass="OraDataText" 
                        textBinding="text"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height="8"/>
      </uix:rowLayout>

      <uix:rowLayout width="100%">
    
                      <uix:table name="stageResultsTable"
                            id="summaryid"
                            partialRenderMode="self"
                            width="100%"
                            formSubmitted="true"
                            alternateTextBinding="SUM_TBLALT@CloneHomeResourceBundle"
                            columnHeaderDataBinding="columnHeaders@cloneSummaryBean@servletRequest"                  
                            blockSizeBinding="blockSize@servletRequest"
                            maxValueBinding="maxValue@servletRequest"
                            valueBinding="value@servletRequest"
                            minValue="1"
                            showAll="yes"
                            summaryBinding="SUMMARY_STAGERESULTSTABLE@CloneHomeResourceBundle"
                            tableDataBinding="rows@tableResultsData@cloneSummaryBean@servletRequest">
                          <uix:tableFormat tableBanding="rowBanding"/>

                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" 
                                                sortableBinding="sortable"/>
                          </uix:columnHeaderStamp>

                          <uix:contents>
                           <uix:styledText textBinding="hostName"/>
                           <uix:styledText textBinding="stageLoc"/>

                           <uix:dataScope rendered="true">
                            <uix:contents>
                              <uix:image sourceBinding="severityImage"/>
                              <uix:spacer width="3"/>
                              <uix:styledText textBinding="sevStatus"/>
                            </uix:contents>
                           </uix:dataScope>

                           <uix:image sourceBinding="telnetImage" destinationBinding="telnetDest"/>
                           </uix:contents>

                       </uix:table>

      </uix:rowLayout>
      </uix:tableLayout>
      </uix:header>

      </uix:stackLayout>

    </uix:case>

    <uix:case name="failure">
      <uix:messageBox messageBinding="errMsg@cloneSummaryBean@servletRequest"
                      messageType="error"
                      shortDescBinding="ERR_OCCUR@CloneHomeResourceBundle"
                      textBinding="errHdr@cloneSummaryBean@servletRequest">
      </uix:messageBox>
    </uix:case>
  </uix:switcher>


</uix:contents>
</uix:dataScope>
