<%--
  -- Page:        complianceChart.jsp
  -- Included in: complianceViewViolations.jsp
  -- Controller:  oracle.sysman.eml.ecm.compliance.ComplianceChartController
  --
  -- Description: Display for chart tab
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso      05/02/06 - set tab name
  --   kchiasso      04/14/06 - rmv summary
  --   niramach      03/29/06 - Include the trend overview charts and change contents 
  --                          - to non-el expression 
  --   kchiasso      01/30/06 - Creation
--%>       
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ page import="oracle.sysman.eml.ecm.compliance.ComplianceConstants"%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" class="oracle.sysman.eml.ecm.compliance.ComplianceMsg"/>
    <uix:bundle name="policyJspBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>
    <uix:page>
    <uix:dataScope currentDataBinding="complianceRuleDetailsTableData@servletRequest">

    <uix:document>
       <%@ include file="/oemTitle.jspf" %>
        <%@ include file="/enablePPR.jspf"%>
  	<uix:body>

    <uix:header textBinding="selectedNodeTitle@detailsPageData@complianceBrowserJspBean@servletRequest" id="pageHeader_id">
    <uix:contents>

    <uix:tableLayout width="100%">
    <uix:rowLayout>

      <uix:subTabLayout>
          <uix:subTabs>
              <uix:subTabBar selectedIndex="2">
              <uix:contents>
                   <uix:link textBinding="TAB_DETAILS@msgBundle"
                             name="summaryTab"
                             destinationBinding="detailsDest@detailsPageData@complianceBrowserJspBean@servletRequest" />                                                          
                   <uix:link textBinding="TAB_RULEDETAILS@msgBundle"
                             renderedBinding="renderRuleDetailsTab@detailsPageData@complianceBrowserJspBean@servletRequest" 
                             name="detailsRuleTab"
                             destinationBinding="ruleDetailsDest@detailsPageData@complianceBrowserJspBean@servletRequest" />                              
                   <uix:link textBinding="TAB_CHART@msgBundle"
                             name="chartTab"
                             destinationBinding="chartDest@detailsPageData@complianceBrowserJspBean@servletRequest" />                                                           
                 </uix:contents>
              </uix:subTabBar>
          </uix:subTabs>
          <uix:contents>
          
            <%-- Include the trend overview charts --%> 
            <%@ include file="complianceCharts.jspf" %> 
            
          </uix:contents>
        </uix:subTabLayout>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:contents>
  </uix:header>
  </uix:body> 
  </uix:document>
  </uix:dataScope>
</uix:page>
</uix:renderingContext>  

