<%--
  -- Page:        complianceConfirmation.jsp
  -- Controller:  oracle.sysman.eml.ecm.compliance.ComplianceConfirmationController
  --
  -- Description: Launched when user selects "delete" from complianceJobs page 
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    03/28/06 - Creation
--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" 
                class="oracle.sysman.eml.ecm.compliance.ComplianceMsg"/>
    <uix:document>
    <%@ include file="/oemTitle.jspf" %>
  
     <uix:body>
     <uix:form name="complianceConfirmation" method="GET" destination="/em/console/ecm/compliance/complianceConfirmation">

        <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>

            <uix:stackLayout>
              <uix:header iconBinding="confirmIcon@complianceConfirmationJspBean@servletRequest" 
                          textBinding="HDR_CONFIRMATION@msgBundle">

                <uix:contents>
                  <uix:rowLayout>
                    <uix:spacer width="10"/>
                    <uix:styledText textBinding="confirmMsg@complianceConfirmationJspBean@servletRequest" 
                                   styleClass="OraInstructionTextStrong"/>
                  </uix:rowLayout>
                  <uix:spacer height="10"/>
                  <uix:rowLayout>
                    <uix:spacer width="10"/>
                    <uix:styledText textBinding="confirmInstr@complianceConfirmationJspBean@servletRequest" styleClass="OraInstructionText"/>
                  </uix:rowLayout>
                </uix:contents>

              </uix:header>
            </uix:stackLayout>
          
          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="BTN_NO@msgBundle"
                                shortDescBinding="BTN_NO@msgBundle"
                                name="event" value="cancel"/>
              <uix:submitButton textBinding="BTN_YES@msgBundle" 
                                shortDescBinding="BTN_YES@msgBundle"
                                name="event" value="accept"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
            
            
        
        </uix:pageLayout>

     </uix:form>
     </uix:body>
    </uix:document>
</uix:renderingContext>
