<%--
  -- Page:        complianceDetailRight.jsp
  -- Frame in:    complianceDetailBrowser.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.ComplianceBrowserController
  --
  -- Description: Right frame for compliance browser - violations and details
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso     09/07/06 - add noscript tag
  --   sthiruna       07/14/06 - Tip for Evaluation Result Page
  --   aragarwa     07/06/06 - Fixing XSD changes.
  --   kchiasso      05/02/06 - rmv formvalue
  --   kchiasso      01/30/06 - Creation
--%>
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

<noScript>
  "This page uses JavaScript to render evaluation results details. Your browser either does not support JavaScript, or it is disabled.  Please enable JavaScript, or upgrade your browser."
</noScript>

<%--
<jsp:useBean id="complianceBrowserJspBean" scope="request"
    type="oracle.sysman.eml.ecm.compliance.ComplianceBrowserJspBean"/>
--%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>

<uix:page expressionLanguage="el">
    <uix:dataScope currentData="${request.complianceBrowserJspBean}">

    <uix:bundle name="msgBundle" class="oracle.sysman.eml.ecm.compliance.ComplianceMsg"/>
    <uix:bundle name="policyJspBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>

    <uix:document>
       <%@ include file="oemTitle_el.jspf" %>
       <%@ include file="../../enablePPR.jspf" %>

  	<uix:body>

    
    <uix:tableLayout id="pageMessage_id" borderWidth="0" width="100%" cellSpacing="0">
        <uix:rowLayout>
          <%@ include file="msgHeader_el.jspf" %>
        </uix:rowLayout>
    </uix:tableLayout>

    <uix:form name="nodeDetails" method="post"> 
    
    <uix:formValue id="selectedKey" name="selectedKey" value="${complianceBrowserJspBean.treeSelectedKey}" />
    <uix:formValue id="selectedTab" name="selectedTab"  value="${complianceBrowserJspBean.detailsPageData.selectedTabName}" />
    <uix:formValue name="command" />
    <uix:formValue name="event" />

    <uix:header text="${complianceBrowserJspBean.detailsPageData.selectedNodeTitle}" id="pageHeader_id">
    <uix:contents>
    
    <uix:switcher childName="${complianceBrowserJspBean.viewType}">
    
    <uix:case name="viewDetails">
       <%@ include file="complianceViewDetails.jspf" %>       
    </uix:case>

    <uix:case name="viewViolations"> 
       <%@ include file="complianceViewViolations.jspf" %>       
    </uix:case>
    </uix:switcher>

    </uix:contents>    
    </uix:header>                          
    </uix:form>
    
   </uix:body> 
  </uix:document>
 </uix:dataScope>
</uix:page>
</uix:renderingContext>    
