<%--
  -- Page:        complianceDetailTree.jsp
  -- Frame in:    complianceDetailLeft.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.ComplianceBrowserController
  --
  -- Description: Tree to display Config Standards
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso      09/07/06 - add noscript tag
  --   kchiasso      08/14/06 - rmv selectNode
  --   kchiasso      03/25/06 - set event rightPageRefresh
  --   kchiasso      03/21/06 - update javascript to load summary page
                                if other tab page is loaded
  --   kchiasso      01/30/06 - Creation
--%>
<%@ page contentType="text/html;charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<noScript>
  "This page uses JavaScript to render evaluation results details. Your browser either does not support JavaScript, or it is disabled.  Please enable JavaScript, or upgrade your browser."
</noScript>

<uix:page expressionLanguage="el">
  <uix:document>
  <uix:styleSheet />
  <uix:body>
  <uix:dataScope currentData="${request.complianceBrowserJspBean}">


  <uix:form name="treeForm" method="post" destination="${complianceBrowserJspBean.treePageUrl}">

  <uix:formValue name="command" />

  <uix:tree id                = "csTree_id"
            formSubmitted     = "true"
            formName          = "treeForm"
            nodes	      = "${defaultBean.managedObjectTreeNodeList}"
            proxy	      = "${defaultBean.treeDataProxy}" 
            partialRenderMode = "self"
            partialTargets    = "csTree_id" >

    <uix:nodeStamp>
      <uix:switcher childName="${uix.current.destination}">
        <uix:case name="null" >
          <uix:styledText text="${uix.current.text}" />
        </uix:case>
        <uix:default>
          <uix:flowLayout> 
            <uix:contents> 
              <uix:switcher childName="${uix.current.selected}">
                <uix:case name="true" >
                  <uix:link name="myAnchor" />
                </uix:case>
              </uix:switcher>
                <uix:link name="${uix.current.destinationText}" text="${uix.current.text}" destination="${uix.current.destination}" /> 
            </uix:contents> 
          </uix:flowLayout> 
        </uix:default>
      </uix:switcher>
    </uix:nodeStamp>
        	
  </uix:tree>


  </uix:form>
  
  </uix:dataScope>
  </uix:body>
  </uix:document> 
</uix:page>



<script language="Javascript">

function doTreeSelection(selected)
{
  // reload the frame we want to default when node from tree is selected 
  //
  // if the user pressed a tab other than the summary tab, and then presses
  // a link on the tree, we need to reload the right frame with the 
  // summary page details
  url = "complianceDetailRight?command=treeSelection&event=rightPageRefresh&selectedKey="+selected;
  parent.parent._right.document.location = url;
  
  // set the selected KEY -- need this so we know which node was selected
  parent.parent._right.document.nodeDetails.selectedKey.value=selected;
//  alert("selected "+selected);
  
  // this event and command will reload the data with the selected guid
  parent.parent._right.document.nodeDetails.command.value="treeSelection";
  parent.parent._right.document.nodeDetails.event.value="tabSelection";

  // this is to update the form in the right frame
  parent.parent._right.document.nodeDetails.submit();

}

</script>







