<%--
  -- Page:        complianceDetailiBrowser.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.ComplianceBrowserController
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso     09/07/06 - add noscript tag
  --   kchiasso      08/14/06 - fix jscript - 5442022
  --   sthiruna      07/04/06 - For 'Not Evaluated' status of a Rule
  --   kchiasso      04/18/06 - add filter by target
  --   kchiasso      04/17/06 - rmv instr; toggle show violations choice
  --   kchiasso      01/10/06 - toggle all and viol
  --   kchiasso      01/10/06 - handle dynamic resize
  --   kchiasso      01/10/06 - Creation
  --%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>


<noScript>
  "This page uses JavaScript to render evaluation results details. Your browser either does not support JavaScript, or it is disabled.  Please enable JavaScript, or upgrade your browser."
</noScript>

<script type="text/javascript">

if(!document.getElementById){

if(document.all)
document.getElementById=function(){
if(typeof document.all[arguments[0]]!="undefined")
return document.all[arguments[0]]
else
return null
}
}

function treeresize() {

if (document.getElementById)
{ 
  var treeobj = document.getElementById("treeframe");
  treeobj.style.display="block"
  var f=navigator.userAgent.substring(navigator.userAgent.indexOf("Firefox")).split("/")[1]
  var hadd=350;
  var ffmore=parseFloat(f)>=0.1? hadd : 0
  if (treeobj.contentDocument && treeobj.contentDocument.body.offsetHeight) 
        treeobj.height = treeobj.contentDocument.body.offsetHeight+hadd; 
  else if (treeobj.Document && treeobj.Document.body.scrollHeight)
        treeobj.height = treeobj.Document.body.scrollHeight+ffmore; 
}}

if (window.addEventListener)
window.addEventListener("load", treeresize, false)
else if (window.attachEvent)
window.attachEvent("onload", treeresize)
else
window.onload=treeresize

</script>
 
  
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.compliance.ComplianceConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
 
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    
    <uix:bundle name="bundle" class="oracle.sysman.eml.ecm.compliance.ComplianceMsg"/>

    <uix:document>

    <%@ include file="../../oemTitle.jspf" %>

  	<uix:body>
      <uix:pageLayout>
      <%@ include file="../../oemGlobal.jspf" %>    

      <uix:dataScope currentDataBinding="complianceBrowserJspBean@servletRequest">

    <uix:form name="detailiBrowser" 
              method="post">

      <uix:switcher childNameBinding="viewType@complianceBrowserJspBean@servletRequest">
     
      <uix:case name="viewDetails" >     
        <uix:tableLayout>
        <uix:header textBinding="titleViewStandard@complianceBrowserJspBean@servletRequest" id="pageheader_id" > 
          <uix:rowLayout width="100%">             
          <uix:cellFormat hAlign="right" vAlign="top">
          <uix:button  textBinding="BTN_RETURN@bundle" destinationBinding="destLibrary@complianceBrowserJspBean@servletRequest" />
          </uix:cellFormat> 
          </uix:rowLayout>
        </uix:header>        
        </uix:tableLayout>
      </uix:case>
     
      <uix:case name="viewViolations" >     
        <uix:header textBinding="titleViewViolations@complianceBrowserJspBean@servletRequest" id="pageheader_id" > 
        <uix:contents>                     
        <uix:tableLayout width="100%">      
          <uix:cellFormat width="15%">
          
          <uix:switcher childNameBinding="isCompliant@complianceBrowserJspBean@servletRequest">
          
          <uix:case name="false">
              <uix:rowLayout>
                 <uix:styledText
                      styleClass="OraPromptText"
                      labeledNodeId="showEvalSetting"
                      textBinding="LBL_VIEW@bundle"
                      />
                <uix:spacer width="5"/>
                <uix:choice 
                      id="showEvalSetting"
                      name="showEvalSetting" 
                      onChange="detailiBrowser.submit();"
                      selectedValueBinding="showEvalSetting@complianceBrowserJspBean@servletRequest">
                  <uix:option
                        textBinding="CHOICE_ALL_EVAL@bundle"
                        value="ALL"
                        />
                  <uix:option 
                       textBinding="CHOICE_VIOLATED_EVALS@bundle"
                       value="VIOLATED"
                        />
                </uix:choice>                           
              </uix:rowLayout> 
          </uix:case>
          
         <uix:case name="true">
              <uix:rowLayout>
                 <uix:styledText
                      styleClass="OraPromptText"
                      labeledNodeId="showEvalSetting"
                      textBinding="LBL_VIEW@bundle"
                      />
                <uix:spacer width="5"/>
                <uix:choice 
                      id="showEvalSetting"
                      name="showEvalSetting" 
                      selectedValueBinding="showEvalSetting@complianceBrowserJspBean@servletRequest">
                  <uix:option
                        textBinding="CHOICE_ALL_EVAL@bundle"
                        value="ALL"
                        />
                </uix:choice>                           
              </uix:rowLayout> 
          </uix:case>
          </uix:switcher>

          </uix:cellFormat>

          <uix:cellFormat width="60%">
          <uix:rowLayout>
            <uix:styledText styleClass="OraPromptText"
                                textBinding="LBL_TARGET@bundle"/>
              <uix:spacer height="10"/>
            <uix:styledText styleClass="OraDataText"
                           textBinding="filterTargetName@complianceBrowserJspBean@servletRequest"/>
              <uix:spacer height="10"/>
              
              <oem:targetSelection textBinding="BTN_SELECT@bundle" 
                                event="initTargetSelection" /> 
                                                               
              <uix:submitButton textBinding="BTN_CLEAR@bundle" 
                                shortDescBinding="BTN_CLEAR@bundle"
                                name="event" value="clearTarget"/>
            </uix:rowLayout>
          </uix:cellFormat>
 

          <uix:cellFormat width="25%" vAlign="top">
            <uix:rowLayout hAlign="right">
               <uix:button  textBinding="BTN_RETURN@bundle" destinationBinding="destResults@complianceBrowserJspBean@servletRequest" />        
            </uix:rowLayout>
          </uix:cellFormat> 
        </uix:tableLayout>
        </uix:contents>
        </uix:header>
        
        
      </uix:case>
    
    </uix:switcher>
   
    <%-- include iframe consisting of left and right frameset --%> 
    <uix:script text="document.write( \" <iframe src='complianceDetailiFrame' name='iframe' id='treeframe' style='width:100%;'></iframe> \" );">
    </uix:script> 

    </uix:form>
    </uix:dataScope>
    </uix:pageLayout>
  </uix:body>
  </uix:document>
</uix:renderingContext>


