<%--
  -- Page:        complianceErrors.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.ComplianceErrorsController
  --
  -- Description: Launched when user selects "search" action
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    04/14/06 - rmv search;
  --   spahuja     03/22/06 - Displays the errors page for compliance 
  --   kchiasso    03/15/06 - Creation
--%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.compliance.ComplianceConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" class="oracle.sysman.eml.ecm.compliance.ComplianceMsg"/>
    <uix:document>

    <%@ include file="../../oemTitle.jspf" %>
<%--    <%@ include file="/enablePPR.jspf"%>
--%>



	<uix:body>
	<uix:pageLayout titleBinding="PAGE_TITLE_COMPLIANCEERRORS@msgBundle">
	<%@ include file="msgHeader.jspf" %>

	<uix:dataScope currentDataBinding="complianceEvaluationErrorsJspBean@servletRequest">

	<uix:subTabLayout>
		<uix:subTabs>
			<uix:subTabBar selectedIndex="2">
				<uix:contents>
				<uix:link textBinding="TAB_EVALUATIONRESULTS@msgBundle"
					destinationBinding="<%= ComplianceConstants.S_TAB_RESULTS %>" />
				<uix:link textBinding="TAB_LIBRARY@msgBundle"
					destinationBinding="<%= ComplianceConstants.S_TAB_LIBRARY %>" />
				<uix:link textBinding="TAB_ERRORS@msgBundle"
					destinationBinding="<%= ComplianceConstants.S_TAB_ERRORS %>" />
				</uix:contents>
			</uix:subTabBar>
		</uix:subTabs>

		<uix:contents>
		<uix:form nameBinding="eml_ecm_sc_formName@servletRequest"  
				method="post">

		<uix:tableLayout width="100%">
			<uix:contents>
			<uix:cellFormat width="60%">
			<uix:rowLayout>
			<uix:styledText styleClass="OraInstructionText"
					textBinding="INSTR_COMPLIANCE_ERRORS@msgBundle"/>
			</uix:rowLayout>
			</uix:cellFormat>

			<uix:cellFormat width="40%" vAlign="top">
			<uix:rowLayout hAlign="right">
			<oem:pageRefreshed/>
			</uix:rowLayout>
			</uix:cellFormat>
			</uix:contents>
		</uix:tableLayout>

		<uix:stackLayout>
			<uix:spacer/>
		</uix:stackLayout>

<%--
		<uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
--%>		
		<uix:stackLayout>
			<uix:spacer height="10"/>
			<uix:table name="ComplianceEvaluationErrorsList"
					id = "ComplianceEvaluationErrorsList"
					partialRenderMode="self"
					showAll="yes"
					formSubmitted="true"
					width="100%"
					minValue="1" 
					tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
					valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
					maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
					blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
          alternateTextBinding="ALT_NOERRORS@msgBundle"
					summaryBinding="TBLSUM_RESULTSTABLE@msgBundle">
			<uix:tableFormat tableBanding="rowBanding"/>

			<%-- Config std column --%>
			<uix:column>
			<uix:columnHeader>
			<uix:sortableHeader textBinding="LBL_STANDARDNAME@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_STANDARDNAME %>"/>
			</uix:columnHeader>
			<uix:columnFormat columnDataFormat="textFormat"/>
			<uix:link textBinding="<%= ComplianceConstants.S_LBL_STANDARDNAME %>"
				destinationBinding="<%= ComplianceConstants.S_DEST_STANDARDNAME %>" />	
			</uix:column>


			<%-- Rule column --%>
                        <uix:column>
                        <uix:columnHeader>
                        <uix:sortableHeader textBinding="LBL_RULE@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_RULESERROR %>"/>
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
			<uix:styledText textBinding="<%= ComplianceConstants.S_LBL_RULE %>"/>
                        </uix:column>


	
			<%-- Target column --%>
                        <uix:column>
                        <uix:columnHeader>
                        <uix:sortableHeader textBinding="LBL_TARGETNAME@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_TARGET %>"/>
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= ComplianceConstants.S_LBL_TARGETNAME %>"
                                destinationBinding="<%= ComplianceConstants.S_DEST_TARGETNAME %>" />
                        </uix:column>


			
			<%-- Type column --%>
			<uix:column>
			<uix:columnHeader>
			<uix:sortableHeader textBinding="LBL_TARGETTYPE@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_TARGETTYPE %>"/>
			</uix:columnHeader>
			<uix:columnFormat columnDataFormat="textFormat"/>
			<uix:styledText textBinding="<%= ComplianceConstants.S_LBL_TARGETTYPE %>"/>
			</uix:column>


			<%-- Timestamp column --%>
			<uix:column>
			<uix:columnHeader>
			<uix:sortableHeader textBinding="LBL_TIMESTAMP@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_TIMESTAMP %>"/>	
			</uix:columnHeader>
			<uix:columnFormat columnDataFormat="dateFormat"/>
			<uix:styledText textBinding="<%= ComplianceConstants.S_LBL_TIMESTAMP %>"/>
			</uix:column>


			<%-- Error Type column --%>
			<uix:column>
			<uix:columnHeader>
			<uix:sortableHeader textBinding="LBL_ERRORTYPE@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_ERRORTYPE %>"/>
			</uix:columnHeader>
			<uix:columnFormat columnDataFormat="textFormat"/>
			<uix:styledText textBinding="<%= ComplianceConstants.S_LBL_ERRORTYPE %>"/>
			</uix:column>


			<%-- Message column --%>
			<uix:column>
			<uix:columnHeader>
			<uix:sortableHeader textBinding="LBL_MESSAGE@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_MESSAGE %>"/>
			</uix:columnHeader>
			<uix:columnFormat columnDataFormat="textFormat"/>
			<uix:styledText textBinding="<%= ComplianceConstants.S_LBL_MESSAGE %>" />
			</uix:column>

		</uix:table>
		</uix:stackLayout>

		</uix:form>
		</uix:contents>
  
  
         </uix:subTabLayout>
       </uix:dataScope>     
      </uix:pageLayout>

      </uix:body>
    </uix:document>
  </uix:renderingContext>
