<%--
  -- Page:        complianceJobs.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.ComplianceJobsController
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    05/16/06 - set title
  --   kchiasso    05/09/06 - rmv link
  --   kchiasso    04/17/06 - add instr and timestamp
  --   kchiasso    03/22/06 - add edit/delete selection
  --   hmodawel    03/06/06 - fix jsp compilation 
  --   kchiasso    02/20/06 - Creation
  --%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.compliance.ComplianceConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" class="oracle.sysman.eml.ecm.compliance.ComplianceMsg"/>
    <uix:document>

    <%@ include file="../../oemTitle.jspf" %>

  	<uix:body>
      <uix:pageLayout titleBinding="pageTitle@complianceJobsJspBean@servletRequest">
        <%@ include file="msgHeader.jspf" %>

        <uix:pageButtons>
               <uix:button textBinding="BTN_RETURN@msgBundle" 
                          destinationBinding="DEST_RETURNURL@complianceJobsJspBean@servletRequest"
                          shortDescBinding="BTN_RETURN@msgBundle"/>
                           
        </uix:pageButtons>

        <uix:pageStatus>
          <uix:labeledFieldLayout labelWidth="5%" columns="2" width="100%">
            <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETTYPE@msgBundle"
                    textBinding="LBL_TARGETTYPE@complianceJobsJspBean@servletRequest"/>
          </uix:labeledFieldLayout>
         </uix:pageStatus>

          <uix:tableLayout width="100%">            
            <uix:rowLayout>
              <uix:separator/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:spacer height="15"/>
            </uix:rowLayout>
          </uix:tableLayout>

               <uix:tableLayout width="100%">
                 <uix:contents>                     
                  <uix:cellFormat width="60%">
                   <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="INSTR_COMPLIANCE_JOBS@msgBundle"/>
                   </uix:rowLayout>
                  </uix:cellFormat>
                  <uix:cellFormat width="40%" vAlign="top">
                   <uix:rowLayout hAlign="right">
                    <oem:pageRefreshed/>
                   </uix:rowLayout>
                  </uix:cellFormat> 
                 </uix:contents>
                </uix:tableLayout>



         <uix:dataScope currentDataBinding="complianceJobsJspBean@servletRequest">
         
          <uix:form name="complianceJobs" method="post"> 
                                
              <uix:stackLayout>
                <uix:spacer height="10"/>
                <uix:table name="ComplianceJobsList" 
                           id = "ComplianceJobsList"
                           partialRenderMode="self"
                           showAll="yes"
                           formSubmitted="true" 
                           width="100%" 
                           minValue="1" 
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           alternateTextBinding="ALT_NOJOBS@msgBundle"
                           summaryBinding="TBLSUM_RESULTSTABLE@msgBundle">
                  <uix:tableFormat tableBanding="rowBanding"/>

                  <uix:tableSelection>
                    <uix:singleSelection selectedIndex="0">
			              <uix:contents>
                      <uix:submitButton textBinding="BTN_EDIT@msgBundle" 
                                        shortDescBinding="BTN_EDIT@msgBundle"
                                        name="event" value="doEditSchedule" />                          
                      <uix:submitButton textBinding="BTN_DELETE@msgBundle" 
                                        shortDescBinding="BTN_DELETE@msgBundle"
                                        name="event" value="doDeleteConfirm" />                          
                    </uix:contents>
                  </uix:singleSelection>
                  </uix:tableSelection>       

                  <uix:tableActions>    
                      <uix:submitButton textBinding="BTN_SCHEDULE@msgBundle" 
                                        shortDescBinding="BTN_SCHEDULE@msgBundle"
                                        name="event" value="doScheduleCompliance" />                          
                 </uix:tableActions>    
  
           
                  <%-- Job Name column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_JOBNAME@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_JOBNAME %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_JOBNAME %>"/>

<%-- for testing
                    <uix:link textBinding="<%= ComplianceConstants.S_LBL_JOBNAME %>"
                              destinationBinding="<%= ComplianceConstants.S_DEST_JOBNAME %>" />
--%>
                  </uix:column>

                 <%-- Owner column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_OWNER@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_OWNER %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_OWNER %>"/>
                 </uix:column>


                 <%-- Description column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_DESCRIPTION@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_DESCRIPTION %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_DESCRIPTION %>"/>
                 </uix:column>
      
                             
                 <%-- Scheduled column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_SCHEDULED@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_SCHEDULED %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="dateFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_SCHEDULED %>"/>
                  </uix:column>
  
                  <uix:formValue id="jobId" name="jobId" 
                                 valueBinding="<%= ComplianceConstants.S_HIDDEN_JOBID %>"/>

                  <uix:formValue id="execId" name="execId" 
                                 valueBinding="<%= ComplianceConstants.S_HIDDEN_EXECID %>"/>
 
 
                 </uix:table>
                 
              </uix:stackLayout>
 
          </uix:form>
           
       </uix:dataScope>     
      </uix:pageLayout>

      </uix:body>
    </uix:document>
  </uix:renderingContext>
  </body>
</html>
