<%--
  -- Page:        complianceLibrary.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.ComplianceLibraryController
  --
  -- Description: Launched when user selects "search" action
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    11/06/06 - add pa related link
  --   kchiasso    05/30/06 - align sched img
  --   kchiasso    05/16/06 - scheduled evals icon; rmv buttons
  --   kchiasso    04/14/06 - rmv search;
  --   kchiasso    03/22/06 - add edit/delete
  --   kchiasso    03/15/06 - add Errors tab
  --   kchiasso    01/04/06 - Creation
  --%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.compliance.ComplianceConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" class="oracle.sysman.eml.ecm.compliance.ComplianceMsg"/>
    <uix:bundle name="policymsgBundle"
    		class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>
    <uix:document>

    <%@ include file="../../oemTitle.jspf" %>

  	<uix:body>
      <uix:pageLayout titleBinding="PAGE_TITLE_COMPLIANCELIBRARY@msgBundle">
        <%@ include file="msgHeader.jspf" %>

        <uix:dataScope currentDataBinding="complianceLibraryJspBean@servletRequest">

         <uix:subTabLayout>
          <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
              <uix:contents>
                   <uix:link textBinding="TAB_EVALUATIONRESULTS@msgBundle"
                              destinationBinding="<%= ComplianceConstants.S_TAB_RESULTS %>" />
                   <uix:link textBinding="TAB_LIBRARY@msgBundle"
                              destinationBinding="<%= ComplianceConstants.S_TAB_LIBRARY %>" />
                   <uix:link textBinding="TAB_ERRORS@msgBundle"
                              destinationBinding="<%= ComplianceConstants.S_TAB_ERRORS %>" />
                  </uix:contents>
              </uix:subTabBar>
          </uix:subTabs>
          <uix:contents>

     
          <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" 
                    method="post"> 

                <uix:tableLayout width="100%">
                 <uix:contents>                     
                  <uix:cellFormat width="60%">
                   <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="INSTR_COMPLIANCE_LIBRARY@msgBundle"/>
                   </uix:rowLayout>
                  </uix:cellFormat>
                  <uix:cellFormat width="40%" vAlign="top">
                   <uix:rowLayout hAlign="right">
                    <oem:pageRefreshed/>
                   </uix:rowLayout>
                  </uix:cellFormat> 
                 </uix:contents>
                </uix:tableLayout>
<%--
              <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
--%>
                            
              <uix:stackLayout>
                <uix:spacer height="10"/>
                <uix:table name="ComplianceLibraryList" 
                           id = "ComplianceLibraryList"
                           partialRenderMode="self"
                           showAll="yes"
                           formSubmitted="true" 
                           width="100%" 
                           minValue="1" 
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           alternateTextBinding="ALT_NOSTANDARDS@msgBundle"
                           summaryBinding="TBLSUM_RESULTSTABLE@msgBundle">
                  <uix:tableFormat tableBanding="rowBanding"/>
               
                  <%-- CStandard column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_STANDARDNAME@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_STANDARDNAME %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:link textBinding="<%= ComplianceConstants.S_LBL_STANDARDNAME %>"
                              destinationBinding="<%= ComplianceConstants.S_DEST_STANDARDNAME %>" />
                  </uix:column>

                  <%-- Version column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_VERSION@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_VERSION %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_VERSION %>"/>
                  </uix:column>


                  <%-- Keywords column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_KEYWORDS@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_KEYWORDS %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_KEYWORDS %>"/>
                  </uix:column>
   
                  <%-- Author column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_AUTHOR@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_AUTHOR %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_AUTHOR %>"/>
                  </uix:column>                 
                            
                                                            
                  <%-- Target Type column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_TARGETTYPE@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_TARGETTYPE %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat width="10" cellNoWrapFormat="false" columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_TARGETTYPE %>"/>
                  </uix:column>
 
                  <%-- Description column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_DESCRIPTION@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_DESCRIPTION %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat width="10" cellNoWrapFormat="false" columnDataFormat="textFormat"/>
                    <uix:styledList>
                      <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_DESCRIPTION %>"/>
                      <uix:spacer width="3" />
                      <uix:image renderedBinding = "<%= ComplianceConstants.S_RENDER_HELPICON %>"
                               sourceBinding="<%= ComplianceConstants.S_IMG_INFORMATION %>" 
                               shortDescBinding="SHORTDESC_HELPICON@msgBundle"
                               destinationBinding="<%= ComplianceConstants.S_HELP_DESCRIPTION %>"/>
                  </uix:styledList>

                  </uix:column> 
                        
                  <%-- Scheduled Evals Icon --%>
                   <uix:column>
                    <uix:columnHeader>
                       <uix:styledText textBinding="BTN_SCHEDULEDEVALS@msgBundle" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                   
                   <uix:styledList listStyle="none">
                    <uix:styledItem > 
                         <uix:spacer height="1" width="23" />
                         <uix:image
                               sourceBinding="<%= ComplianceConstants.S_IMG_SCHEDULED %>" 
                               shortDescBinding="BTN_SCHEDULEDEVALS@msgBundle"
                               destinationBinding="<%= ComplianceConstants.S_DEST_SCHEDULED %>"/>
                        <uix:spacer height="15" />
                        <uix:styledText styleClass="OraInstructionText"  textBinding="<%= ComplianceConstants.S_LBL_JOBCOUNT %>"/>
                    </uix:styledItem>

                    </uix:styledList>
                    
                  </uix:column>                             
                  <uix:formValue id="standardGuid" name="standardGuid" 
                                 valueBinding="<%= ComplianceConstants.S_HIDDEN_STANDARDGUID %>"/>
  
                 </uix:table>
                 
              </uix:stackLayout>

	      
         <%------------------------
           -  Related Links
           ------------------------%>

          <uix:header 
            textBinding="RELATED_LINK@policymsgBundle">         

          <uix:tableLayout>

            <uix:rowLayout>
              <%---  Download Policy Groups  ---%>
              <uix:cellFormat hAlign="left">
                  <uix:link textBinding="LBL_DOWNLOADPOLICYGROUPS@msgBundle" 
                            destinationBinding="<%= ComplianceConstants.S_DEST_DOWNLOADGROUPS %>"/>
              </uix:cellFormat>
            </uix:rowLayout>     
            
          </uix:tableLayout> 
          
          </uix:header>         
		      
	      
            
          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

            </uix:pageButtonBar>
          </uix:pageButtons>
              

          </uix:form>

           </uix:contents>
          </uix:subTabLayout>
           
        </uix:dataScope>
      
      </uix:pageLayout>

      </uix:body>
    </uix:document>
  </uix:renderingContext>
  </body>
</html>
