<%--
  -- Page:        complianceResults.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.ComplianceResultsController
  --
  -- Description: Launched when user selects "search" action
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso     09/07/06 - add oac shortdesc
  --   niramach    04/21/06 - Add column for Delete icon .
  --   kchiasso    04/14/06 - rmv search;
  --   kchiasso    03/15/06 - add Errors tab
  --   kchiasso    02/20/06 - add cigar
  --   kchiasso    01/10/06 - Creation
  --%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.compliance.ComplianceConstants"%>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
  <uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" class="oracle.sysman.eml.ecm.compliance.ComplianceMsg"/>
    <uix:document>

    <%@ include file="../../oemTitle.jspf" %>

  	<uix:body>
      <uix:pageLayout titleBinding="PAGE_TITLE_COMPLIANCERESULTS@msgBundle">
        <%@ include file="msgHeader.jspf" %>

         <uix:dataScope currentDataBinding="complianceResultsJspBean@servletRequest">

         <uix:subTabLayout>
          <uix:subTabs>
              <uix:subTabBar selectedIndex="0">
              <uix:contents>
                   <uix:link textBinding="TAB_EVALUATIONRESULTS@msgBundle"
                              destinationBinding="<%= ComplianceConstants.S_TAB_RESULTS %>" />
                   <uix:link textBinding="TAB_LIBRARY@msgBundle"
                              destinationBinding="<%= ComplianceConstants.S_TAB_LIBRARY %>" />
                   <uix:link textBinding="TAB_ERRORS@msgBundle"
                              destinationBinding="<%= ComplianceConstants.S_TAB_ERRORS %>" />
                 </uix:contents>
              </uix:subTabBar>
          </uix:subTabs>
          <uix:contents>
     
          <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" 
                    method="post"> 
 
                <uix:tableLayout width="100%">
                 <uix:contents>                     
                  <uix:cellFormat width="60%">
                   <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="INSTR_COMPLIANCE_RESULTS@msgBundle"/>
                   </uix:rowLayout>
                  </uix:cellFormat>
                  <uix:cellFormat width="40%" vAlign="top">
                   <uix:rowLayout hAlign="right">
                    <oem:pageRefreshed/>
                   </uix:rowLayout>
                  </uix:cellFormat> 
                 </uix:contents>
                </uix:tableLayout>

<%-- 
              <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
--%>
                              
              <uix:stackLayout>
                <uix:spacer height="10"/>
                <uix:table name="ComplianceResultsList" 
                           id = "ComplianceResultsList"
                           partialRenderMode="self"
                           showAll="yes"
                           formSubmitted="true" 
                           width="100%" 
                           minValue="1" 
                           tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                           valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                           maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                           blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                           alternateTextBinding="ALT_NORESULTS@msgBundle"
                           summaryBinding="TBLSUM_RESULTSTABLE@msgBundle">
                  <uix:tableFormat tableBanding="rowBanding"/>

<%-- 
                  <uix:tableSelection>
                    <uix:singleSelection selectedIndex="0">
			              <uix:contents>
                      <uix:submitButton textBinding="BTN_DETAILS@msgBundle" 
                                        shortDescBinding="BTN_DETAILS@msgBundle"
                                        name="event" value="doViewResultDetails" />                          
                    </uix:contents>
                  </uix:singleSelection>
                  </uix:tableSelection>       
--%>               
                  <%-- CStandard column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_STANDARDNAME@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_STANDARDNAME %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:link textBinding="<%= ComplianceConstants.S_LBL_STANDARDNAME %>"
                              destinationBinding="<%= ComplianceConstants.S_DEST_STANDARDNAME %>" />
                  </uix:column>

                  <%-- Version column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_VERSION@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_VERSION %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_VERSION %>"/>
                  </uix:column>


                  <%-- Keywords column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_KEYWORDS@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_KEYWORDS %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_KEYWORDS %>"/>
                  </uix:column>
   
                  <%-- ComplianceScore column --%>
                  <uix:column> 
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_AVECOMPLIANCESCORE@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_SCORE %>" />
                    </uix:columnHeader> 
                    <uix:columnFormat width="140" columnDataFormat="numberFormat"/>
                    <uix:styledList>
                    <uix:rowLayout>
                       <uix:cellFormat width="90%" vAlign="left" wrappingDisabled="true">
                        <uix:image sourceBinding="cigarUsedImage@complianceResultsJspBean@servletRequest"
				shortDescBinding="SHORTDESC_CIGAR@msgBundle"
				widthBinding="cigarUsedWidth@complianceResultsJspBean@servletRequest"
                                height="15"/>
                        <uix:image sourceBinding="cigarNotUsedImage@complianceResultsJspBean@servletRequest"
 	                  	shortDescBinding="SHORTDESC_CIGAR@msgBundle"
                                widthBinding="cigarNotUsedWidth@complianceResultsJspBean@servletRequest"
                                height="15"/>
                      </uix:cellFormat >
                       <uix:cellFormat vAlign="right">
                         <uix:spacer width="15" />
                         <uix:styledText styleClass="OraInstructionText" textBinding="<%= ComplianceConstants.S_LBL_SCORE %>"/>
                      </uix:cellFormat>
                     </uix:rowLayout>
                    </uix:styledList>
                  </uix:column>


                 <%-- Targets column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_TARGETCOUNT@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_TARGETCOUNT %>" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="numberFormat"/>
                    <uix:link textBinding="<%= ComplianceConstants.S_LBL_TARGETCOUNT %>" />
                  </uix:column>

                  <%-- Target Type column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_TARGETTYPE@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_TARGETTYPE %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat width="10" cellNoWrapFormat="false" columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_TARGETTYPE %>"/>
                  </uix:column>

                 <%-- Description column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="LBL_DESCRIPTION@msgBundle" sortableBinding="<%= ComplianceConstants.S_SORT_DESCRIPTION %>"/>
                    </uix:columnHeader>
                    <uix:columnFormat width="10" cellNoWrapFormat="false" columnDataFormat="textFormat"/>
                    <uix:styledList>
                      <uix:styledText textBinding="<%= ComplianceConstants.S_LBL_DESCRIPTION %>"/>
                      <uix:spacer width="3" />
                      <uix:image renderedBinding = "<%= ComplianceConstants.S_RENDER_HELPICON %>"
                               sourceBinding="<%= ComplianceConstants.S_IMG_INFORMATION %>"
                               shortDescBinding="SHORTDESC_HELPICON@msgBundle"
                               destinationBinding="<%= ComplianceConstants.S_HELP_DESCRIPTION %>"/>
                  </uix:styledList>

                  </uix:column>
                  <%-- Delete Icon --%>
                   <uix:column>
                    <uix:columnHeader>
                       <uix:styledText textBinding="BTN_DELETE@msgBundle" />
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                      <uix:image
                               sourceBinding="<%= ComplianceConstants.S_DELETE_IMG %>"
                               shortDescBinding="BTN_DELETE@msgBundle"
                               destinationBinding="<%= ComplianceConstants.S_DELETE_DEST %>"/>
                  </uix:column>
                              
     
                  <uix:formValue id="standardGuid" name="standardGuid" 
                                 valueBinding="<%= ComplianceConstants.S_HIDDEN_STANDARDGUID %>"/>
  
                 </uix:table>
                 
              </uix:stackLayout>

              
          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>

            </uix:pageButtonBar>
          </uix:pageButtons>
              

          </uix:form>
           
           </uix:contents>
          </uix:subTabLayout>

       </uix:dataScope>     
      </uix:pageLayout>

      </uix:body>
    </uix:document>
  </uix:renderingContext>

