<%--
  -- Page:        complianceRuleDetailsTable.jsp
  -- Included in: complianceViewViolations.jsp
  -- Controller:  oracle.sysman.eml.ecm.jsp.ComplianceRuleDetailsController
  --
  -- Description: Display for details tab when rule is selected in tree
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso      07/19/06 - align
  --   kchiasso      05/30/06 - add rationale and recommendation
  --   kchiasso      05/02/06 - set tab name
  --   kchiasso      04/14/06 - rmv summary
  --   kchiasso      03/01/06 - Creation
--%>          
<!-- Details -->
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ page import="oracle.sysman.eml.ecm.compliance.ComplianceConstants"%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>

<uix:page expressionLanguage="el">

<uix:dataScope currentData="${request.complianceRuleDetailsTableData}">

    <uix:bundle name="msgBundle" class="oracle.sysman.eml.ecm.compliance.ComplianceMsg"/>
    <uix:bundle name="policyJspBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg"/>


    <uix:document>
       <%@ include file="oemTitle_el.jspf" %>
       <%@ include file="../../enablePPR.jspf" %>

  	<uix:body>

    <uix:header text="${complianceBrowserJspBean.detailsPageData.selectedNodeTitle}" id="pageHeader_id">
    <uix:contents>
 
    <uix:tableLayout width="100%">
    <uix:rowLayout vAlign="top">

      <uix:subTabLayout>
          <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
              <uix:contents>
                   <uix:link text="${msgBundle.TAB_DETAILS}"
                             name="summaryTab"
                             destination="${complianceBrowserJspBean.detailsPageData.detailsDest}" />
                   <uix:link text="${msgBundle.TAB_RULEDETAILS}"
                             rendered="${complianceBrowserJspBean.detailsPageData.renderRuleDetailsTab}"
                             name="detailsRuleTab"
                             destination="${complianceBrowserJspBean.detailsPageData.ruleDetailsDest}" />
                   <uix:link text="${msgBundle.TAB_CHART}"
                             name="chartTab"
                             destination="${complianceBrowserJspBean.detailsPageData.chartDest}"  />
                 </uix:contents>
              </uix:subTabBar>
          </uix:subTabs>
          <uix:contents>
 
  <uix:rowLayout vAlign="top" width="100%">
  <uix:contents> 

     <uix:cellFormat vAlign="top">
      <uix:contents>

        <uix:tableLayout >
       
            <%------------------------
             -  Rationale
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="120" vAlign="top" hAlign="right" wrappingDisabled="true">
                <uix:styledText styleClass="OraPromptText"
                           text="${msgBundle.LBL_RATIONALE}" />
              </uix:cellFormat>

              <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  text="${complianceBrowserJspBean.detailsPageData.rationale}"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="5" />
            </uix:rowLayout>
     
            <%------------------------
             -  Recommendation
             ------------------------%>
            <uix:rowLayout>
              <%---  Prompt  ---%>
              <uix:cellFormat width="120"  vAlign="top" hAlign="right" wrappingDisabled="true">
                <uix:styledText styleClass="OraPromptText"
                              text="${msgBundle.LBL_RECOMMENDATION}" />
              </uix:cellFormat>

             <%---  Field  ---%>
              <uix:spacer width="8"/>
              <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  text="${complianceBrowserJspBean.detailsPageData.recommendation}"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="5" />
            </uix:rowLayout>
 
            <%------------------------
             -  note
             ------------------------%>
            <uix:rowLayout
                  rendered="${complianceBrowserJspBean.detailsPageData.renderNoteIcon}">
              <%---  Prompt  ---%>
              <uix:cellFormat width="120" vAlign="top" hAlign="right" wrappingDisabled="true">
               <uix:image         
                  source="${complianceBrowserJspBean.detailsPageData.descrNoteImg}"
                  shortDesc="${msgBundle.SHORTDESC_NOTEICON}" />
             </uix:cellFormat>

              <%---  Field  ---%>
               <uix:spacer width="8"/>
               <uix:cellFormat>
                <uix:styledText
                  styleClass="OraDataText"
                  text="${complianceBrowserJspBean.detailsPageData.noteWarning}"/>
              </uix:cellFormat> 
          </uix:rowLayout>

        </uix:tableLayout>
    </uix:contents>
    </uix:cellFormat>

  </uix:contents>
  </uix:rowLayout>


   <%------------------------
    -  Violations Table
    ------------------------%>
    <uix:include node="${servletRequest.complianceRuleDetailsTableData.tableBean}"/>

              <%--uix:table 
                width="100%"
                blockSize="10"
                formSubmitted="true"
                tableData="${servletRequest.complianceRuleDetailsTableData.violationListData}"
                columnHeaderData="${servletRequest.complianceRuleDetailsTableData.violationListColHeaderData}"
                alternateText="{msgBundle.NO_RESULT_FOUND}"
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                </uix:columnHeaderStamp>  
                <uix:contents>
                </uix:contents>
              </uix:table--%>  

      
        </uix:contents>
      </uix:subTabLayout>
              
    </uix:rowLayout>
    </uix:tableLayout>

  </uix:contents>
  </uix:header>
            
   </uix:body> 
  </uix:document>

</uix:dataScope>
</uix:page>

</uix:renderingContext>  
