<%--
  -- Page:        complianceTrendCustomPeriod.jsp
  -- Controller:  oracle.sysman.eml.ecm.compliance.ComplianceTrendCustomPeriodController
  --
  --  MODIFIED    (MM/DD/YY)   
  --   kchiasso    07/22/05 - set btn sd
  --   niramach    05/30/05 - Fix for bug 4371882. 
  --   niramach    04/08/05 - Change the layout of UI components to be consistent
                            - with metric's custom period page.
  --   niramach    01/11/05 - niramach_policy_custom_capability
  --   niramach    12/28/04 - Custom support for trend overview pages
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.mntr.Constants" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>    
    <uix:bundle name="mntrResourceBundle" class="oracle.sysman.resources.MntrResourceBundle"/>
    <uix:bundle name="sdkUIBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
    <uix:bundle name="policyBundle" class="oracle.sysman.eml.ecm.policy.util.PolicyJspMsg" />
   
  <uix:document>       
    <%@ include file =" /oemTitle.jspf"  %> 
    
    <uix:body>         
    <uix:form name="customForm"
              method="POST">
    <uix:pageLayout>
      <uix:contents>
      
        <uix:switcher childNameBinding="dateInvalid@servletRequest">
          <uix:case name="true">
            <uix:messageBox messageBinding="errorMsg@servletRequest" messageType="info"/>            
          </uix:case>
        </uix:switcher>
      <uix:header textBinding="HDR_CUSTOM_PERIOD_SETUP@policyBundle" >        
      <uix:formValue name="isDateInvalid" valueBinding="dateInvalid@servletRequest"/>
      <uix:rowLayout hAlign = "right">
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@sdkUIBundle"
                              shortDescBinding = "CANCEL@sdkUIBundle"
                              name="event"
                              value="cancel"/>
            <uix:submitButton textBinding="OK@sdkUIBundle"
                              shortDescBinding = "OK@sdkUIBundle"
                              name="event"
                              value="ok"/>
          </uix:pageButtonBar>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:spacer width ="20"/>
        <uix:styledText styleClass="OraPromptText"
                        textBinding="collectedDataLabel@complianceCustomPeriodJspBean@servletRequest"/>
        <uix:spacer width ="12"/>                
        <uix:styledText styleClass="OraDataText"
                        textBinding="collectedDateMinMax@complianceCustomPeriodJspBean@servletRequest"/>
      </uix:rowLayout>      
      <uix:spacer height ="20"/>
      <uix:tableLayout cellSpacing="20">
            <uix:rowLayout>                
                <uix:messageDateField
                               promptBinding="START_DATE@sdkUIBundle"
                               name="startDate"
                               id="startDate"                               
                               tipBinding="dateTip@complianceCustomPeriodJspBean@servletRequest"                               
                               anchor="myAnchor"
                               shortDescBinding="START_DATE@sdkUIBundle"
                               columns="24"
                               required="yes"
                               valueBinding="startDate@complianceCustomPeriodJspBean@servletRequest">
                        <uix:onSubmitValidater>
                            <uix:date dateStyle="short"/>
                        </uix:onSubmitValidater>
                </uix:messageDateField>             
                <uix:spacer width="12"/>
                <uix:messageDateField
                               promptBinding="END_DATE@sdkUIBundle"
                               name="endDate"
                               id="endDate"                               
                               tipBinding="dateTip@complianceCustomPeriodJspBean@servletRequest"
                               anchor="myAnchor"
                               shortDescBinding="END_DATE@sdkUIBundle"
                               columns="24"
                               required="yes"
                               valueBinding="endDate@complianceCustomPeriodJspBean@servletRequest">
                        <uix:onSubmitValidater>
                            <uix:date dateStyle="short"/>
                        </uix:onSubmitValidater>
                </uix:messageDateField>
                </uix:rowLayout>
                <uix:rowLayout>
                <uix:cellFormat>
                    <uix:rowLayout>
                    <uix:messageChoice promptBinding="START_HOUR@sdkUIBundle"
                                   styleClass="OraPromptText"
                                   name="startHour"
                                   id="startHour"
                                   required ="yes"
                                   shortDescBinding="HOURS@sdkUIBundle"
                                   selectedValueBinding="startHour@complianceCustomPeriodJspBean@servletRequest">
                        <uix:option text="1" value="1"/>
                        <uix:option text="2" value="2"/>
                        <uix:option text="3" value="3"/>
                        <uix:option text="4" value="4"/>
                        <uix:option text="5" value="5"/>
                        <uix:option text="6" value="6"/>
                        <uix:option text="7" value="7"/>
                        <uix:option text="8" value="8"/>
                        <uix:option text="9" value="9"/>
                        <uix:option text="10" value="10"/>
                        <uix:option text="11" value="11"/>
                        <uix:option text="12" value="12"/>
                    </uix:messageChoice>
                    
                    <uix:spacer width="5"/>
                    <uix:radioButton name="startTime"
                                 textBinding="AM_LABEL@sdkUIBundle"
                                 shortDescBinding="AM_LABEL@sdkUIBundle"
                                 selectedValueBinding = "startTime@complianceCustomPeriodJspBean@servletRequest"
                                 value="<%= Constants.AM_KEY %>" >
                    </uix:radioButton>
                    <uix:radioButton name="startTime"
                                 textBinding="PM_LABEL@sdkUIBundle"
                                 shortDescBinding="PM_LABEL@sdkUIBundle"
                                 selectedValueBinding = "startTime@complianceCustomPeriodJspBean@servletRequest"
                                 value="<%= Constants.PM_KEY %>" >
                    </uix:radioButton>
                </uix:rowLayout>
            </uix:cellFormat>
            <uix:cellFormat>
                <uix:spacer width="5"/>
            </uix:cellFormat>
            <uix:cellFormat>
            <uix:rowLayout>     
                    <uix:messageChoice promptBinding="END_HOUR@sdkUIBundle"
                                   styleClass="OraPromptText"
                                   name="endHour"
                                   id="endHour"
                                   required ="yes"
                                   shortDescBinding="HOURS@sdkUIBundle"
                                   selectedValueBinding="endHour@complianceCustomPeriodJspBean@servletRequest">
                        <uix:option text="1" value="1"/>
                        <uix:option text="2" value="2"/>
                        <uix:option text="3" value="3"/>
                        <uix:option text="4" value="4"/>
                        <uix:option text="5" value="5"/>
                        <uix:option text="6" value="6"/>
                        <uix:option text="7" value="7"/>
                        <uix:option text="8" value="8"/>
                        <uix:option text="9" value="9"/>
                        <uix:option text="10" value="10"/>
                        <uix:option text="11" value="11"/>
                        <uix:option text="12" value="12"/>
                    </uix:messageChoice>

                    <uix:spacer width="5"/>
                    <uix:radioButton name="endTime"
                                 textBinding="AM_LABEL@sdkUIBundle"
                                 shortDescBinding="AM_LABEL@sdkUIBundle"
                                 selectedValueBinding = "endTime@complianceCustomPeriodJspBean@servletRequest"
                                 value="<%= Constants.AM_KEY %>" >
                    </uix:radioButton>
                    <uix:radioButton name="endTime"
                                 textBinding="PM_LABEL@sdkUIBundle"
                                 shortDescBinding="PM_LABEL@sdkUIBundle"
                                 selectedValueBinding = "endTime@complianceCustomPeriodJspBean@servletRequest"
                                 value="<%= Constants.PM_KEY %>" >
                    </uix:radioButton>
                </uix:rowLayout>
            </uix:cellFormat>
        </uix:rowLayout>
     </uix:tableLayout>
    </uix:header>
    </uix:contents>
    <uix:contentFooter>
        <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@sdkUIBundle"
                            shortDescBinding="CANCEL@sdkUIBundle"
                            name="event"
                            value="cancel"/>
          <uix:submitButton textBinding="OK@sdkUIBundle"
                            shortDescBinding="OK@sdkUIBundle"
                            name="event"
                            value="ok"/>
        </uix:pageButtonBar>
    </uix:contentFooter>
    </uix:pageLayout>
    </uix:form>  
    </uix:body>
  </uix:document>  
</uix:renderingContext>

