<%--
  -- Copyright (c) 2004, 2005, 2006 Oracle. All rights reserved.  
  -- Page:        scheduleComplianceJob.jsp
  -- Controller:  oracle.sysman.eml.ecm.compliance.ScheduleComplianceController
  --
  -- Description: Launched when user selects Schedule Job
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    03/22/06 - add edit/delete
  --   kchiasso    01/03/06 - Creation
--%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>

  <%-- Imports --%>
  <%@ page import="oracle.sysman.eml.ecm.compliance.ComplianceConstants" %>
  <%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

  <uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="complianceBundle"
    class="oracle.sysman.eml.ecm.compliance.ComplianceMsg" />

  <uix:document>

    <%@ include file="../../oemTitle.jspf" %>
    
    <uix:body>

    <uix:dataScope currentDataBinding="scheduleComplianceJspBean@servletRequest"> 

    <uix:form name="scheduleComplianceJob" 
              method="post">
  
        <uix:formValue 
          name="pageName" 
          value="/ecm/compliance/scheduleComplianceJob"/>
          
        <uix:pageLayout
          titleBinding="title@scheduleComplianceJspBean@servletRequest"> 
 
         <%@ include file="msgHeader.jspf" %>
 
         <uix:pageButtons>
            <uix:pageButtonBar>
                <uix:submitButton name ="event" formName="scheduleComplianceJob" 
                  textBinding="BTN_CANCEL@complianceBundle"
                  shortDescBinding="BTN_CANCEL@complianceBundle"
                  value="cancel"/>
                <uix:submitButton name ="event" formName="scheduleComplianceJob" 
                  renderedBinding="renderOK@scheduleComplianceJspBean@servletRequest"
                  textBinding="BTN_OK@complianceBundle"
                  shortDescBinding="BTN_OK@complianceBundle"
                  value="scheduleJob"/>
                <uix:submitButton  name ="event" formName="scheduleComplianceJob" 
                  renderedBinding="renderEdit@scheduleComplianceJspBean@servletRequest"
                  textBinding="BTN_EDIT@complianceBundle"
                  shortDescBinding="BTN_EDIT@complianceBundle"
                  value="scheduleJob"/>
             </uix:pageButtonBar>
          </uix:pageButtons>


  <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat vAlign="top">
      <uix:contents>
     
      <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0">
        <%-- JobName field --%>
        <uix:messageTextInput readOnlyBinding="renderEdit@scheduleComplianceJspBean@servletRequest"
                              name="jobName" 
                              required="uiOnly" 
                              contentStyleClass="OraDataText"     
                              promptBinding="LBL_JOBNAME@complianceBundle" 
                              textBinding="jobName@scheduleComplianceJspBean@servletRequest" 
                              columns="50"
                              maximumLength="64"
                              messageTypeBinding="nameMsgType@errors@servletRequest" 
                              messageBinding="nameInlineMsg@errors@servletRequest"/> 
        <uix:spacer width="2"/>
 
         <%-- TargetType field --%>
        <uix:messageStyledText
                    contentStyleClass="OraDataText"
                    promptBinding="LBL_TARGETTYPE@complianceBundle"
                    textBinding="displayTargetType@scheduleComplianceJspBean@servletRequest"/>
                    
        <uix:spacer width="10"/>
  

      </uix:labeledFieldLayout>
      
      <uix:rowLayout>
      

   <%------------------------  
  <%@ include target picker table%>
    ------------------------%>       
   <%@ include file="scheduleAddTargets.jspf" %>
 
      </uix:rowLayout>
        
      </uix:contents>
      </uix:cellFormat>
        
      <uix:cellFormat vAlign="top" width="50%">
      <uix:contents>

      <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0">

        <%-- Description field --%>
        <uix:messageTextInput name="description" 
                              rows = "4"
                              maximumLength = "256"
                              promptBinding="LBL_DESC@complianceBundle" 
                              textBinding="desc@scheduleComplianceJspBean@servletRequest" 
                              columns="50"/>

      </uix:labeledFieldLayout>
              
      <uix:rowLayout>
 
  <%------------------------  
  <%@ include page segment for schedule UI %>
  
          //add page segments to Schedule page  
          phm.addPageSegment("ecm/compliance/scheduleComplianceJob", 
                               SDKPageSegmentTypes.SCHEDULE_SEGMENT);   
          //SDK pagesegment handler
          phm.setPageSegmentHandler(SDKPageSegmentTypes.SCHEDULE_SEGMENT, 
                new oracle.sysman.eml.sch.ScheduleSegmentHandler());
  
    ------------------------%>       
  <uix:stackLayout>
    <uix:header textBinding="HDR_SCHEDULE@complianceBundle">
        <uix:contents>
        
        <uix:spacer height="5"/>       
        <uix:ref refID="SCHEDULE_SEGMENT"/>
                   
        </uix:contents>        
    </uix:header>
  </uix:stackLayout>

     
      </uix:rowLayout>
      
      </uix:contents>
      </uix:cellFormat>
                                     
    </uix:rowLayout>
  </uix:tableLayout>
  

  </uix:pageLayout>
      
  </uix:form>
  
  </uix:dataScope>
  
    </uix:body>
  
  </uix:document> 
</uix:renderingContext>