<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="cmpWizMsg" class="oracle.sysman.resources.eml.ecm.track.CompareConfigWizMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:metaContainer>
      <uix:head titleBinding="TITLE_COMPARE_FIRST_CONFIG@cmpWizMsg"/>
    </uix:metaContainer>
    <uix:body>
      <uix:form name="compareWizFirstConfigForm" method="get">
        <uix:formValue name="pageName" value="/ecm/config/compare/compareWizFirstConfig"/>
        <uix:pageLayout titleBinding="COMPARE_FIRST_CONFIG_HDR@cmpWizMsg">
          <%@ include file="/oemGlobal.jspf"%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkMsg" formNameBinding="compareWizFirstConfigForm" name="event" value="cancel"/>
              <uix:submitButton textBinding="CONTINUE@sdkMsg" formNameBinding="compareWizFirstConfigForm" name="event" value="continue"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
          <oem:messageBox messageTypeBinding="errorType@servletRequest" titleTextKey="titleText" mainTextKey="mainText" errorTableBinding="errors@servletRequest"/>
          <uix:stackLayout>
            <uix:contents>
              <uix:tableLayout cellSpacing="5" width="100%">
                <%--- First Config Help Text ---%>
                <uix:rowLayout>
                <uix:contents>
                    <uix:styledText styleClass="OraInstructionText"
                        textBinding="FIRST_CONFIG_PAGE_INFO@cmpWizMsg"/>
                </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                <uix:contents>
                    <uix:spacer height="10"/>
                </uix:contents>
                </uix:rowLayout>
                
                <uix:rowLayout>
                <uix:contents>
                    <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                <uix:contents>
                    <uix:spacer height="10"/>
                </uix:contents>
                </uix:rowLayout>

                <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:switcher childNameBinding="searchType@compareWizFirstConfigBean@servletRequest">
                    <uix:case name="latest">
                                        <%@ include file="../latestConfigTable.jspf" %>
                    </uix:case>
                    <uix:case name="saved">
                                        <%@ include file="../savedConfigTable.jspf" %>
                    </uix:case>
                    </uix:switcher>
                </uix:cellFormat>
                </uix:rowLayout>
                </uix:tableLayout>
            </uix:contents>
          </uix:stackLayout>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
