<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">  <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="sdkMsg"
        class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="cmpWizMsg"
        class="oracle.sysman.resources.eml.ecm.track.CompareConfigWizMsg"/>
    <uix:bundle name="savedConfigMsg"
        class="oracle.sysman.resources.eml.ecm.track.SavedConfigMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <uix:head
          titleBinding="TITLE_COMPARE_SECOND_CONFIG@cmpWizMsg"/>
    </uix:metaContainer>
      <uix:body>
      <uix:form name="compareWizSecondConfigForm" method="get" >
        <uix:formValue name="pageName" value="/ecm/config/compare/compareWizSecondConfig"/>
          <uix:pageLayout titleBinding="COMPARE_SECOND_CONFIG_HDR@cmpWizMsg">
            <%@ include file="/oemGlobal.jspf" %>
            <uix:pageButtons>
              <uix:pageButtonBar>
              <uix:submitButton
                  textBinding="CANCEL@sdkMsg"
                  formNameBinding="compareWizSecondConfigForm"
                  name="event"
                  value="cancel"/>
              <uix:submitButton
                  textBinding="BACK@sdkMsg"
                  formNameBinding="compareWizSecondConfigForm"
                  name="event"
                  value="back"/>
              <uix:submitButton
                  textBinding="BTN_COMPARE_CONFIG@savedConfigMsg"
                  formNameBinding="compareWizSecondConfigForm"
                  name="event"
                  value="compare"/>
              </uix:pageButtonBar>
            </uix:pageButtons>


          <oem:messageBox messageTypeBinding="errorType@servletRequest"
              titleTextKey="titleText"
              mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>

                <uix:stackLayout>
                <uix:contents>

                <uix:tableLayout cellSpacing="5" width="100%">

                    <uix:rowLayout renderedBinding="firstConfigInfoAvailable@defaultBean@servletRequest">
                    <uix:cellFormat hAlign="left">
                        <uix:contents>
                        <uix:tableLayout cellSpacing="5">
                                <uix:contents>
                                <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraPromptText"
                                        textBinding="CTX_FIRST_CONFIG_TARGET_LBL@cmpWizMsg"/>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraDataText"
                                        textBinding="firstConfigDisplayTargetText@defaultBean@servletRequest"/>
                                </uix:cellFormat>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraPromptText"
                                        textBinding="CTX_FIRST_CONFIG_TARGET_COLLECTED_LBL@cmpWizMsg"/>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraDataText"
                                        textBinding="firstConfigCollectedTime@defaultBean@servletRequest"/>
                                </uix:cellFormat>
                                </uix:rowLayout>

                                </uix:contents>
                            </uix:tableLayout>
                        </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat/>
                    </uix:rowLayout>

                        <uix:spacer height="10"/>
                        <uix:separator></uix:separator>
                    <%--- First Config Help Text ---%>
                    <uix:rowLayout>
                    <uix:contents>
                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="SECOND_CONFIG_PAGE_INFO@cmpWizMsg"/>
                    </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout>
                    <uix:contents>
                        <uix:spacer height="10"/>
                    </uix:contents>
                    </uix:rowLayout>

                    <uix:rowLayout>
                    <uix:contents>
                        <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                    </uix:contents>
                    </uix:rowLayout>

                      <uix:spacer height="10"/>
                    <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                        <uix:switcher childNameBinding="searchType@compareWizSecondConfigBean@servletRequest">
                        <uix:case name="latest">
                                            <%@ include file="../latestConfigTable.jspf" %>
                        </uix:case>
                        <uix:case name="saved">
                                            <%@ include file="../savedConfigTable.jspf" %>
                        </uix:case>
                        </uix:switcher>
                    </uix:cellFormat>
                    </uix:rowLayout>
<%-- Display Sql for debugging purpose --%>
<%--
                    <uix:rowLayout>
                    <uix:cellFormat >
                            <uix:header text="SQL_STATEMENT">
                                <uix:tableLayout width="100%">
                                    <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="sqlStatement@compareWizSecondConfigBean@servletRequest"/>
                                </uix:tableLayout>
                            </uix:header>
                    </uix:cellFormat>
                    </uix:rowLayout>
--%>
                </uix:tableLayout>


                </uix:contents>
                </uix:stackLayout>

          </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:document>
</uix:renderingContext>

