<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">  <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="sdkMsg"
        class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
    <uix:bundle name="cmpWizMsg"
        class="oracle.sysman.resources.eml.ecm.track.CompareConfigWizMsg"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <uix:head
          titleBinding="TITLE_ADDMORE_CONFIGS@cmpWizMsg"/>
    </uix:metaContainer>
      <uix:body>
      <uix:form name="compareWizAddMoreConfigsForm" method="get">
        <uix:formValue name="pageName" value="/ecm/config/compare/compareWizAddMoreConfigs"/>
          <uix:pageLayout titleBinding="ADDMORE_CONFIGS_HDR@cmpWizMsg">
            <%@ include file="/oemGlobal.jspf" %>
            <uix:pageButtons>
              <uix:pageButtonBar>
              <uix:submitButton
                  textBinding="CANCEL@sdkMsg"
                  formNameBinding="compareWizAddMoreConfigsForm"
                  name="event"
                  value="cancel"/>
              <uix:submitButton
                  textBinding="OK@sdkMsg"
                  formNameBinding="compareWizAddMoreConfigsForm"
                  name="event"
                  value="ok"/>
              </uix:pageButtonBar>
            </uix:pageButtons>


          <oem:messageBox messageType="error"
              titleTextKey="titleText"
              mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>

                <uix:stackLayout>
                <uix:contents>

                <uix:tableLayout cellSpacing="5" width="100%">

                    <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                        <uix:contents>
                        <uix:tableLayout cellSpacing="5">
                                <uix:contents>
                                <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraPromptText"
                                        textBinding="CTX_FIRST_CONFIG_TARGET_LBL@cmpWizMsg"/>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraDataText"
                                        textBinding="firstConfigDisplayTargetText@defaultBean@servletRequest"/>
                                </uix:cellFormat>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraPromptText"
                                        textBinding="CTX_FIRST_CONFIG_TARGET_COLLECTED_LBL@cmpWizMsg"/>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraDataText"
                                        textBinding="firstConfigCollectedTime@defaultBean@servletRequest"/>
                                </uix:cellFormat>
                                </uix:rowLayout>

                                </uix:contents>
                            </uix:tableLayout>
                        </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat/>
                    </uix:rowLayout>

                        <uix:separator><uix:spacer height="5"/></uix:separator>
                    <%--- First Config Help Text ---%>
                    <uix:rowLayout>
                    <uix:contents>
                        <uix:styledText styleClass="OraInstructionText"
                            textBinding="ADDMORE_CONFIGS_PAGE_INFO@cmpWizMsg"/>
                    </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout>
                    <uix:contents>
                            <uix:spacer height="10"/>
                    </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout>
                    <uix:contents>
                        <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                    </uix:contents>
                    </uix:rowLayout>
                
                    <uix:spacer height="10"/>
                
                    <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                        <uix:switcher childNameBinding="searchType@compareWizAddMoreConfigsBean@servletRequest">
                        <uix:case name="latest">
                            <oem:table name="latestConfigResult" 
                                blockSizeBinding="blockSize@defaultBean@servletRequest" width="98%"
                                dataSourceProp="latestConfigResultUI"
                                formSubmitted="true"
                                alternateTextBinding="MSG_NO_ITEMS_FOUND@cmpWizMsg"
                                showAll="yes">
                                <uix:tableSelection>
                                <uix:multipleSelection selectedBinding="selected"
                                    selectionBinding="selectionOldLatest@defaultBean@servletRequest"
                                    shortDescBinding="MSG_SELECT_ROW@cmpWizMsg">
                                </uix:multipleSelection>
                                </uix:tableSelection>
                            
                            </oem:table>
                        </uix:case>
                        <uix:case name="saved">
                            <oem:table name="savedConfigResult" 
                                blockSizeBinding="blockSize@defaultBean@servletRequest"
                                width="98%"
                                dataSourceProp="savedConfigResultUI"
                                formSubmitted="true"
                                alternateTextBinding="MSG_NO_ITEMS_FOUND@cmpWizMsg"
                                showAll="yes">
                                <uix:tableSelection>
                                <uix:multipleSelection selectedBinding="selected"
                                    selectionBinding="selectionOldSaved@defaultBean@servletRequest"
                                    shortDescBinding="MSG_SELECT_ROW@cmpWizMsg">
                                </uix:multipleSelection>
                                </uix:tableSelection>
                            
                            </oem:table>
                        </uix:case>
                        </uix:switcher>
                    </uix:cellFormat>
                    </uix:rowLayout>


                </uix:tableLayout>


                </uix:contents>
                </uix:stackLayout>

          </uix:pageLayout>
        </uix:form>
      </uix:body>
    </uix:document>
</uix:renderingContext>

