<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree
    nodeID="pageContent"
    scope="request" >
  <uix:dataScope currentDataBinding="pageData@servletRequest">
    <uix:bundle name="cmpWizMsg"
        class="oracle.sysman.resources.eml.ecm.track.CompareConfigWizMsg"/>
    <uix:stackLayout>
    <uix:contents>

      <uix:tableLayout cellSpacing="5" width="100%">
  
        <%--- First Config Help Text ---%>
        <uix:rowLayout>
          <uix:contents>
            <uix:styledText styleClass="OraInstructionText"
                textBinding="FIRST_CONFIG_PAGE_INFO@cmpWizMsg"/>
          </uix:contents>
        </uix:rowLayout>

        <uix:rowLayout>
        <uix:contents>
            <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
        </uix:contents>
        </uix:rowLayout>

  
        <uix:spacer height="10"/>
        <uix:rowLayout>
          <uix:cellFormat hAlign="left">
            <uix:switcher childNameBinding="searchType@firstConfigBean@servletRequest">
            <uix:case name="latest">
              <%--- Configurations result Table ---%>

                  <oem:table name="latestConfigResult" blockSizeBinding="blockSize@pageData@servletRequest" width="100%"
                      dataSourceProp="latestConfigResultUI"
                      alternateTextBinding="MSG_NO_ITEMS_FOUND@cmpWizMsg"
                      summaryBinding="SUMMARY_SELECTCONFIGITEM@cmpWizMsg"
                      showAll="yes">
                    <uix:tableSelection>
                      <uix:singleSelection
                          shortDescBinding="MSG_SELECT_ROW@cmpWizMsg"
                          selectedIndex="0"
                          >
                      </uix:singleSelection>
                    </uix:tableSelection>

                  </oem:table>
  
            </uix:case>
            <uix:case name="saved">
            <%--- Configurations result Table ---%>
                <oem:table name="savedConfigResult" blockSizeBinding="blockSize@pageData@servletRequest" width="98%"
                    dataSourceProp="savedConfigResultUI"
                    alternateTextBinding="MSG_NO_ITEMS_FOUND@cmpWizMsg"
                    showAll="yes">
                  <uix:tableSelection>
                    <uix:singleSelection
                        shortDescBinding="MSG_SELECT_ROW@cmpWizMsg"
                        selectedIndex="0"
                        >
                    </uix:singleSelection>
                  </uix:tableSelection>

                </oem:table>
            </uix:case>
            </uix:switcher>
          </uix:cellFormat>
        </uix:rowLayout>
  
        
      </uix:tableLayout>

      
    </uix:contents>
    </uix:stackLayout>
  </uix:dataScope>
</uix:buildTree>

<jsp:include page="/ecm/wizard/wizardPageTemplate.jsp"/>
