<%--
 * Copyright (c) 2004, 2005, Oracle. All rights reserved.  
 *
 * NAME
 *   multiConfigsComparisonSummary.jsp
 *
 * NOTES
 *   result page of multiple configurations comparison job.
 *
 * MODIFIED
 *    kchiasso   04/15/05 - set summary
 *    akskumar   03/28/05 - ui review fixes 
 *    akskumar   07/23/04 - akskumar_compare_config_wizard
 *    akskumar   07/16/2004 - Creation
--%>


<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:stackLayout>
  <uix:contents>
    <uix:header textBinding="pageHeader@multiConfigsComparisonSummaryBean@servletRequest" >
      <uix:spacer height="5" />
        <uix:rowLayout width="100%">
          <uix:contents>
            <uix:cellFormat hAlign="left" vAlign="top" width="60%">
              <uix:contents>
                <uix:rowLayout  styleClass="OraInstructionText">
                  <uix:labeledFieldLayout labelWidth="0" fieldWidth="0">
                    <uix:contents>
                      <uix:styledText
                      renderedBinding="displayTargetInfo@multiConfigsComparisonSummaryBean@servletRequest"
                        textBinding="comparedConfigTargetNameLabel@multiConfigsComparisonSummaryBean@servletRequest" />
                    </uix:contents>
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionTextStrong"
                        textBinding="comparedConfigText@multiConfigsComparisonSummaryBean@servletRequest" />
                    </uix:contents>
                  </uix:labeledFieldLayout>
                </uix:rowLayout>
<%--
                <uix:rowLayout  styleClass="OraInstructionText">
                  <uix:labeledFieldLayout labelWidth="0" fieldWidth="0">
                    <uix:contents>
                      <uix:styledText
                        textBinding="comparedConfigTargetTypeLabel@multiConfigsComparisonSummaryBean@servletRequest"/>
                    </uix:contents>
                    <uix:contents>
                      <uix:styledText styleClass="OraInstructionTextStrong"
                        textBinding="comparedConfigTargetType@multiConfigsComparisonSummaryBean@servletRequest" />
                    </uix:contents>
                  </uix:labeledFieldLayout>
                </uix:rowLayout>
--%>
              </uix:contents>
            </uix:cellFormat>
          </uix:contents>
        </uix:rowLayout>
      </uix:header>
      <uix:spacer height="5" />
      <uix:tableLayout width="80%">
        <uix:contents>
          <uix:rowLayout hAlign="right">
            <uix:contents>
              <uix:table name="multiConfigsComparisonSummaryTable"
                tableDataBinding="rows@multiConfigsComparisonSummaryInfo@multiConfigsComparisonSummaryBean@servletRequest"
                columnHeaderDataBinding="multiConfigsComparisonSummaryColumnHeaders@multiConfigsComparisonSummaryBean@servletRequest"
                blockSizeBinding="size@rows@multiConfigsComparisonSummaryInfo@multiConfigsComparisonSummaryBean@servletRequest"
                maxValueBinding="max@rows@multiConfigsComparisonSummaryInfo@multiConfigsComparisonSummaryBean@servletRequest"
                valueBinding="start@rows@multiConfigsComparisonSummaryInfo@multiConfigsComparisonSummaryBean@servletRequest"
                minValue="1"
                width="100%"
                alternateTextBinding="NO_DIFFERENCES_FOUND@TrackResourceBundle"
                summaryBinding="SUMMARY_DIFFERENCESFOUND@TrackResourceBundle"
                formSubmitted="true" >

                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                </uix:columnHeaderStamp>

                <uix:contents>
                  <uix:link textBinding="compResult"
                    destinationBinding="compResultURL"/>
                  <uix:link textBinding="configurationForTarget"
                    destinationBinding="configurationForTargetURL"/>
                  <uix:link textBinding="collectionTime"
                    destinationBinding="configurationURL"/>
                </uix:contents>
              </uix:table>
            </uix:contents>
          </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>
  </uix:contents>
</uix:stackLayout>
<uix:formValue name="jobType" value="GenericConfigsComparison"/>
