<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head
          titleBinding="TITLE_MULTIDELETE_SAVED_CONFIG@deleteSavedConfigsBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <uix:form name="deleteSavedConfigsForm" method="get" >
        <uix:formValue name="pageName" value="/ecm/config/deleteSavedConfigs"/>
        <uix:pageLayout
            titleBinding="HDR_MULTIDELETE_SAVED_CONFIG@deleteSavedConfigsBundle@servletRequest">

        <%@ include file="/oemGlobal.jspf" %>

          <oem:messageBox messageTypeBinding="errorType@servletRequest"
              titleTextKey="titleText"
              mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>

          <uix:stackLayout>

            <uix:tableLayout cellSpacing="5" width="100%">

              <uix:rowLayout>
                <uix:contents>
                      <uix:tableLayout cellSpacing="5" width="100%" hAlign = "left">

                        <%--- Search filter ---%>
                        <uix:rowLayout>
                        <uix:contents>
                            <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                        </uix:contents>
                        </uix:rowLayout>



                        <%--- Multi Delete Saved Configurations result Table ---%>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <oem:table name="deleteSavedConfigsResult"
                                id="deleteSavedConfigsResult"
                                formSubmitted="true"
                                blockSizeBinding="blockSize@defaultBean@servletRequest" width="100%"
                                dataSourceProp="deleteSavedConfigsResultUI"
                                alternateTextBinding="MSG_NO_ITEMS_FOUND@deleteSavedConfigsBundle@servletRequest"
                                showAll="yes">
                              <uix:tableSelection>
                                <uix:multipleSelection selectedBinding="selected"
                                    selectionBinding="selectionOld@defaultBean@servletRequest"
                                    shortDescBinding="MSG_SELECT_ROW@deleteSavedConfigsBundle@servletRequest">
                                </uix:multipleSelection>
                              </uix:tableSelection>

                            </oem:table>
                          </uix:cellFormat>
                        </uix:rowLayout>

                      </uix:tableLayout>
                </uix:contents>
              </uix:rowLayout>

              

            </uix:tableLayout>
          </uix:stackLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton name ="event" formName="deleteSavedConfigsForm" 
                  textBinding="CANCEL@sdkBundle@servletRequest"
                  value="cancel"/>
                <uix:submitButton name ="event" formName="deleteSavedConfigsForm" 
                  textBinding="OK@sdkBundle@servletRequest"
                  value="ok"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
